/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.javaweb.core.utils.HexUtils;

public class EncryptUtils {
    public static String md5(String context) {
        return DigestUtils.md5Hex((String)context);
    }

    public static String md5(byte[] bytes) {
        return DigestUtils.md5Hex((byte[])bytes);
    }

    public static String md5(InputStream in) throws IOException {
        return DigestUtils.md5Hex((InputStream)in);
    }

    public static String base64Encode(String str) {
        return new String(EncryptUtils.base64Encode(str.getBytes()));
    }

    public static byte[] base64Encode(byte[] bytes) {
        return Base64.encodeBase64((byte[])bytes);
    }

    public static String base64Decode(String str) {
        return new String(EncryptUtils.base64Decode(str.getBytes()));
    }

    public static byte[] base64Decode(byte[] bytes) {
        return Base64.decodeBase64((byte[])bytes);
    }

    public static String getAESKey(int length) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(length);
        SecretKey secretKey = keyGenerator.generateKey();
        return HexUtils.bytes2HexString(secretKey.getEncoded());
    }

    public static String encryptionAES(String content, String key) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(HexUtils.hex2Bytes(key), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKeySpec);
        return HexUtils.bytes2HexString(cipher.doFinal(content.getBytes()));
    }

    public static String decryptionAES(String content, String key) throws Exception {
        SecretKeySpec sKeySpec = new SecretKeySpec(HexUtils.hex2Bytes(key), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, sKeySpec);
        byte[] bytes = cipher.doFinal(HexUtils.hex2Bytes(content));
        return new String(bytes);
    }

    public static String decryptionRC4(byte[] data, String key) {
        if (data == null || key == null) {
            return null;
        }
        return new String(RC4.rc4Base(data, key));
    }

    public static byte[] encryptionRC4Byte(String data, String key) {
        try {
            return EncryptUtils.encryptionRC4Byte(data.getBytes("UTF-8"), key);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static byte[] encryptionRC4Byte(byte[] bytes, String key) {
        if (bytes == null || key == null) {
            return null;
        }
        return RC4.rc4Base(bytes, key);
    }

    private static final class RC4 {
        private RC4() {
        }

        private static byte[] initKey(String key) {
            byte[] bytes = null;
            try {
                bytes = key.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            byte[] state = new byte[256];
            for (int i = 0; i < 256; ++i) {
                state[i] = (byte)i;
            }
            int index1 = 0;
            int index2 = 0;
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            for (int i = 0; i < 256; ++i) {
                index2 = (bytes[index1] & 0xFF) + (state[i] & 0xFF) + index2 & 0xFF;
                byte tmp = state[i];
                state[i] = state[index2];
                state[index2] = tmp;
                index1 = (index1 + 1) % bytes.length;
            }
            return state;
        }

        private static byte[] rc4Base(byte[] input, String key) {
            int x = 0;
            int y = 0;
            byte[] arr = RC4.initKey(key);
            byte[] result = new byte[input.length];
            for (int i = 0; i < input.length; ++i) {
                x = x + 1 & 0xFF;
                y = (arr[x] & 0xFF) + y & 0xFF;
                byte tmp = arr[x];
                arr[x] = arr[y];
                arr[y] = tmp;
                int xorIndex = (arr[x] & 0xFF) + (arr[y] & 0xFF) & 0xFF;
                result[i] = (byte)(input[i] ^ arr[xorIndex]);
            }
            return result;
        }
    }
}

