/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.javaweb.core.utils.IOUtils;
import org.javaweb.core.utils.StringUtils;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    protected static FileUtils fileUtils = new FileUtils();

    public static String getFileSuffix(String str) {
        return str.substring(str.lastIndexOf(".") + 1, str.length());
    }

    public static URL getPackageResourcePath(String path) {
        return ((Object)((Object)fileUtils)).getClass().getClassLoader().getResource(path);
    }

    public static File getCurrentDirectory() {
        File file = new File(".");
        if (file.getParent() != null) {
            return file.getParentFile();
        }
        return new File(System.getProperty("user.dir"));
    }

    public static InputStream getPackageResourceAsStream(String path) {
        return ((Object)((Object)fileUtils)).getClass().getResourceAsStream(path);
    }

    public static Properties getProperties(File f) throws FileNotFoundException {
        return FileUtils.getProperties(new FileInputStream(f));
    }

    public static InputStream getResourceFromJarFile(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            return jarConnection.getInputStream();
        }
        throw new IOException("URL \u534f\u8bae\u7c7b\u578b\u5fc5\u987b\u662fJarURLConnection.");
    }

    public static Properties getProperties(InputStream in) {
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return p;
    }

    public static String fileSplitHandle(String path) {
        if (StringUtils.isNotEmpty((String)path)) {
            return (path.trim().replaceAll("\\\\", "/") + "/").replaceAll("/+", "/");
        }
        return path;
    }
}

