/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.HexDump;

public class HexUtils
extends Hex {
    public static String bytes2HexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            sb.append(hex.length() == 1 ? '0' + hex : hex.toUpperCase());
        }
        return sb.toString();
    }

    public static String string2Hex(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(Integer.toHexString(s.charAt(i)));
        }
        return sb.toString();
    }

    public static String hex2String(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length() - 1; i += 2) {
            String s = String.valueOf(str.charAt(i)) + str.charAt(i + 1);
            sb.append((char)Integer.parseInt(s, 16));
        }
        return sb.toString();
    }

    public static byte[] hex2Bytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static byte[] hexDump(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            HexDump.dump((byte[])data, (long)data.length, (OutputStream)baos, (int)0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static String replaceHexWithDate(String sqlLine) throws ParseException {
        Pattern castPattern = Pattern.compile("(CAST\\()(0x[A-Fa-f0-9]{16})( AS DateTime\\))");
        Matcher m = castPattern.matcher(sqlLine);
        while (m.find()) {
            String s = m.group(2);
            sqlLine = sqlLine.replace(s, "'" + HexUtils.sqlServerHexToSqlDate(s) + "'");
        }
        return sqlLine;
    }

    public static String sqlServerHexToSqlDate(String hexString) throws ParseException {
        return HexUtils.sqlServerHexToSqlDate(hexString, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String sqlServerHexToSqlDate(String hexString, String dateFormat) throws ParseException {
        String hexNumber = hexString.substring(2);
        String dateHex = hexNumber.substring(0, 8);
        String timeHex = hexNumber.substring(8, 16);
        long daysToAdd = Long.parseLong(dateHex, 16);
        long millisToAdd = Long.parseLong(timeHex, 16) * 10L / 3L;
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Calendar startingCal = Calendar.getInstance();
        String startingDate = "1900-01-01 00:00:00.000";
        startingCal.setTime(sdf.parse(startingDate));
        Calendar convertedCal = Calendar.getInstance();
        convertedCal.setTime(sdf.parse(startingDate));
        convertedCal.add(5, (int)daysToAdd);
        convertedCal.setTimeInMillis(convertedCal.getTimeInMillis() + millisToAdd);
        return sdf.format(convertedCal.getTime());
    }
}

