/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javaweb.core.utils.EncryptUtils;
import org.javaweb.core.utils.HttpServletRequestUtils;
import org.javaweb.core.utils.StringUtils;

public class HighlightUtils {
    public static String highlight(String content, String keyword, int maxlen) {
        if (StringUtils.isNotEmpty((String)content) && StringUtils.isNotEmpty((String)keyword) && maxlen > 0) {
            keyword = keyword.trim();
            content = HighlightUtils.searchResultExtraction(HttpServletRequestUtils.htmlSpecialChars(content), keyword, maxlen);
            HashSet<String> ls = new HashSet<String>();
            ls.add(keyword);
            ls.add(EncryptUtils.md5(keyword));
            if (keyword.matches("\\W+")) {
                String[] strs;
                for (String temp : strs = keyword.split("\\W+")) {
                    ls.add(temp.trim());
                }
            }
            for (String s : ls) {
                content = content.replace(s, "<em>" + s + "</em>");
            }
            return content;
        }
        return content;
    }

    public static String searchResultExtraction(String content, String keyword, int maxlen) {
        if (StringUtils.isNotEmpty((String)content) && StringUtils.isNotEmpty((String)keyword) && content.length() > maxlen) {
            Matcher matcher = Pattern.compile(Pattern.quote(keyword), 34).matcher(content);
            if (matcher.find()) {
                String start = content.substring(0, matcher.end());
                String end = content.substring(start.length());
                start = start.contains("\n") ? start.substring(start.indexOf("\n") + 1) : start;
                StringBuilder sb = new StringBuilder();
                if (start.length() > maxlen) {
                    int preLength;
                    int prePosition = 0;
                    Matcher preMatcher = Pattern.compile("\r?\n|\u3002").matcher(start);
                    if (preMatcher.find()) {
                        prePosition = preMatcher.end();
                    }
                    if ((preLength = start.length() - prePosition) > maxlen) {
                        prePosition = start.length() - maxlen / 2;
                    }
                    sb.append(start.substring(prePosition));
                } else {
                    sb.append(start);
                }
                sb.append(end);
                return sb.length() > maxlen ? sb.substring(0, maxlen) + "..." : sb.toString();
            }
            return content.substring(0, maxlen) + "...";
        }
        return content;
    }
}

