/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.javaweb.core.net.HttpRequest;
import org.javaweb.core.net.HttpResponse;
import org.javaweb.core.net.HttpURLRequest;
import org.javaweb.core.net.MultipartRequest;
import org.javaweb.core.utils.BytesEncodingDetect;
import org.javaweb.core.utils.IOUtils;
import org.javaweb.core.utils.SslUtils;
import org.javaweb.core.utils.StringUtils;

public class HttpRequestUtils {
    private static final Pattern HTML_CHARSET_PATTERN = Pattern.compile("(?i)<meta.*\\bcharset\\s*=\\s*(?:\"|')?([^\\s,;\"']*)");

    public static String getFileType(URL url) {
        String path = "".equals(url.getPath()) ? "/" : url.getPath();
        String file = path.substring(path.lastIndexOf("/"));
        return file.substring(file.lastIndexOf(".") + 1, file.length());
    }

    public static String toURLParameterString(Map<String, String> args, String encoding) {
        StringBuilder sb = new StringBuilder();
        if (args != null) {
            int i = 0;
            for (String a : args.keySet()) {
                try {
                    if (i > 0) {
                        sb.append("&");
                    }
                    ++i;
                    sb.append(a).append("=").append(URLEncoder.encode(args.get(a), encoding));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static String getCharsetFromHTMLBody(String html) {
        Matcher m;
        String encoding = null;
        if (html != null && (m = HTML_CHARSET_PATTERN.matcher(html)).find()) {
            String charset = m.group(1).trim();
            if ((charset = charset.replace("charset=", "")).length() == 0) {
                return null;
            }
            try {
                if (Charset.isSupported(charset)) {
                    encoding = charset.toUpperCase(Locale.ENGLISH);
                }
            }
            catch (IllegalCharsetNameException e) {
                return null;
            }
        }
        return encoding;
    }

    public static String parseHTMLCharset(byte[] bodyByte) {
        String encoding = HttpRequestUtils.getCharsetFromHTMLBody(new String(bodyByte));
        if (encoding == null) {
            int code = new BytesEncodingDetect().detectEncoding(bodyByte);
            encoding = BytesEncodingDetect.htmlname[code];
        }
        return encoding != null ? encoding : "UTF-8";
    }

    public static void setRequestProperties(HttpURLConnection httpURLConnection, HttpRequest request) throws IOException {
        httpURLConnection.setConnectTimeout(request.getTimeout());
        httpURLConnection.setReadTimeout(request.getTimeout());
        HttpURLConnection.setFollowRedirects(request.isFollowRedirects());
        if (StringUtils.isNotEmpty((String)request.getMethod()) && !(request instanceof MultipartRequest)) {
            if (!"GET".equalsIgnoreCase(request.getMethod())) {
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
            }
            httpURLConnection.setRequestMethod(request.getMethod().toUpperCase());
        }
        if (StringUtils.isNotEmpty((String)request.getCookie())) {
            httpURLConnection.setRequestProperty("Cookie", request.getCookie());
        }
        if (StringUtils.isNotEmpty((String)request.getUserAgent())) {
            httpURLConnection.setRequestProperty("User-Agent", request.getUserAgent());
        }
        if (StringUtils.isNotEmpty((String)request.getReferer())) {
            httpURLConnection.setRequestProperty("Referer", request.getReferer());
        }
    }

    public static void setRequestData(HttpURLConnection httpURLConnection, HttpURLRequest request, String data) throws IOException {
        Map<String, String> headers = request.getRequestHeader();
        for (String key : headers.keySet()) {
            httpURLConnection.setRequestProperty(key, headers.get(key));
        }
        if (StringUtils.isNotEmpty((String)request.getMethod()) && !"GET".equalsIgnoreCase(request.getMethod()) && (StringUtils.isNotEmpty((String)data) || StringUtils.isNotEmpty((String)request.getRequestBae64InputStream()))) {
            OutputStream out = httpURLConnection.getOutputStream();
            if (StringUtils.isNotEmpty((String)request.getRequestBae64InputStream())) {
                out.write(Base64.decodeBase64((String)request.getRequestBae64InputStream()));
            } else {
                out.write(data.getBytes());
            }
            out.flush();
            out.close();
        }
    }

    public static void setResponse(HttpURLConnection httpURLConnection, HttpResponse response) throws IOException {
        response.setStatusCode(httpURLConnection.getResponseCode());
        response.setStatusMessage(httpURLConnection.getResponseMessage());
        response.setContentType(httpURLConnection.getContentType());
        response.setHeader((Map<String, List<String>>)new CaseInsensitiveMap(httpURLConnection.getHeaderFields()));
        response.setLastModified(httpURLConnection.getLastModified());
        HttpRequestUtils.setCookies(response);
    }

    private static void setCookies(HttpResponse response) {
        String val;
        String key;
        String[] temp;
        String cookieString = response.getRequest().getCookie();
        if (StringUtils.isNotEmpty((String)cookieString)) {
            String[] cookies = cookieString.split(";\\s?");
            LinkedHashMap<String, String> cookieMap = new LinkedHashMap<String, String>();
            for (String cookie : cookies) {
                temp = cookie.split("=");
                if (temp.length == 2) {
                    key = temp[0];
                    val = temp[1];
                    cookieMap.put(key, val);
                    continue;
                }
                if (temp.length != 1) continue;
                cookieMap.put(temp[0], "");
            }
            response.setCookies(cookieMap);
        }
        if (response.getHeader() == null) {
            return;
        }
        for (String name : response.getHeader().keySet()) {
            if (StringUtils.isEmpty((String)name) || !"Set-Cookie".equalsIgnoreCase(name)) continue;
            List<String> values = response.getHeader().get(name);
            for (String value : values) {
                String[] strs;
                if (value == null || (strs = value.split(";")).length <= 0) continue;
                temp = strs[0].split("=");
                if (temp.length == 2) {
                    key = temp[0];
                    val = temp[1];
                    if (val.equalsIgnoreCase("deleted")) {
                        response.removeCookie(key);
                        continue;
                    }
                    response.cookie(key, val);
                    continue;
                }
                if (temp.length != 1) continue;
                response.cookie(temp[0], "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse httpRequest(HttpURLRequest request) {
        HttpURLConnection httpURLConnection = null;
        InputStream in = null;
        HttpResponse response = new HttpResponse(request.getUrl());
        try {
            response.setRequestTime(System.currentTimeMillis());
            try {
                response.dnsParse();
                String protocol = request.getUrl().getProtocol();
                if (!protocol.equals("http") && !protocol.equals("https")) {
                    throw new MalformedURLException("\u53ea\u652f\u6301 http & https \u8bf7\u6c42\u534f\u8bae.");
                }
                if ("https".equalsIgnoreCase(protocol)) {
                    SslUtils.ignoreSsl();
                }
                String data = null;
                data = request.getRequestDataMap() != null && request.getRequestDataMap().size() > 0 ? HttpRequestUtils.toURLParameterString(request.getRequestDataMap(), request.getCharset()) : request.getRequestData();
                URL url = request.getUrl();
                if ("GET".equalsIgnoreCase(request.getMethod()) && StringUtils.isNotEmpty((String)data)) {
                    url = new URL(request.getUrl() + (StringUtils.isNotEmpty((String)request.getUrl().getQuery()) ? "&" : "?") + data);
                }
                httpURLConnection = (HttpURLConnection)url.openConnection();
                HttpRequestUtils.setRequestProperties(httpURLConnection, request);
                HttpRequestUtils.setRequestData(httpURLConnection, request, data);
                httpURLConnection.connect();
                response.setRequest(request);
                HttpRequestUtils.setResponse(httpURLConnection, response);
                try {
                    in = httpURLConnection.getInputStream();
                }
                catch (IOException e) {
                    in = httpURLConnection.getErrorStream();
                }
                if (in != null) {
                    response.setBase64Data(Base64.encodeBase64String((byte[])IOUtils.inputStreamToByteArray(in)));
                }
            }
            catch (UnknownHostException e) {
                response.setExceptionName(e.toString());
            }
        }
        catch (IOException e) {
            response.setExceptionName(e.toString());
        }
        finally {
            IOUtils.closeQuietly(in);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            response.setResponseTime(System.currentTimeMillis());
        }
        return response;
    }

    public static boolean isDomain(String url) {
        String strRegex = "^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}$";
        return Pattern.compile(strRegex, 2).matcher(url).find();
    }

    public static boolean isWebSite(String url) {
        String strRegex = "^((https|http)?://)(([0-9]{1,3}.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z].[a-z]{2,6})(:[0-9]{1,4})?((/?)|(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$";
        return Pattern.compile(strRegex, 2).matcher(url).find();
    }

    public static boolean isHost(String url) {
        String strRegexIp = "^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}$";
        String strRegexDomain = "^(2[0-5]{2}|2[0-4][0-9]|1?[0-9]{1,2}).(2[0-5]{2}|2[0-4][0-9]|1?[0-9]{1,2}).(2[0-5]{2}|2[0-4][0-9]|1?[0-9]{1,2}).(2[0-5]{2}|2[0-4][0-9]|1?[0-9]{1,2})$";
        return Pattern.compile(strRegexIp, 2).matcher(url).find() || Pattern.compile(strRegexDomain, 2).matcher(url).find();
    }
}

