/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.javaweb.core.utils.FileUtils;
import org.javaweb.core.utils.IPV4Utils;
import org.javaweb.core.utils.MultipartFile;
import org.javaweb.core.utils.StringUtils;
import org.javaweb.core.utils.URLCanonicalizerUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class HttpServletRequestUtils {
    private static final Logger LOG = Logger.getLogger("info");
    protected static HttpServletRequestUtils httpServletRequestUtils = new HttpServletRequestUtils();

    public static String getDocumentRoot(HttpServletRequest request) {
        String webRoot = request.getSession().getServletContext().getRealPath("/");
        if (webRoot == null) {
            URL url = httpServletRequestUtils.getClass().getClassLoader().getResource("/");
            if (url == null) {
                try {
                    url = new File(".").toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOG.info(e.toString());
                }
            }
            webRoot = webRoot.substring(0, (webRoot = URLCanonicalizerUtils.getCanonicalURL(url.toString())).contains("WEB-INF") ? webRoot.lastIndexOf("WEB-INF") : webRoot.length());
        }
        return FileUtils.fileSplitHandle(webRoot);
    }

    public static String getClassPathResource() throws IOException {
        ClassPathResource resource = new ClassPathResource("/");
        return resource.getFile().getAbsolutePath();
    }

    public static String getClassPathResource(String path) throws IOException {
        ClassPathResource resource = new ClassPathResource(path);
        return resource.getFile().getAbsolutePath();
    }

    public static String getHttpRequestFileRealPath(HttpServletRequest request) {
        String documentRoot = HttpServletRequestUtils.getDocumentRoot(request);
        String path = documentRoot + request.getServletPath();
        return path.replaceAll("/+", "/");
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getRemoteAddr();
        String xRealIp = request.getHeader("x-real-ip");
        String xForwardedFor = request.getHeader("x-forwarded-for");
        if (ip.equals(request.getLocalAddr()) || IPV4Utils.isLanIp(ip)) {
            ip = IPV4Utils.isValid(xRealIp) ? xRealIp : (IPV4Utils.isValid(xForwardedFor) ? xForwardedFor : ip);
        }
        return ip.startsWith("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public static String getAsciiEncoding(String str, String key) {
        for (String s : key.split(",")) {
            str = str.replaceAll("(?i)(" + s + ")", s.replace("" + s.charAt(0), "&#" + s.charAt(0) + ";"));
        }
        return str;
    }

    public static String getParameter(HttpServletRequest request, String name) {
        String[] strs;
        Map parameterMap = request.getParameterMap();
        if (parameterMap.containsKey(name) && (strs = (String[])parameterMap.get(name)).length == 1) {
            return HttpServletRequestUtils.htmlSpecialChars(strs[0]);
        }
        return request.getParameter(name);
    }

    public static String htmlSpecialChars(String content) {
        if (content != null) {
            char[] arr = content.toCharArray();
            StringBuilder sb = new StringBuilder();
            block7: for (int i = 0; i < arr.length; ++i) {
                switch (arr[i]) {
                    case '&': {
                        sb.append("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        sb.append("&#039;");
                        continue block7;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block7;
                    }
                    default: {
                        sb.append(arr[i]);
                    }
                }
            }
            return sb.toString();
        }
        return content;
    }

    public static String queryStringEscape(String queryString) {
        if (queryString != null) {
            char[] arr = queryString.toCharArray();
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < arr.length; ++i) {
                switch (arr[i]) {
                    case '\"': {
                        sb.append("&quot;");
                        continue block6;
                    }
                    case '\'': {
                        sb.append("&#039;");
                        continue block6;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block6;
                    }
                    default: {
                        sb.append(arr[i]);
                    }
                }
            }
            return sb.toString();
        }
        return queryString;
    }

    public static void htmlSpecialChars(Object[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) continue;
            obj[i] = HttpServletRequestUtils.htmlSpecialChars(obj[i].toString());
        }
    }

    public static HttpServletRequest getCurrentHttpServletRequest() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpServletResponse getCurrentHttpServletResponse() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HttpSession getCurrentHttpSession() {
        HttpServletRequest request = HttpServletRequestUtils.getCurrentHttpServletRequest();
        if (request != null) {
            return HttpServletRequestUtils.getCurrentHttpServletRequest().getSession();
        }
        return null;
    }

    public static String getToken(HttpServletRequest request) {
        Object obj = request.getSession().getAttribute("token");
        String token = null;
        if (StringUtils.isNotEmpty(obj)) {
            token = (String)obj;
        } else {
            token = StringUtils.getRandomString(32);
            request.getSession().setAttribute("token", (Object)token);
        }
        return token;
    }

    public static boolean isAllowedFileName(CommonsMultipartFile commonsMultipartFile) {
        if (commonsMultipartFile != null) {
            String fileName = commonsMultipartFile.getOriginalFilename();
            if (fileName.indexOf(0) != -1) {
                return false;
            }
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
            if (Pattern.compile("asp|asa|cer|jsp|php", 34).matcher(fileExt).find()) {
                return false;
            }
        }
        return true;
    }

    public static MultipartFile uploadCommonsMultipartFile(HttpServletRequest request, CommonsMultipartFile docFile) {
        return HttpServletRequestUtils.uploadCommonsMultipartFile(request, docFile, false);
    }

    public static MultipartFile uploadCommonsMultipartFile(HttpServletRequest request, CommonsMultipartFile docFile, boolean anySuffixFile) {
        MultipartFile multipart = new MultipartFile();
        if (anySuffixFile || HttpServletRequestUtils.isAllowedFileName(docFile)) {
            String dateDirName = new SimpleDateFormat("yyyyMMdd").format(new Date());
            String savePath = request.getSession().getServletContext().getRealPath("/") + "uploads/files/" + dateDirName + "/";
            String saveUrl = request.getContextPath() + "/uploads/files/" + dateDirName + "/";
            String fileName = docFile.getOriginalFilename();
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String newFileName = df.format(new Date()) + "_" + new Random().nextInt(1000) + "." + fileExt;
            File uploadedFile = new File(savePath, newFileName);
            if (!uploadedFile.getParentFile().exists()) {
                uploadedFile.getParentFile().mkdirs();
            }
            try {
                docFile.transferTo(uploadedFile);
            }
            catch (IOException e) {
                LOG.info("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38:" + e.toString());
            }
            multipart.setOriginalFilename(docFile.getOriginalFilename());
            multipart.setFilename(newFileName);
            multipart.setSize(docFile.getSize());
            multipart.setPath(uploadedFile.getAbsolutePath());
            multipart.setUrl(saveUrl + newFileName);
        }
        return multipart;
    }

    public static String getWebBaseUrlPath(HttpServletRequest request) {
        String portStr = request.getServerPort() != 80 && request.getServerPort() != -1 ? ":" + request.getServerPort() : "";
        return request.getScheme() + "://" + request.getServerName() + portStr + request.getContextPath() + "/";
    }
}

