/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.javaweb.core.utils.EncryptUtils;
import org.javaweb.core.utils.IOUtils;
import org.javaweb.core.utils.ImageInfo;
import org.javaweb.core.utils.ImageUtils;

public class HttpServletResponseUtils {
    public static void responseJson(HttpServletResponse response, String text) {
        HttpServletResponseUtils.response(response, "application/json;charset=UTF-8", text);
    }

    public static void responseJson(HttpServletResponse response, Object obj) {
        HttpServletResponseUtils.response(response, "application/json;charset=UTF-8", JSON.toJSONString((Object)obj));
    }

    public static void responseXml(HttpServletResponse response, String text) {
        HttpServletResponseUtils.response(response, "text/xml;charset=UTF-8", text);
    }

    public static void responseJS(HttpServletResponse response, String text) {
        HttpServletResponseUtils.response(response, "application/javascript;charset=UTF-8", text);
    }

    public static void responseRc4Json(HttpServletResponse response, Object obj, String RC4Key) {
        try {
            HttpServletResponseUtils.response(response, "application/json;charset=UTF-8", new String(Base64.encodeBase64((byte[])EncryptUtils.encryptionRC4Byte(JSON.toJSONString((Object)obj), RC4Key)), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void responseHTML(HttpServletResponse response, String text) {
        HttpServletResponseUtils.response(response, "text/html;charset=UTF-8", text);
    }

    public static void responseText(HttpServletResponse response, String text) {
        HttpServletResponseUtils.response(response, "text/plain;charset=UTF-8", text);
    }

    public static void download(HttpServletResponse response, File file) throws IOException {
        HttpServletResponseUtils.download(response, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void download(HttpServletResponse response, File file, String fileName) throws IOException {
        block12: {
            FileInputStream in = null;
            try {
                block13: {
                    if (!file.exists() || !file.canRead()) break block13;
                    FileInputStream fis = null;
                    ImageInfo info = null;
                    try {
                        fis = new FileInputStream(file);
                        info = ImageUtils.getImageInfo(fis);
                    }
                    catch (IOException iOException) {
                        IOUtils.closeQuietly((InputStream)fis);
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fis);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                    String string = fileName = fileName != null ? fileName : file.getName();
                    if (info != null && (info.getHeight() > 0 || info.getWidth() > 0)) {
                        response.setContentType(info.getMimeType());
                    } else {
                        response.setContentType("application/octet-stream");
                        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
                    }
                    in = new FileInputStream(file);
                    ServletOutputStream out = response.getOutputStream();
                    byte[] bytes = new byte[4096];
                    int a = -1;
                    while ((a = in.read(bytes)) != -1) {
                        out.write(bytes, 0, a);
                    }
                    out.flush();
                    IOUtils.closeQuietly((OutputStream)out);
                    break block12;
                }
                HttpServletResponseUtils.responseText(response, "\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
    }

    public static void response(HttpServletResponse response, String contentType, byte[] bytes) throws IOException {
        response.setContentType(contentType);
        ServletOutputStream out = response.getOutputStream();
        out.write(bytes);
        out.flush();
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void response(HttpServletResponse response, String contentType, InputStream in) throws IOException {
        try {
            response.setContentType(contentType);
            ServletOutputStream out = response.getOutputStream();
            byte[] bytes = new byte[4096];
            int a = -1;
            while ((a = in.read(bytes)) != -1) {
                out.write(bytes, 0, a);
            }
            out.flush();
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static void response(HttpServletResponse response, String contentType, String text) {
        response.setContentType(contentType);
        if (text != null) {
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.write(text);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

