/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    public static String inputStreamToString(InputStream in) throws IOException {
        int a;
        byte[] b = new byte[1024];
        StringBuilder sb = new StringBuilder();
        while ((a = in.read(b)) != -1) {
            sb.append(new String(b, 0, a));
        }
        return sb.toString();
    }

    public static byte[] inputStreamToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int a = 0;
        byte[] b = new byte[1024];
        while ((a = in.read(b)) != -1) {
            baos.write(b, 0, a);
        }
        return baos.toByteArray();
    }

    public static String readFileToString(String path) throws IOException {
        return IOUtils.inputStreamToString(new FileInputStream(path));
    }

    public static byte[] gunZip(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        GZIPInputStream unGZip = new GZIPInputStream(in);
        return IOUtils.toByteArray((InputStream)unGZip);
    }

    public static byte[] decompressInflater(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[2048];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            out.write(buffer, 0, count);
        }
        return out.toByteArray();
    }
}

