/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class IPSeekerUtils {
    private static final Logger LOG = Logger.getLogger("info");
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte AREA_FOLLOWED = 1;
    private static final byte NO_AREA = 2;
    private static volatile IPSeekerUtils instance;
    private final Hashtable<String, IPLocation> ipCache = new Hashtable();
    private final IPLocation loc = new IPLocation();
    private final byte[] b4 = new byte[4];
    private final byte[] b3 = new byte[3];
    private String IP_FILE = null;
    private RandomAccessFile ipFile;
    private MappedByteBuffer mbb;
    private long ipBegin;
    private long ipEnd;

    private IPSeekerUtils() {
        try {
            String filepath = this.getClass().getClassLoader().getResource("/qqwry.dat").getPath();
            this.ipFile = new RandomAccessFile(filepath, "r");
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                LOG.info("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6\u683c\u5f0f\u6709\u9519\u8bef\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528");
                this.ipFile = null;
            }
        }
        catch (FileNotFoundException e) {
            LOG.info("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6" + this.IP_FILE + "\u6ca1\u6709\u627e\u5230\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528");
            this.ipFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPSeekerUtils getInstance() {
        if (instance != null) return instance;
        Class<IPSeekerUtils> clazz = IPSeekerUtils.class;
        synchronized (IPSeekerUtils.class) {
            if (instance != null) return instance;
            instance = new IPSeekerUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected int readInt3(int offset) {
        this.mbb.position(offset);
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.mbb.getInt() & 0xFFFFFF;
    }

    public String getCountry(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        String ipStr = this.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation loc = this.ipCache.get(ipStr);
            return loc.country;
        }
        IPLocation loc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, loc.getCopy());
        return loc.country;
    }

    private byte[] getIpByteArrayFromString(String ip) {
        byte[] ret = new byte[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        try {
            ret[0] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ret[1] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ret[2] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ret[3] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
        }
        catch (Exception e) {
            LOG.info("\u4eceip\u7684\u5b57\u7b26\u4e32\u5f62\u5f0f\u5f97\u5230\u5b57\u8282\u6570\u7ec4\u5f62\u5f0f\u62a5\u9519:" + e.toString());
        }
        return ret;
    }

    private String getIpStringFromBytes(byte[] ip) {
        StringBuilder sb = new StringBuilder();
        sb.delete(0, sb.length());
        sb.append(ip[0] & 0xFF);
        sb.append('.');
        sb.append(ip[1] & 0xFF);
        sb.append('.');
        sb.append(ip[2] & 0xFF);
        sb.append('.');
        sb.append(ip[3] & 0xFF);
        return sb.toString();
    }

    private String getString(byte[] b, int offset, int len, String encoding) {
        try {
            return new String(b, offset, len, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(b, offset, len);
        }
    }

    public String getCountry(String ip) {
        return this.getCountry(this.getIpByteArrayFromString(ip));
    }

    public String getArea(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        String ipStr = this.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation loc = this.ipCache.get(ipStr);
            return loc.area;
        }
        IPLocation loc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, loc.getCopy());
        return loc.area;
    }

    public String getArea(String ip) {
        return this.getArea(this.getIpByteArrayFromString(ip));
    }

    private IPLocation getIPLocation(byte[] ip) {
        IPLocation info = null;
        long offset = this.locateIP(ip);
        if (offset != -1L) {
            info = this.getIPLocation(offset);
        }
        if (info == null) {
            info = new IPLocation();
            info.country = "\u672a\u77e5\u56fd\u5bb6";
            info.area = "\u672a\u77e5\u5730\u533a";
        }
        return info;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    protected void readIP(int offset, byte[] ip) {
        this.mbb.position(offset);
        this.mbb.get(ip);
        byte temp = ip[0];
        ip[0] = ip[3];
        ip[3] = temp;
        temp = ip[1];
        ip[1] = ip[2];
        ip[2] = temp;
    }

    private int compareIP(byte[] ip, byte[] beginIp) {
        for (int i = 0; i < 4; ++i) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIP(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIP(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IPLocation getIPLocation(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.country = this.readString(this.readLong3());
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.country = this.readString(countryOffset);
                }
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            } else if (b == 2) {
                this.loc.country = this.readString(this.readLong3());
                this.loc.area = this.readArea(offset + 8L);
            } else {
                this.loc.country = this.readString(this.ipFile.getFilePointer() - 1L);
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            }
            return this.loc;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IPLocation getIPLocation(int offset) {
        this.mbb.position(offset + 4);
        byte b = this.mbb.get();
        if (b == 1) {
            int countryOffset = this.readInt3();
            this.mbb.position(countryOffset);
            b = this.mbb.get();
            if (b == 2) {
                this.loc.country = this.readString(this.readInt3());
                this.mbb.position(countryOffset + 4);
            } else {
                this.loc.country = this.readString(countryOffset);
            }
            this.loc.area = this.readArea(this.mbb.position());
        } else if (b == 2) {
            this.loc.country = this.readString(this.readInt3());
            this.loc.area = this.readArea(offset + 8);
        } else {
            this.loc.country = this.readString(this.mbb.position() - 1);
            this.loc.area = this.readArea(this.mbb.position());
        }
        return this.loc;
    }

    private String readArea(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readArea(int offset) {
        this.mbb.position(offset);
        byte b = this.mbb.get();
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt3();
            if (areaOffset == 0) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            byte[] buf = new byte[256];
            while ((buf[i] = this.ipFile.readByte()) != 0) {
                if (++i < buf.length) continue;
                byte[] tmp = new byte[i + 100];
                System.arraycopy(buf, 0, tmp, 0, i);
                buf = tmp;
            }
            if (i != 0) {
                return this.getString(buf, 0, i, "GBK");
            }
        }
        catch (IOException e) {
            LOG.info(e.toString());
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.mbb.position(offset);
            int i = 0;
            byte[] buf = new byte[256];
            while ((buf[i] = this.mbb.get()) != 0) {
                if (++i < buf.length) continue;
                byte[] tmp = new byte[i + 100];
                System.arraycopy(buf, 0, tmp, 0, i);
                buf = tmp;
            }
            if (i != 0) {
                return this.getString(buf, 0, i, "GBK");
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        return "";
    }

    public String getAddress(String ip) {
        String country = this.getCountry(ip).equals(" CZ88.NET") ? "" : this.getCountry(ip);
        String area = this.getArea(ip).equals(" CZ88.NET") ? "" : this.getArea(ip);
        String address = country + " " + area;
        return address.trim();
    }

    private class IPLocation {
        public String country = "";
        public String area = "";

        public IPLocation getCopy() {
            IPLocation ret = new IPLocation();
            ret.country = this.country;
            ret.area = this.area;
            return ret;
        }
    }
}

