/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.javaweb.core.utils.FileUtils;

public class IPToLocationUtils {
    public static final Map<String, String> COUNTRY_CODE_MAP = new HashMap<String, String>();
    private static final String[] countries = new String[]{"RW=\u5362\u65fa\u8fbe", "SO=\u7d22\u9a6c\u91cc", "YE=\u4e5f\u95e8", "IQ=\u4f0a\u62c9\u514b", "SA=\u6c99\u7279\u963f\u62c9\u4f2f", "IR=\u4f0a\u6717\u4f0a\u65af\u5170\u5171\u548c\u56fd", "CY=\u585e\u6d66\u8def\u65af", "TZ=\u5766\u6851\u5c3c\u4e9a", "SY=\u53d9\u5229\u4e9a", "AM=\u4e9a\u7f8e\u5c3c\u4e9a", "KE=\u80af\u5c3c\u4e9a", "CD=\u624e\u4f0a\u5c14", "DJ=\u5409\u5e03\u63d0", "UG=\u4e4c\u5e72\u8fbe", "CF=\u4e2d\u975e\u5171\u548c\u56fd", "SC=\u585e\u820c\u5c14\u7fa4\u5c9b", "JO=\u7ea6\u65e6", "LB=\u9ece\u5df4\u5ae9", "KW=\u79d1\u5a01\u7279", "OM=\u963f\u66fc", "QA=\u5361\u5854\u5c14", "BH=\u5df4\u6797", "AE=\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd", "IL=\u4ee5\u8272\u5217", "TR=\u571f\u8033\u5176", "ET=\u57c3\u585e\u4fc4\u6bd4\u4e9a", "ER=\u5384\u7acb\u7279\u91cc\u4e9a", "EG=\u57c3\u53ca", "SD=\u82cf\u4e39", "GR=\u5e0c\u814a", "BI=\u5e03\u9686\u8fea", "EE=\u7231\u6c99\u5c3c\u4e9a", "LV=\u62c9\u8131\u7ef4\u4e9a", "AZ=\u963f\u585e\u62dc\u7586", "LT=\u7acb\u9676\u5b9b", "SJ=\u65af\u74e6\u5c14\u5df4\u7279\u548c\u626c\u9a6c\u5ef6", "GE=\u683c\u9c81\u5409\u4e9a", "MD=\u6469\u5c14\u591a\u74e6\u5171\u548c\u56fd", "BY=\u767d\u4fc4\u7f57\u65af", "FI=\u82ac\u5170", "AX=\u5965\u5170\u7fa4\u5c9b", "UA=\u4e4c\u514b\u5170", "MK=\u524d\u5357\u65af\u62c9\u592b\u9a6c\u5176\u987f\u5171\u548c\u56fd", "HU=\u5308\u7259\u5229", "BG=\u4fdd\u52a0\u5229\u4e9a", "AL=\u963f\u5c14\u5df4\u5c3c\u4e9a", "PL=\u6ce2\u5170", "RO=\u7f57\u9a6c\u5c3c\u4e9a", "XK=\u79d1\u7d22\u6c83", "ZW=\u6d25\u5df4\u5e03\u97e6", "ZM=\u8d5e\u6bd4\u4e9a", "KM=\u79d1\u6469\u7f57", "MW=\u9a6c\u62c9\u7ef4", "LS=\u83b1\u7d22\u6258", "BW=\u535a\u8328\u74e6\u7eb3", "MU=\u6bdb\u91cc\u6c42\u65af", "SZ=\u65af\u5a01\u58eb\u5170", "RE=\u7559\u5c3c\u6c6a", "ZA=\u5357\u975e", "YT=\u9a6c\u7ea6\u7279", "MZ=\u83ab\u6851\u6bd4\u514b", "MG=\u9a6c\u8fbe\u52a0\u65af\u52a0", "AF=\u963f\u5bcc\u6c57", "PK=\u5df4\u57fa\u65af\u5766", "BD=\u5b5f\u52a0\u62c9", "TM=\u571f\u5e93\u66fc\u65af\u5766", "TJ=\u5854\u5409\u514b\u65af\u5766", "LK=\u65af\u91cc\u5170\u5361", "BT=\u4e0d\u4e39", "IN=\u5370\u5ea6", "MV=\u9a6c\u5c14\u4ee3\u592b", "IO=\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730", "NP=\u5c3c\u6cca\u5c14", "MM=\u7f05\u7538", "UZ=\u4e4c\u5179\u522b\u514b\u65af\u5766", "KZ=\u54c8\u8428\u514b\u65af\u5766", "KG=\u5409\u5c14\u5409\u514b\u65af\u5766", "TF=\u6cd5\u5c5e\u5357\u90e8\u9886\u571f", "CC=\u79d1\u79d1\u65af\u7fa4\u5c9b", "PW=\u5e15\u52b3", "VN=\u8d8a\u5357", "TH=\u6cf0\u56fd", "ID=\u5370\u5ea6\u5c3c\u897f\u4e9a", "LA=\u8001\u631d\u4eba\u6c11\u6c11\u4e3b\u5171\u548c\u56fd", "TW=\u53f0\u6e7e", "PH=\u83f2\u5f8b\u5bbe", "MY=\u9a6c\u6765\u897f\u4e9a", "CN=\u4e2d\u56fd", "HK=\u9999\u6e2f", "BN=\u6587\u83b1", "MO=\u6fb3\u95e8", "KH=\u67ec\u57d4\u5be8", "KR=\u97e9\u56fd", "JP=\u65e5\u672c", "KP=\u671d\u9c9c\u6c11\u4e3b\u5171\u548c\u56fd", "SG=\u65b0\u52a0\u5761", "CK=\u5e93\u514b\u7fa4\u5c9b", "TL=\u4e1c\u5e1d\u6c76", "RU=\u4fc4\u7f57\u65af", "MN=\u8499\u53e4", "AU=\u6fb3\u5927\u5229\u4e9a", "CX=\u5723\u8bde\u5c9b", "MH=\u9a6c\u7ecd\u5c14\u7fa4\u5c9b", "FM=\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a", "PG=\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a", "SB=\u6240\u7f57\u95e8\u7fa4\u5c9b", "TV=\u56fe\u74e6\u5362", "NR=\u7459\u9c81", "VU=\u74e6\u52aa\u963f\u56fe", "NC=\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a", "NF=\u8bfa\u798f\u514b\u5c9b", "NZ=\u65b0\u897f\u5170", "FJ=\u6590\u6d4e", "LY=\u963f\u62c9\u4f2f\u5229\u6bd4\u4e9a\u6c11\u4f17\u56fd", "CM=\u5580\u9ea6\u9686", "SN=\u585e\u5185\u52a0\u5c14", "CG=\u521a\u679c", "PT=\u8461\u8404\u7259", "LR=\u5229\u6bd4\u91cc\u4e9a", "CI=\u8c61\u7259\u6d77\u5cb8", "GH=\u52a0\u7eb3", "GQ=\u8d64\u9053\u51e0\u5185\u4e9a", "NG=\u5c3c\u65e5\u5229\u4e9a", "BF=\u5e03\u57fa\u7eb3\u6cd5\u7d22", "TG=\u591a\u54e5", "GW=\u51e0\u5185\u4e9a\u6bd4\u7ecd", "MR=\u6bdb\u91cc\u5854\u5c3c\u4e9a", "BJ=\u8d1d\u5b81", "GA=\u52a0\u84ec", "SL=\u585e\u62c9\u5229\u6602", "ST=\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4", "GI=\u76f4\u5e03\u7f57\u9640", "GM=\u5188\u6bd4\u4e9a", "GN=\u51e0\u5185\u4e9a", "TD=\u4e4d\u5f97", "NE=\u5c3c\u65e5\u5c14", "ML=\u9a6c\u91cc", "TN=\u7a81\u5c3c\u65af", "ES=\u897f\u73ed\u7259", "MA=\u6469\u6d1b\u54e5", "MT=\u9a6c\u8033\u4ed6", "DZ=\u963f\u5c14\u53ca\u5229\u4e9a", "FO=\u6cd5\u7f57\u7fa4\u5c9b", "DK=\u4e39\u9ea6", "IS=\u51b0\u5c9b", "GB=\u82f1\u56fd", "CH=\u745e\u58eb", "SE=\u745e\u5178", "NL=\u8377\u5170", "AT=\u5965\u5730\u5229", "BE=\u6bd4\u5229\u65f6", "DE=\u5fb7\u56fd", "LU=\u5362\u68ee\u5821", "IE=\u7231\u5c14\u5170", "MC=\u6469\u7eb3\u54e5", "FR=\u6cd5\u56fd", "AD=\u5b89\u9053\u5c14", "LI=\u5217\u652f\u6566\u58eb\u767b", "JE=\u6cfd\u897f\u5c9b", "IM=\u66fc\u5c9b", "GG=\u683c\u6069\u897f\u5c9b", "SK=\u65af\u6d1b\u4f10\u514b\u5171\u548c\u56fd", "CZ=\u6377\u514b\u5171\u548c\u56fd", "NO=\u632a\u5a01", "VA=\u5723\u5ea7\uff08\u68b5\u8482\u5188\uff09", "SM=\u5723\u9a6c\u529b\u8bfa", "IT=\u610f\u5927\u5229", "SI=\u65af\u6d1b\u6587\u5c3c\u4e9a", "ME=\u9ed1\u5c71\u5171\u548c\u56fd", "HR=\u514b\u7f57\u5730\u4e9a", "BA=\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u5c71\u5171\u548c\u56fd", "AO=\u5b89\u54e5\u62c9", "NA=\u7eb3\u7c73\u6bd4\u4e9a", "SH=\u5723\u8d6b\u52d2\u62ff", "BB=\u5df4\u5df4\u591a\u65af", "CV=\u4f5b\u5f97\u89d2", "GY=\u572d\u4e9a\u90a3", "GF=\u6cd5\u5c5e\u572d\u4e9a\u90a3", "SR=\u82cf\u91cc\u5357", "PM=\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686", "GL=\u683c\u9675\u5170", "PY=\u5df4\u62c9\u572d", "UY=\u4e4c\u62c9\u572d", "BR=\u5df4\u897f", "FK=\u798f\u514b\u5170\u7fa4\u5c9b", "GS=\u5357\u4e54\u6cbb\u4e9a\u5c9b\u548c\u5357\u6851\u5a01\u9f50\u7fa4\u5c9b", "JM=\u7259\u4e70\u52a0", "DO=\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd", "CU=\u53e4\u5df4", "MQ=\u9a6c\u63d0\u5c3c\u514b\u7fa4\u5c9b", "BS=\u5df4\u54c8\u9a6c", "BM=\u767e\u6155\u5927", "AI=\u5b89\u572d\u62c9", "TT=\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5", "KN=\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af", "DM=\u591a\u7c73\u5c3c\u52a0", "AG=\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe", "LC=\u5723\u5362\u897f\u4e9a", "TC=\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b", "AW=\u963f\u9c81\u5df4", "VG=\u82f1\u5c5e\u7ef4\u4eac\u7fa4\u5c9b", "VC=\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af", "MS=\u8499\u585e\u62c9\u7279\u7fa4\u5c9b", "MF=\u5723\u9a6c\u4e01", "BL=\u5723\u5df4\u6cf0\u52d2\u7c73", "GP=\u74dc\u5fb7\u7f57\u666e\u5c9b", "GD=\u683c\u6797\u7eb3\u8fbe", "KY=\u5f00\u66fc\u7fa4\u5c9b", "BZ=\u4f2f\u5229\u5179", "SV=\u8428\u5c14\u74e6\u591a", "GT=\u5371\u5730\u9a6c\u62c9", "HN=\u6d2a\u90fd\u62c9\u65af", "NI=\u5c3c\u52a0\u62c9\u74dc", "CR=\u54e5\u65af\u8fbe\u9ece\u52a0", "VE=\u59d4\u5185\u745e\u62c9", "EC=\u5384\u74dc\u591a\u5c14", "CO=\u54e5\u4f26\u6bd4\u4e9a", "PA=\u5df4\u62ff\u9a6c", "HT=\u6d77\u5730", "AR=\u963f\u6839\u5ef7", "CL=\u667a\u5229", "BO=\u73bb\u5229\u7ef4\u4e9a", "PE=\u79d8\u9c81", "MX=\u58a8\u897f\u54e5", "PF=\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a", "PN=\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b", "KI=\u57fa\u91cc\u5df4\u65af", "TK=\u6258\u514b\u52b3", "TO=\u6c64\u52a0", "WF=\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3", "WS=\u8428\u6469\u4e9a", "NU=\u7ebd\u57c3", "MP=\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b", "GU=\u5173\u5c9b", "PR=\u6ce2\u591a\u9ece\u5404", "VI=\u7f8e\u5c5e\u7ef4\u4eac\u7fa4\u5c9b", "UM=\u7f8e\u56fd\u8fb9\u8fdc\u5c0f\u5c9b", "AS=\u7f8e\u5c5e\u8428\u6469\u4e9a", "CA=\u52a0\u62ff\u5927", "US=\u7f8e\u56fd", "PS=\u5df4\u52d2\u65af\u5766\u9886\u571f", "RS=\u585e\u5c14\u7ef4\u4e9a", "AQ=\u5357\u6781\u6d32", "SX=\u5723\u9a6c\u4e01\u5c9b", "CW=\u5e93\u62c9\u7d22", "BQ=\u535a\u5948\u5c14\u5c9b\u3001\u5723\u5c24\u65af\u8fbe\u8482\u65af\u548c\u8428\u5df4", "SS=\u5357\u82cf\u4e39"};
    public static boolean enableFileWatch = false;
    private static int offset;
    private static int[] index;
    private static ByteBuffer dataBuffer;
    private static ByteBuffer indexBuffer;
    private static Long lastModifyTime;
    private static String ipFileName;
    private static File ipFile;
    private static ReentrantLock lock;

    public static void load(String filePath) {
        ipFile = new File(filePath);
        IPToLocationUtils.load();
        if (enableFileWatch) {
            IPToLocationUtils.watch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] find(String ip) {
        byte[] areaBytes;
        int ip_prefix_value = new Integer(ip.substring(0, ip.indexOf(".")));
        long ip2long_value = IPToLocationUtils.ip2long(ip);
        int start = index[ip_prefix_value];
        int max_comp_len = offset - 1028;
        long index_offset = -1L;
        int index_length = -1;
        byte b = 0;
        for (start = start * 8 + 1024; start < max_comp_len; start += 8) {
            if (IPToLocationUtils.int2long(indexBuffer.getInt(start)) < ip2long_value) continue;
            index_offset = IPToLocationUtils.bytesToLong(b, indexBuffer.get(start + 6), indexBuffer.get(start + 5), indexBuffer.get(start + 4));
            index_length = 0xFF & indexBuffer.get(start + 7);
            break;
        }
        lock.lock();
        try {
            dataBuffer.position(offset + (int)index_offset - 1024);
            areaBytes = new byte[index_length];
            dataBuffer.get(areaBytes, 0, index_length);
        }
        finally {
            lock.unlock();
        }
        return new String(areaBytes, Charset.forName("UTF-8")).split("\t", -1);
    }

    private static void watch() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long time = ipFile.lastModified();
                if (time > lastModifyTime) {
                    lastModifyTime = time;
                    IPToLocationUtils.load();
                }
            }
        }, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        lastModifyTime = ipFile.lastModified();
        FileInputStream fin = null;
        lock.lock();
        try {
            dataBuffer = ByteBuffer.allocate(Long.valueOf(ipFile.length()).intValue());
            fin = new FileInputStream(ipFile);
            byte[] chunk = new byte[4096];
            while (fin.available() > 0) {
                int readBytesLength = fin.read(chunk);
                dataBuffer.put(chunk, 0, readBytesLength);
            }
            dataBuffer.position(0);
            int indexLength = dataBuffer.getInt();
            byte[] indexBytes = new byte[indexLength];
            dataBuffer.get(indexBytes, 0, indexLength - 4);
            indexBuffer = ByteBuffer.wrap(indexBytes);
            indexBuffer.order(ByteOrder.LITTLE_ENDIAN);
            offset = indexLength;
            int loop = 0;
            while (loop++ < 256) {
                IPToLocationUtils.index[loop - 1] = indexBuffer.getInt();
            }
            indexBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            lock.unlock();
        }
    }

    private static long bytesToLong(byte a, byte b, byte c, byte d) {
        return IPToLocationUtils.int2long((a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF);
    }

    private static int str2Ip(String ip) {
        String[] ss = ip.split("\\.");
        int a = Integer.parseInt(ss[0]);
        int b = Integer.parseInt(ss[1]);
        int c = Integer.parseInt(ss[2]);
        int d = Integer.parseInt(ss[3]);
        return a << 24 | b << 16 | c << 8 | d;
    }

    private static long ip2long(String ip) {
        return IPToLocationUtils.int2long(IPToLocationUtils.str2Ip(ip));
    }

    private static long int2long(int i) {
        long l = (long)i & Integer.MAX_VALUE;
        if (i < 0) {
            l |= 0x80000000L;
        }
        return l;
    }

    public static void main(String[] args) {
        Long st = System.nanoTime();
        Object[] strs = IPToLocationUtils.find("114.253.34.147");
        System.out.println(Arrays.toString(strs));
        System.out.println(COUNTRY_CODE_MAP.get(strs[0]));
        Long et = System.nanoTime();
        System.out.println((et - st) / 1000L / 1000L);
    }

    static {
        index = new int[256];
        lastModifyTime = 0L;
        ipFileName = "17monipdb.dat";
        ipFile = new File(FileUtils.getCurrentDirectory(), ipFileName);
        lock = new ReentrantLock();
        for (String country : countries) {
            String[] array = country.split("=");
            COUNTRY_CODE_MAP.put(array[1], array[0]);
        }
        IPToLocationUtils.load();
    }
}

