/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.javaweb.core.utils.StringUtils;

public class IPV4Utils {
    public static final String PATTERN_255 = "(?:25[0-5]|2[0-4][0-9]|[1]?[0-9][0-9]?)";
    public static final Pattern PATTERN_IPV4 = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[1]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[1]?[0-9][0-9]?)$");
    private static final Logger LOG = Logger.getLogger("info");

    public static boolean isLanIp(String ip) {
        try {
            return InetAddress.getByName(ip).isSiteLocalAddress();
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    public static long ipToLong(String ip) {
        String[] strs = ip.split("\\.");
        return (Long.parseLong(strs[0]) << 24) + (long)(Integer.parseInt(strs[1]) << 16) + (long)(Integer.parseInt(strs[2]) << 8) + (long)Integer.parseInt(strs[3]);
    }

    public static String longToIP(long longIp) {
        StringBuilder sb = new StringBuilder("");
        sb.append(String.valueOf(longIp >>> 24)).append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16)).append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8)).append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }

    public static boolean isValid(String ip) {
        if (StringUtils.isNotEmpty((String)ip)) {
            return PATTERN_IPV4.matcher(ip).matches();
        }
        return false;
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static String getLocalMacAddress() {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] mac = NetworkInterface.getByInetAddress(IPV4Utils.getLocalHostLANAddress()).getHardwareAddress();
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i > 0) {
                    sb.append("-");
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append("0").append(str);
                    continue;
                }
                sb.append(str);
            }
        }
        catch (Exception e) {
            LOG.info("\u65e0\u6cd5\u83b7\u53d6\u672c\u673aMAC\u5730\u5740,MAC\u5730\u5740\u4e3a\u7a7a.");
        }
        return sb.toString();
    }
}

