/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import com.sun.rowset.CachedRowSetImpl;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.javaweb.core.utils.FileUtils;
import org.javaweb.core.utils.MobileLocation;

public class MobileLocationUtils {
    private static final String GET_ALL_MOBILE_LOCATION = "select * from mobile_location where 1 = 1 ";
    private static String mobileFileName = "mobile_location.db";
    private static File mobileLocationFile = new File(FileUtils.getCurrentDirectory(), mobileFileName);
    private static Connection connection = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getConnection() {
        if (connection != null) return connection;
        Class<MobileLocationUtils> clazz = MobileLocationUtils.class;
        synchronized (MobileLocationUtils.class) {
            try {
                Class.forName("org.sqlite.JDBC");
                connection = DriverManager.getConnection("jdbc:sqlite:" + mobileLocationFile.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return connection;
        }
    }

    public static ResultSet executeQuery(String sql, Object ... prr) throws SQLException {
        PreparedStatement pstt = null;
        ResultSet rs = null;
        try {
            pstt = MobileLocationUtils.getConnection().prepareStatement(sql);
            CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
            for (int i = 0; i < prr.length; ++i) {
                pstt.setObject(i + 1, prr[i]);
            }
            rs = pstt.executeQuery();
            cachedRowSetImpl.populate(rs);
            CachedRowSetImpl cachedRowSetImpl2 = cachedRowSetImpl;
            return cachedRowSetImpl2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (pstt != null) {
                pstt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobileLocation getMobileLocation(String mobile) {
        MobileLocation location = new MobileLocation();
        String mobilePrefix = mobile.substring(0, 7);
        ResultSet rs = null;
        try {
            rs = MobileLocationUtils.executeQuery("select * from mobile_location where 1 = 1  and mobile_prefix = ? ", mobilePrefix);
            while (rs.next()) {
                location.setPrefix(rs.getInt("prefix"));
                location.setMobilePrefix(rs.getInt("mobile_prefix"));
                location.setProvince(rs.getString("province"));
                location.setCity(rs.getString("city"));
                location.setIsp(rs.getString("isp"));
                location.setPostCode(rs.getInt("post_code"));
                location.setCityCode(rs.getInt("city_code"));
                location.setAreaCode(rs.getInt("area_code"));
                location.setTypes(rs.getString("types"));
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return location;
    }
}

