/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    public static byte[] encrypt(Key key, byte[] encrypted) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, key);
        return cipher.doFinal(encrypted);
    }

    public static byte[] decrypt(Key key, byte[] encrypted) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, key);
        return cipher.doFinal(encrypted);
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(spec);
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(spec);
    }

    public static Map<String, RSAKey> generateKey(int keySize) throws NoSuchAlgorithmException {
        HashMap<String, RSAKey> keyMap = new HashMap<String, RSAKey>();
        KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = new SecureRandom();
        keygen.initialize(keySize, random);
        KeyPair kp = keygen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)kp.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
        keyMap.put("PRIVATE_KEY", privateKey);
        keyMap.put("PUBLIC_KEY", publicKey);
        return keyMap;
    }

    public static void main(String[] args) throws Exception {
        String str = "RSA\u52a0\u5bc6\u6d4b\u8bd5...";
        Map<String, RSAKey> map = RSAUtils.generateKey(2048);
        PrivateKey privateKey = (PrivateKey)((Object)map.get("PRIVATE_KEY"));
        PublicKey publicKey = (PublicKey)((Object)map.get("PUBLIC_KEY"));
        String privateKeyString = Base64.encodeBase64String((byte[])privateKey.getEncoded());
        String publicKeyString = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        System.out.println("privateKeyString:" + privateKeyString);
        System.out.println("-------------------------------------------");
        System.out.println("publicKeyString:" + publicKeyString);
        System.out.println("-------------------------------------------");
        System.out.println(RSAUtils.getPrivateKey(privateKeyString));
        System.out.println(RSAUtils.getPublicKey(publicKeyString));
        byte[] encrypted = RSAUtils.encrypt(RSAUtils.getPublicKey(publicKeyString), str.getBytes());
        System.out.println("-------------------------------------------");
        System.out.println(new String(Base64.encodeBase64((byte[])encrypted)));
        System.out.println("-------------------------------------------");
        System.out.println(new String(RSAUtils.decrypt(RSAUtils.getPrivateKey(privateKeyString), encrypted)));
    }
}

