/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionUtils {
    public static <T> Map<String, Field> getFieldsMap(Class<T> entityClass) {
        Field[] fields;
        ConcurrentHashMap<String, Field> fieldMap = new ConcurrentHashMap<String, Field>();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            fieldMap.put(field.getName().toLowerCase(), field);
        }
        return fieldMap;
    }

    public static <T> Map<String, Field> getAllFieldsMap(Class<T> entityClass) {
        ConcurrentHashMap<String, Field> map = new ConcurrentHashMap<String, Field>();
        Class<T> c = entityClass;
        map.putAll(ReflectionUtils.getFieldsMap(entityClass));
        while (c.getSuperclass() != null) {
            c = c.getSuperclass();
            map.putAll(ReflectionUtils.getFieldsMap(c));
        }
        return map;
    }

    public static <T> Map<String, Method> getMethodsMap(Class<T> entityClass) {
        Method[] methods = entityClass.getMethods();
        ConcurrentHashMap<String, Method> map = new ConcurrentHashMap<String, Method>();
        for (Method method : methods) {
            map.put(method.getName().toLowerCase(), method);
        }
        return map;
    }

    public static <T> Map<String, Method> getAllMethodsMap(Class<T> entityClass) {
        Method[] methods = entityClass.getDeclaredMethods();
        ConcurrentHashMap<String, Method> map = new ConcurrentHashMap<String, Method>();
        for (Method method : methods) {
            map.put(method.getName().toLowerCase(), method);
        }
        return map;
    }
}

