/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    public static boolean isNotEmpty(Object obj) {
        if (obj == null) {
            return false;
        }
        return !"".equals(String.valueOf(obj).trim());
    }

    public static boolean isNum(String str) {
        return StringUtils.isNotEmpty((String)str) ? str.trim().replaceAll("[0-9]+", "").length() == 0 : false;
    }

    public static String join(Object[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            if (array[i] == null) continue;
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String join(List<?> ls, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ls.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            if (ls.get(i) == null) continue;
            sb.append(ls.get(i));
        }
        return sb.toString();
    }

    public static boolean arrayContains(Object[] array, Object objectToFind) {
        for (Object array1 : array) {
            if (array1 == null || !("" + array1).contains("" + objectToFind)) continue;
            return true;
        }
        return false;
    }

    public static String getSeparator() {
        if ("\r".equals(System.getProperty("line.separator"))) {
            return "\\r";
        }
        if ("\r\n".equals(System.getProperty("line.separator"))) {
            return "\\r\\n";
        }
        return "\\n";
    }

    public static synchronized String getUUID() {
        return UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    }

    public static String unicodeToUtf8(String str) {
        if (str == null || str.length() < 1 || !Pattern.compile("\\\\u").matcher(str).find()) {
            return str;
        }
        int len = str.length();
        StringBuilder outBuffer = new StringBuilder(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = str.charAt(x++)) == '\\') {
                if ((aChar = str.charAt(x++)) == 'u') {
                    int value = 0;
                    block12: for (int i = 0; i < 4; ++i) {
                        aChar = str.charAt(x++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                switch (aChar) {
                    case 't': {
                        aChar = '\t';
                        break;
                    }
                    case 'r': {
                        aChar = '\r';
                        break;
                    }
                    case 'n': {
                        aChar = '\n';
                        break;
                    }
                    case 'f': {
                        aChar = '\f';
                        break;
                    }
                }
                outBuffer.append(aChar);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static boolean accountValidate(String account) {
        return Pattern.compile("^[a-zA-Z0-9|-|_]{2,20}$").matcher(account).find();
    }

    public static boolean mailValidate(String mail) {
        return Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$").matcher(mail).find();
    }

    public static boolean cellPhoneValidate(String cellPhone) {
        return Pattern.compile("^1[3|4|5|7|8][0-9]\\d{8}$").matcher(cellPhone).find();
    }

    public static String toUpperCaseFirstOne(String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            char f = str.charAt(0);
            if (Character.isUpperCase(f)) {
                return str;
            }
            return str.replaceFirst(String.valueOf(f), String.valueOf(f).toUpperCase());
        }
        return str;
    }

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static String getSpecialRandomString(int length) {
        String[] words = new String[]{"1", "I", "i", "l", "L", "0", "O", "o"};
        return StringUtils.randomString(length, words);
    }

    public static String getRandomString(int length) {
        return StringUtils.randomString(length, new String[0]);
    }

    public static String randomString(int length, String ... words) {
        if (length < 1) {
            return null;
        }
        String str = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        if (words.length > 0) {
            for (String word : words) {
                str = str.replace(word, "");
            }
        }
        Random random = new Random();
        char[] strs = str.toCharArray();
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = strs[random.nextInt(strs.length)];
        }
        return new String(chars);
    }

    public static int textIndexOfCount(String content, String sub, boolean regex) {
        Matcher matcher = Pattern.compile(regex ? sub : Pattern.quote(sub)).matcher(content);
        int i = 0;
        while (matcher.find()) {
            ++i;
        }
        return i;
    }
}

