/*
 * Decompiled with CFR 0.152.
 */
package org.javaweb.core.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class URLCanonicalizerUtils {
    public static String getCanonicalURL(String url) {
        URL canonicalURL = URLCanonicalizerUtils.getCanonicalURL(url, null);
        if (canonicalURL != null) {
            return canonicalURL.toExternalForm();
        }
        return null;
    }

    public static URL getCanonicalURL(String href, String context) {
        try {
            int port;
            String canonicalParams;
            if (!Pattern.compile("^https?", 2).matcher(href).find()) {
                href = "http://" + href;
            }
            URL canonicalURL = context == null ? new URL(href) : new URL(new URL(context), href);
            String path = canonicalURL.getPath();
            path = path.replaceAll("\r", "").replaceAll("\n", "");
            path = path.replaceAll("\\\\", "/");
            try {
                path = new URI(path).normalize().toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            path = path.replaceAll("/+", "/");
            while (path.startsWith("/../")) {
                path = path.substring(3);
            }
            path = path.trim();
            SortedMap<String, String> params = URLCanonicalizerUtils.createParameterMap(canonicalURL.getQuery());
            String queryString = params != null && params.size() > 0 ? ((canonicalParams = URLCanonicalizerUtils.canonicalize(params)).isEmpty() ? "" : "?" + canonicalParams) : "";
            if (path.length() == 0) {
                path = "/" + path;
            }
            if ((port = canonicalURL.getPort()) == canonicalURL.getDefaultPort()) {
                port = -1;
            }
            String protocol = canonicalURL.getProtocol().toLowerCase();
            String host = canonicalURL.getHost().toLowerCase();
            String pathAndQueryString = URLCanonicalizerUtils.normalizePath(path) + queryString;
            return new URL(protocol, host, port, pathAndQueryString);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private static SortedMap<String, String> createParameterMap(String queryString) {
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        String[] pairs = queryString.split("&");
        HashMap<String, String> params = new HashMap<String, String>(pairs.length);
        block4: for (String pair : pairs) {
            if (pair.length() == 0) continue;
            String[] tokens = pair.split("=", 2);
            switch (tokens.length) {
                case 1: {
                    if (pair.charAt(0) == '=') {
                        params.put("", tokens[0]);
                        continue block4;
                    }
                    params.put(tokens[0], "");
                    continue block4;
                }
                case 2: {
                    params.put(tokens[0], tokens[1]);
                }
            }
        }
        return new TreeMap<String, String>(params);
    }

    private static String canonicalize(SortedMap<String, String> sortedParamMap) {
        if (sortedParamMap == null || sortedParamMap.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(100);
        for (Map.Entry<String, String> pair : sortedParamMap.entrySet()) {
            String key = pair.getKey().toLowerCase();
            if (key.equals("jsessionid") || key.equals("phpsessid") || key.equals("aspsessionid")) continue;
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLCanonicalizerUtils.percentEncodeRfc3986(pair.getKey()));
            if (pair.getValue().isEmpty()) continue;
            sb.append('=');
            sb.append(URLCanonicalizerUtils.percentEncodeRfc3986(pair.getValue()));
        }
        return sb.toString();
    }

    private static String percentEncodeRfc3986(String string) {
        try {
            string = string.replace("+", "%2B");
            string = URLDecoder.decode(string, "UTF-8");
            string = URLEncoder.encode(string, "UTF-8");
            return string.replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (Exception e) {
            return string;
        }
    }

    private static String normalizePath(String path) {
        return path.replace("%7E", "~").replace(" ", "%20");
    }
}

