/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.nutz.aop.AbstractClassAgent;
import org.nutz.aop.ClassDefiner;
import org.nutz.aop.asm.ClassY;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.log.Logs;

public class AsmClassAgent
extends AbstractClassAgent {
    static int CLASS_LEVEL = 49;
    static final String MethodArray_FieldName = "_$$Nut_methodArray";
    static final String MethodInterceptorList_FieldName = "_$$Nut_methodInterceptorList";

    @Override
    protected <T> Class<T> generate(ClassDefiner cd, AbstractClassAgent.Pair2[] pair2s, String newName, Class<T> klass, Constructor<T>[] constructors) {
        try {
            return cd.load(newName);
        }
        catch (ClassNotFoundException e) {
            Method[] methodArray = new Method[pair2s.length];
            List[] methodInterceptorList = new List[pair2s.length];
            for (int i = 0; i < pair2s.length; ++i) {
                AbstractClassAgent.Pair2 pair2 = pair2s[i];
                methodArray[i] = pair2.method;
                methodInterceptorList[i] = pair2.listeners;
            }
            byte[] bytes = ClassY.enhandClass(klass, newName, methodArray, constructors);
            Class<?> newClass = cd.define(newName, bytes);
            try {
                Mirror<Class<?>> mirror = Mirror.me(newClass);
                mirror.setValue(null, MethodArray_FieldName, (Object)methodArray);
                mirror.setValue(null, MethodInterceptorList_FieldName, (Object)methodInterceptorList);
            }
            catch (Throwable e2) {
                // empty catch block
            }
            return newClass;
        }
    }

    static {
        if (Lang.isJDK6()) {
            CLASS_LEVEL = 50;
        }
        Logs.get().debugf("AsmClassAgent will define class in Version %s", CLASS_LEVEL);
    }
}

