/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.nutz.dao.DB;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.EL;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Index;
import org.nutz.dao.entity.annotation.Many;
import org.nutz.dao.entity.annotation.ManyMany;
import org.nutz.dao.entity.annotation.Name;
import org.nutz.dao.entity.annotation.One;
import org.nutz.dao.entity.annotation.PK;
import org.nutz.dao.entity.annotation.SQL;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.dao.entity.annotation.TableIndexes;
import org.nutz.dao.entity.annotation.TableMeta;
import org.nutz.dao.entity.annotation.View;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.FieldMacroInfo;
import org.nutz.dao.impl.entity.NutEntity;
import org.nutz.dao.impl.entity.NutEntityIndex;
import org.nutz.dao.impl.entity.field.ManyLinkField;
import org.nutz.dao.impl.entity.field.ManyManyLinkField;
import org.nutz.dao.impl.entity.field.NutMappingField;
import org.nutz.dao.impl.entity.field.OneLinkField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.dao.impl.entity.info.MappingInfo;
import org.nutz.dao.impl.entity.info.TableInfo;
import org.nutz.dao.impl.entity.info._Infos;
import org.nutz.dao.impl.entity.macro.ElFieldMacro;
import org.nutz.dao.impl.entity.macro.SqlFieldMacro;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.sql.Pojo;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.CharSegment;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Trans;

public class AnnotationEntityMaker
implements EntityMaker {
    private static final Log log = Logs.get();
    private DataSource datasource;
    private JdbcExpert expert;
    private EntityHolder holder;

    protected AnnotationEntityMaker() {
    }

    @Override
    public void init(DataSource datasource, JdbcExpert expert, EntityHolder holder) {
        this.datasource = datasource;
        this.expert = expert;
        this.holder = holder;
    }

    public AnnotationEntityMaker(DataSource datasource, JdbcExpert expert, EntityHolder holder) {
        this.init(datasource, expert, holder);
    }

    @Override
    public <T> Entity<T> make(Class<T> type) {
        boolean bl;
        NutEntity<T> en = this._createNutEntity(type);
        TableInfo ti = this._createTableInfo(type);
        if (null != this.expert.getConf()) {
            for (String string : this.expert.getConf().keySet()) {
                en.getMetas().put(string, this.expert.getConf().get(string));
            }
        }
        if (null != ti.annMeta) {
            NutMap map = Lang.map(ti.annMeta.value());
            for (Map.Entry entry : map.entrySet()) {
                en.getMetas().put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        String tableName = null;
        if (null == ti.annTable) {
            tableName = Strings.lowerWord(type.getSimpleName(), '_');
            log.warnf("No @Table found, fallback to use table name='%s' for type '%s'", tableName, type.getName());
        } else {
            tableName = ti.annTable.value();
        }
        String string = null == ti.annView ? tableName : ti.annView.value();
        en.setTableName(tableName);
        en.setViewName(string);
        boolean bl2 = bl = null != ti.tableComment;
        String tableComment = bl ? (Strings.isBlank(ti.tableComment.value()) ? type.getName() : ti.tableComment.value()) : null;
        en.setHasTableComment(bl);
        en.setTableComment(tableComment);
        boolean shouldUseColumn = false;
        boolean hasColumnComment = false;
        for (Field field : en.getMirror().getFields()) {
            if (shouldUseColumn && hasColumnComment) break;
            if (!shouldUseColumn && null != field.getAnnotation(Column.class)) {
                shouldUseColumn = true;
            }
            if (hasColumnComment || null == field.getAnnotation(Comment.class)) continue;
            hasColumnComment = true;
        }
        en.setHasColumnComment(hasColumnComment);
        ArrayList<MappingInfo> infos = new ArrayList<MappingInfo>();
        ArrayList<LinkInfo> ones = new ArrayList<LinkInfo>();
        ArrayList<LinkInfo> manys = new ArrayList<LinkInfo>();
        ArrayList<LinkInfo> manymanys = new ArrayList<LinkInfo>();
        String[] _tmp = ti.annPK == null ? null : ti.annPK.value();
        List<Object> pks = _tmp == null ? new ArrayList() : Arrays.asList(_tmp);
        for (Field field : en.getMirror().getFields()) {
            if (null != field.getAnnotation(One.class)) {
                ones.add(_Infos.createLinkInfo(field));
                continue;
            }
            if (null != field.getAnnotation(Many.class)) {
                manys.add(_Infos.createLinkInfo(field));
                continue;
            }
            if (null != field.getAnnotation(ManyMany.class)) {
                manymanys.add(_Infos.createLinkInfo(field));
                continue;
            }
            if (Modifier.isTransient(field.getModifiers()) && null == field.getAnnotation(Column.class) || shouldUseColumn && null == field.getAnnotation(Column.class) && null == field.getAnnotation(Id.class) && null == field.getAnnotation(Name.class) && !pks.contains(field.getName())) continue;
            infos.add(_Infos.createMappingInfo(ti.annPK, field));
        }
        for (Method method : en.getType().getMethods()) {
            if (null != method.getAnnotation(One.class)) {
                ones.add(_Infos.createLinkInfo(method));
                continue;
            }
            if (null != method.getAnnotation(Many.class)) {
                manys.add(_Infos.createLinkInfo(method));
                continue;
            }
            if (null != method.getAnnotation(ManyMany.class)) {
                manymanys.add(_Infos.createLinkInfo(method));
                continue;
            }
            if (null == method.getAnnotation(Column.class) && null == method.getAnnotation(Id.class) && null == method.getAnnotation(Name.class)) continue;
            infos.add(_Infos.createMapingInfo(ti.annPK, method));
        }
        ArrayList<MappingInfo> tmp = new ArrayList<MappingInfo>(infos.size());
        MappingInfo miId = null;
        MappingInfo miName = null;
        for (MappingInfo mi : infos) {
            if (mi.annId != null) {
                if (miId != null) {
                    throw new DaoException("Allows only a single @Id ! " + type);
                }
                miId = mi;
                continue;
            }
            if (mi.annName != null) {
                if (miName != null) {
                    throw new DaoException("Allows only a single @Name ! " + type);
                }
                miName = mi;
                continue;
            }
            tmp.add(mi);
        }
        if (miName != null) {
            tmp.add(0, miName);
        }
        if (miId != null) {
            tmp.add(0, miId);
        }
        if ((infos = tmp).isEmpty()) {
            throw Lang.makeThrow(IllegalArgumentException.class, "Pojo(%s) without any Mapping Field!!", type);
        }
        for (MappingInfo info : infos) {
            NutMappingField ef = new NutMappingField(en);
            this._evalMappingField(ef, info);
            en.addMappingField(ef);
        }
        this.holder.set(en);
        try {
            for (LinkInfo li : ones) {
                en.addLinkField(new OneLinkField(en, this.holder, li));
            }
            for (LinkInfo li : manys) {
                en.addLinkField(new ManyLinkField(en, this.holder, li));
            }
            for (LinkInfo li : manymanys) {
                en.addLinkField(new ManyManyLinkField(en, this.holder, li));
            }
            en.checkCompositeFields(null == ti.annPK ? null : ti.annPK.value());
            if (null != this.datasource && null != this.expert) {
                this._checkupEntityFieldsWithDatabase(en);
            }
            this._evalFieldMacro(en, infos);
            if (null != ti.annIndexes) {
                this._evalEntityIndexes(en, ti.annIndexes);
            }
        }
        catch (RuntimeException e) {
            this.holder.remove(en);
            throw e;
        }
        catch (Throwable e) {
            this.holder.remove(en);
            throw Lang.wrapThrow(e);
        }
        return en;
    }

    private TableInfo _createTableInfo(Class<?> type) {
        TableInfo info = new TableInfo();
        Mirror<Class<?>> mirror = Mirror.me(type);
        info.annTable = mirror.getAnnotation(Table.class);
        info.annView = mirror.getAnnotation(View.class);
        info.annMeta = mirror.getAnnotation(TableMeta.class);
        info.annPK = mirror.getAnnotation(PK.class);
        info.annIndexes = mirror.getAnnotation(TableIndexes.class);
        info.tableComment = mirror.getAnnotation(Comment.class);
        return info;
    }

    private List<FieldMacroInfo> _annToFieldMacroInfo(EL[] els, SQL[] sqls) {
        LinkedList<FieldMacroInfo> mis = new LinkedList<FieldMacroInfo>();
        if (els.length > 0) {
            for (Annotation annotation : els) {
                mis.add(new FieldMacroInfo((EL)annotation));
            }
        }
        if (sqls.length > 0) {
            for (Annotation annotation : sqls) {
                mis.add(new FieldMacroInfo((SQL)annotation));
            }
        }
        return mis;
    }

    private void _evalMappingField(NutMappingField ef, MappingInfo info) {
        ef.setName(info.name);
        ef.setType(info.fieldType);
        if (null == info.annColumn || Strings.isBlank(info.annColumn.value())) {
            ef.setColumnName(info.name);
        } else {
            ef.setColumnName(info.annColumn.value());
        }
        boolean hasColumnComment = null != info.columnComment;
        ef.setHasColumnComment(hasColumnComment);
        if (hasColumnComment) {
            String comment = info.columnComment.value();
            if (Strings.isBlank(comment)) {
                ef.setColumnComment(info.name);
            } else {
                ef.setColumnComment(comment);
            }
        }
        if (null != info.annId) {
            ef.setAsId();
            if (info.annId.auto()) {
                if (info.annPrev != null) {
                    log.infof("field %s mark as @Id(auto=true) and @Prev", info.name);
                }
                ef.setAsAutoIncreasement();
            }
        }
        if (null != info.annName) {
            ef.setAsName();
            ef.setCasesensitive(info.annName.casesensitive());
        }
        if (ef.isId() && ef.isName()) {
            throw Lang.makeThrow("Field '%s'(%s) can not be @Id and @Name at same time!", ef.getName(), ef.getEntity().getType().getName());
        }
        if (null != info.annPK) {
            if (info.annPK.value().length == 1) {
                if (Lang.contains(info.annPK.value(), info.name)) {
                    if (ef.getTypeMirror().isIntLike()) {
                        ef.setAsId();
                    } else {
                        ef.setAsName();
                    }
                }
            } else if (Lang.contains(info.annPK.value(), info.name)) {
                ef.setAsCompositePk();
            }
        }
        if (null != info.annDefault) {
            ef.setDefaultValue(new CharSegment(info.annDefault.value()));
        }
        if (null != info.annReadonly) {
            ef.setAsReadonly();
        }
        if (null != info.annDefine) {
            ef.setColumnType(info.annDefine.type());
            ef.setWidth(info.annDefine.width());
            if (ef.getWidth() == 0 && ef.getColumnType() == ColType.VARCHAR) {
                ef.setWidth(50);
            }
            ef.setPrecision(info.annDefine.precision());
            if (info.annDefine.unsigned()) {
                ef.setAsUnsigned();
            }
            if (info.annDefine.notNull()) {
                ef.setAsNotNull();
            }
            if (info.annDefine.auto() && !ef.isId()) {
                ef.setAsAutoIncreasement();
            }
            if (info.annDefine.customType().length() > 0) {
                ef.setCustomDbType(info.annDefine.customType());
            }
            ef.setInsert(info.annDefine.insert());
            ef.setUpdate(info.annDefine.update());
        } else {
            Jdbcs.guessEntityFieldColumnType(ef);
        }
        ef.setAdaptor(this.expert.getAdaptor(ef));
        ef.setInjecting(info.injecting);
        ef.setEjecting(info.ejecting);
    }

    private void _evalFieldMacro(Entity<?> en, List<MappingInfo> infos) {
        for (MappingInfo info : infos) {
            if (null != info.annPrev) {
                en.addBeforeInsertMacro(this.__macro(en.getField(info.name), this._annToFieldMacroInfo(info.annPrev.els(), info.annPrev.value())));
            }
            if (null != info.annNext && en.addAfterInsertMacro(this.__macro(en.getField(info.name), this._annToFieldMacroInfo(info.annNext.els(), info.annNext.value()))) || null == info.annId || !info.annId.auto()) continue;
            if (this.expert != null && !this.expert.isSupportAutoIncrement()) {
                log.debug("Database don't support auto-increment. If insert fail, pls add trigger in database or using @Prev in Pojo");
            }
            en.addAfterInsertMacro(this.expert.fetchPojoId(en, en.getField(info.name)));
        }
    }

    private Pojo __macro(MappingField ef, List<FieldMacroInfo> infoList) {
        FieldMacroInfo theInfo = null;
        for (FieldMacroInfo info : infoList) {
            if (DB.OTHER == info.getDb()) {
                theInfo = info;
                continue;
            }
            if (!info.getDb().name().equalsIgnoreCase(this.expert.getDatabaseType())) continue;
            theInfo = info;
            break;
        }
        if (null != theInfo) {
            if (theInfo.isEl()) {
                return new ElFieldMacro(ef, theInfo.getValue());
            }
            return new SqlFieldMacro(ef, theInfo.getValue());
        }
        return null;
    }

    private void _evalEntityIndexes(NutEntity<?> en, TableIndexes indexes) {
        for (Index idx : indexes.value()) {
            NutEntityIndex index = new NutEntityIndex();
            index.setUnique(idx.unique());
            index.setName(idx.name());
            for (String indexName : idx.fields()) {
                MappingField ef = en.getField(indexName);
                if (null == ef) {
                    throw Lang.makeThrow("Fail to find field '%s' in '%s' by @Index(%s:%s)", indexName, en.getType().getName(), index.getName(), Lang.concat(idx.fields()));
                }
                index.addField(ef);
            }
            en.addIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkupEntityFieldsWithDatabase(NutEntity<?> en) {
        Connection conn = null;
        try {
            conn = Trans.getConnectionAuto(this.datasource);
            this.expert.setupEntityField(conn, en);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debugf("Fail to setup '%s'(%s) by DB, because: (%s)'%s'", en.getType().getName(), en.getTableName(), e.getClass().getName(), e.getMessage());
            }
        }
        finally {
            Trans.closeConnectionAuto(conn);
        }
    }

    protected <T> NutEntity<T> _createNutEntity(Class<T> type) {
        return new NutEntity<T>(type);
    }
}

