/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import java.util.Collection;
import java.util.Map;
import org.nutz.castor.Castors;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.field.AbstractEntityField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.dao.impl.sql.pojo.PojoFetchEntityCallback;
import org.nutz.dao.impl.sql.pojo.PojoQueryEntityCallback;
import org.nutz.dao.sql.PojoCallback;
import org.nutz.lang.Mirror;

public abstract class AbstractLinkField
extends AbstractEntityField
implements LinkField {
    protected EntityHolder holder;
    protected Class<?> targetType;
    protected Entity<?> target;
    private PojoCallback callback;
    protected String mapKey;
    protected MappingField hostField;
    protected MappingField linkedField;
    private boolean[] lock = new boolean[0];

    public AbstractLinkField(Entity<?> entity, EntityHolder holder, LinkInfo info) {
        super(entity);
        this.holder = holder;
        this.setName(info.name);
        this.setInjecting(info.injecting);
        this.setEjecting(info.ejecting);
        this.setType(info.fieldType);
        this.callback = this.getTypeMirror().isOf(Collection.class) ? new PojoQueryEntityCallback() : (this.getTypeMirror().isOf(Map.class) ? new PojoQueryEntityCallback() : (this.getTypeClass().isArray() ? new PojoQueryEntityCallback() : new PojoFetchEntityCallback()));
    }

    @Override
    public void setValue(Object obj, Object value) {
        if (null != value && !Mirror.me(value).canCastToDirectly(this.getTypeClass())) {
            value = Castors.me().cast(value, value.getClass(), this.getTypeClass(), this.mapKey);
        }
        super.setValue(obj, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Entity<?> getLinkedEntity() {
        if (null != this.target) return this.target;
        boolean[] blArray = this.lock;
        synchronized (this.lock) {
            if (null != this.target) return this.target;
            this.target = this.targetType.equals(this.getEntity().getType()) ? this.getEntity() : this.holder.getEntity(this.targetType);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.target;
        }
    }

    @Override
    public PojoCallback getCallback() {
        return this.callback;
    }

    @Override
    public MappingField getHostField() {
        return this.hostField;
    }

    @Override
    public MappingField getLinkedField() {
        return this.linkedField;
    }
}

