/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc;

import java.io.File;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.nutz.dao.impl.jdbc.AbstractFileValueAdaptor;
import org.nutz.dao.util.blob.SimpleBlob;
import org.nutz.filepool.FilePool;
import org.nutz.lang.Files;

public class BlobValueAdaptor
extends AbstractFileValueAdaptor {
    public BlobValueAdaptor(FilePool pool) {
        super(pool);
        this.suffix = ".blob";
    }

    @Override
    public Object get(ResultSet rs, String colName) throws SQLException {
        File f = this.createTempFile();
        Blob blob = rs.getBlob(colName);
        if (blob == null) {
            return null;
        }
        Files.write(f, (Object)blob.getBinaryStream());
        return new SimpleBlob(f);
    }

    @Override
    public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
        if (null == obj) {
            stat.setNull(i, 2004);
        } else {
            Blob blob = (Blob)obj;
            stat.setBlob(i, blob);
        }
    }
}

