/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.hsqldb;

import java.util.List;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.impl.jdbc.AbstractJdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;

public class HsqldbJdbcExpert
extends AbstractJdbcExpert {
    public HsqldbJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.HSQL.name();
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            sb.append('\n').append(mf.getColumnName());
            sb.append(' ').append(this.evalFieldType(mf));
            if (mf.isName() && en.getPkType() != PkType.NAME) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (mf.isUnsigned()) {
                    sb.append(" UNSIGNED");
                }
                if (mf.isAutoIncreasement()) {
                    sb.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH 1)");
                } else if (mf.isNotNull()) {
                    sb.append(" NOT NULL");
                }
                if (mf.hasDefaultValue()) {
                    sb.append(" DEFAULT '").append(this.getDefaultValue(mf)).append('\'');
                }
            }
            sb.append(',');
        }
        List<MappingField> pks = en.getPks();
        if (!pks.isEmpty()) {
            sb.append('\n');
            sb.append("PRIMARY KEY (");
            for (MappingField pk : pks) {
                sb.append(pk.getColumnName()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n ");
        }
        sb.setCharAt(sb.length() - 1, ')');
        dao.execute(Sqls.create(sb.toString()));
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        this.createRelation(dao, en);
        this.addComment(dao, en);
        return true;
    }

    @Override
    protected String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        switch (mf.getColumnType()) {
            case INT: {
                if (mf.getWidth() > 0) {
                    return "NUMERIC(" + mf.getWidth() + ")";
                }
                return "INT";
            }
            case FLOAT: {
                if (mf.getWidth() > 0 && mf.getPrecision() > 0) {
                    return "NUMERIC(" + mf.getWidth() + "," + mf.getPrecision() + ")";
                }
                if (mf.getTypeMirror().isDouble()) {
                    return "NUMERIC(15,10)";
                }
                return "FLOAT";
            }
            case BINARY: {
                return "BLOB";
            }
            case TEXT: {
                return "CLOB";
            }
        }
        return super.evalFieldType(mf);
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            pojo.append(Pojos.Items.wrapf(" LIMIT %d offset %d", pager.getPageSize(), pager.getOffset()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            sql.setSourceSql(sql.getSourceSql() + String.format(" LIMIT %d offset %d", pager.getPageSize(), pager.getOffset()));
        }
    }

    @Override
    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT limit 1 1 * FROM " + en.getViewName();
    }
}

