/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.pojo;

import org.nutz.dao.Chain;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.lang.Lang;

public class InsertByChainPItem
extends AbstractPItem {
    private String[] names;
    private Object[] values;

    public InsertByChainPItem(Chain chain) {
        this.names = new String[chain.size()];
        this.values = new Object[chain.size()];
        int i = 0;
        for (Chain c = chain.head(); null != c; c = c.next()) {
            this.names[i] = c.name();
            this.values[i] = c.value();
            ++i;
        }
        if (i == 0) {
            throw Lang.makeThrow("Insert empty chain!", new Object[0]);
        }
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        int i;
        sb.append(" (").append(this._colname(en, 0));
        for (i = 1; i < this.names.length; ++i) {
            sb.append(',').append(this._colname(en, i));
        }
        sb.append(") VALUES(?");
        for (i = 1; i < this.names.length; ++i) {
            sb.append(",?");
        }
        sb.append(')');
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        for (int i = 0; i < this.names.length; ++i) {
            adaptors[off++] = en.getColumn(this._colname(en, i)).getAdaptor();
        }
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        for (int i = 0; i < this.values.length; ++i) {
            params[off++] = this.values[i];
        }
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        return this.values.length;
    }

    private String _colname(Entity<?> en, int index) {
        MappingField field = en.getField(this.names[index]);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Class %s didn't have field named (%s)", en.getType(), this.names[index]));
        }
        return field.getColumnName();
    }
}

