/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.pager;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.nutz.dao.pager.LoopScope;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.SqlContext;

public abstract class ResultSetLooping {
    protected List<Object> list = new LinkedList<Object>();
    private int index = -1;

    public void doLoop(ResultSet rs, SqlContext context) throws SQLException {
        block10: {
            Pager pager;
            block9: {
                pager = context.getPager();
                if (null == rs) {
                    return;
                }
                if (null != pager && 1003 != rs.getType() && pager.getPageNumber() > 0) break block9;
                while (rs.next()) {
                    this.createObject(++this.index, rs, context, -1);
                }
                break block10;
            }
            if (!rs.last()) break block10;
            if (pager.getPageSize() <= 0) {
                rs.setFetchSize(Pager.DEFAULT_PAGE_SIZE);
            } else if (pager.getPageSize() > Pager.MAX_FETCH_SIZE) {
                rs.setFetchSize(Pager.MAX_FETCH_SIZE);
            } else {
                rs.setFetchSize(pager.getPageSize());
            }
            int rowCount = rs.getRow();
            LoopScope ls = LoopScope.eval(pager, rowCount);
            if (rs.absolute(ls.start + 1)) {
                for (int i = ls.start; i < ls.max; ++i) {
                    this.createObject(++this.index, rs, context, rowCount);
                    if (rs.next()) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public List<Object> getList() {
        return this.list;
    }

    public int getIndex() {
        return this.index;
    }

    protected abstract boolean createObject(int var1, ResultSet var2, SqlContext var3, int var4);
}

