/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.nutz.dao.Chain;
import org.nutz.dao.Condition;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.Dao;
import org.nutz.dao.DaoException;
import org.nutz.dao.FieldFilter;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.dao.util.ExtDaoInvocationHandler;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.Scans;
import org.nutz.trans.Molecule;
import org.nutz.trans.Trans;

public abstract class Daos {
    private static final Log log = Logs.get();
    private static Class<?>[] iz = new Class[]{Dao.class};

    public static void safeClose(Statement stat, ResultSet rs) {
        Daos.safeClose(rs);
        Daos.safeClose(stat);
    }

    public static void safeClose(Statement stat) {
        if (null != stat) {
            try {
                stat.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getColumnIndex(ResultSetMetaData meta, String colName) throws SQLException {
        if (meta == null) {
            return 0;
        }
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnName(i).equalsIgnoreCase(colName)) continue;
            return i;
        }
        log.infof("Can not find @Column(%s) in table/view (%s)", colName, meta.getTableName(1));
        throw Lang.makeThrow(SQLException.class, "Can not find @Column(%s)", colName);
    }

    public static boolean isIntLikeColumn(ResultSetMetaData meta, int index) throws SQLException {
        switch (meta.getColumnType(index)) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static Pager updatePagerCount(Pager pager, Dao dao, Class<?> entityType, Condition cnd) {
        if (null != pager) {
            pager.setRecordCount(dao.count(entityType, cnd));
        }
        return pager;
    }

    public static Pager updatePagerCount(Pager pager, Dao dao, String tableName, Condition cnd) {
        if (null != pager) {
            pager.setRecordCount(dao.count(tableName, cnd));
        }
        return pager;
    }

    public static <T> List<T> queryList(Dao dao, Class<T> klass, String sql_str) {
        Sql sql = Sqls.create(sql_str).setCallback(Sqls.callback.entities()).setEntity(dao.getEntity(klass));
        dao.execute(sql);
        return sql.getList(klass);
    }

    public static Object query(Dao dao, String sql_str, SqlCallback callback) {
        Sql sql = Sqls.create(sql_str).setCallback(callback);
        dao.execute(sql);
        return sql.getResult();
    }

    public static <T> List<T> queryWithLinks(final Dao dao, final Class<T> classOfT, final Condition cnd, final Pager pager, final String regex) {
        Molecule molecule = new Molecule<List<T>>(){

            @Override
            public void run() {
                List list = dao.query(classOfT, cnd, pager);
                for (Object t : list) {
                    dao.fetchLinks(t, regex);
                }
                this.setObj(list);
            }
        };
        return (List)Trans.exec(molecule);
    }

    public static StringBuilder dataDict(DataSource ds, String ... packages) {
        Method evalFieldType;
        StringBuilder sb = new StringBuilder();
        ArrayList ks = new ArrayList();
        for (String packageName : packages) {
            ks.addAll(Scans.me().scanPackage(packageName));
        }
        Iterator it = ks.iterator();
        while (it.hasNext()) {
            Class klass = (Class)it.next();
            if (klass.getAnnotation(Table.class) != null) continue;
            it.remove();
        }
        JdbcExpert exp = Jdbcs.getExpert(ds);
        NutDao dao = new NutDao(ds);
        try {
            evalFieldType = exp.getClass().getDeclaredMethod("evalFieldType", MappingField.class);
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
        evalFieldType.setAccessible(true);
        Entity entity = null;
        String line = "-------------------------------------------------------------------\n";
        sb.append("#title:\u6570\u636e\u5b57\u5178\n");
        sb.append("#author:wendal\n");
        sb.append("#index:0,1\n").append(line);
        for (Class clazz : ks) {
            sb.append(line);
            entity = dao.getEntity(clazz);
            sb.append("\u8868\u540d ").append(entity.getTableName()).append("\n\n");
            if (!Strings.isBlank(entity.getTableComment())) {
                sb.append("\u8868\u6ce8\u91ca: ").append(entity.getTableComment());
            }
            sb.append("\t").append("Java\u7c7b\u540d ").append(clazz.getName()).append("\n\n");
            sb.append("\t||\u5e8f\u53f7||\u5217\u540d||\u6570\u636e\u7c7b\u578b||\u4e3b\u952e||\u975e\u7a7a||\u9ed8\u8ba4\u503c||java\u5c5e\u6027\u540d||java\u7c7b\u578b||\u6ce8\u91ca||\n");
            int index = 1;
            for (MappingField field : entity.getMappingFields()) {
                String dataType;
                try {
                    dataType = (String)evalFieldType.invoke((Object)exp, field);
                }
                catch (Throwable e) {
                    throw Lang.wrapThrow(e);
                }
                sb.append("\t||").append(index++).append("||").append(field.getColumnName()).append("||").append(dataType).append("||").append(field.isPk()).append("||").append(field.isNotNull()).append("||").append(field.getDefaultValue(null) == null ? " " : field.getDefaultValue(null)).append("||").append(field.getName()).append("||").append(field.getTypeClass().getName()).append("||").append(field.getColumnComment() == null ? " " : field.getColumnComment()).append("||\n");
            }
        }
        return sb;
    }

    public static <T> List<T> query(Dao dao, Class<T> classOfT, String sql, Condition cnd, Pager pager) {
        Sql sql2 = Sqls.queryEntity(sql);
        sql2.setEntity(dao.getEntity(classOfT));
        sql2.setCondition(cnd);
        sql2.setPager(pager);
        dao.execute(sql2);
        return sql2.getList(classOfT);
    }

    public static long queryCount(Dao dao, String sql) {
        Sql sql2 = Sqls.fetchInt("select count(1) from (" + sql + ") as _nutz_tmp_" + System.currentTimeMillis());
        dao.execute(sql2);
        return sql2.getInt();
    }

    public static int updateBySpecialChain(Dao dao, Entity en, String tableName, Chain chain, Condition cnd) {
        if (en != null) {
            tableName = en.getTableName();
        }
        if (tableName == null) {
            throw Lang.makeThrow(DaoException.class, "tableName and en is NULL !!", new Object[0]);
        }
        final StringBuilder sql = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        Chain head = chain.head();
        final ArrayList<Object> values = new ArrayList<Object>();
        final ArrayList<ValueAdaptor> adaptors = new ArrayList<ValueAdaptor>();
        while (head != null) {
            MappingField mf = null;
            if (en != null) {
                mf = en.getField(head.name());
            }
            String colName = head.name();
            if (mf != null) {
                colName = mf.getColumnName();
            }
            sql.append(colName).append("=");
            if (head.special()) {
                String str;
                if (head.value() != null && head.value() instanceof String && (str = (String)head.value()).length() > 0) {
                    switch (str.charAt(0)) {
                        case '%': 
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '^': 
                        case '|': {
                            sql.append(colName);
                        }
                    }
                }
                sql.append(head.value());
            } else {
                sql.append("?");
                values.add(head.value());
                ValueAdaptor adaptor = Jdbcs.getAdaptorBy(head.value());
                if (mf != null && mf.getAdaptor() != null) {
                    adaptor = mf.getAdaptor();
                }
                adaptors.add(adaptor);
            }
            sql.append(" ");
            if ((head = head.next()) == null) continue;
            sql.append(", ");
        }
        if (cnd != null) {
            sql.append(" ").append(cnd.toSql(en));
        }
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        final int[] ints = new int[1];
        dao.run(new ConnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Connection conn) throws Exception {
                PreparedStatement ps = conn.prepareStatement(sql.toString());
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        ((ValueAdaptor)adaptors.get(i)).set(ps, values.get(i), i + 1);
                    }
                    ints[0] = ps.executeUpdate();
                }
                finally {
                    Daos.safeClose(ps);
                }
            }
        });
        return ints[0];
    }

    public static void insertBySpecialChain(Dao dao, Entity en, String tableName, Chain chain) {
        if (en != null) {
            tableName = en.getTableName();
        }
        if (tableName == null) {
            throw Lang.makeThrow(DaoException.class, "tableName and en is NULL !!", new Object[0]);
        }
        final StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName).append(" (");
        StringBuilder _value_places = new StringBuilder(" VALUES(");
        final ArrayList<Object> values = new ArrayList<Object>();
        final ArrayList<ValueAdaptor> adaptors = new ArrayList<ValueAdaptor>();
        Chain head = chain.head();
        while (head != null) {
            String colName = head.name();
            MappingField mf = null;
            if (en != null && (mf = en.getField(colName)) != null) {
                colName = mf.getColumnName();
            }
            sql.append(colName);
            if (head.special()) {
                _value_places.append(head.value());
            } else {
                if (en != null) {
                    mf = en.getField(head.name());
                }
                _value_places.append("?");
                values.add(head.value());
                ValueAdaptor adaptor = Jdbcs.getAdaptorBy(head.value());
                if (mf != null && mf.getAdaptor() != null) {
                    adaptor = mf.getAdaptor();
                }
                adaptors.add(adaptor);
            }
            if ((head = head.next()) == null) continue;
            sql.append(", ");
            _value_places.append(", ");
        }
        sql.append(")");
        _value_places.append(")");
        sql.append((CharSequence)_value_places);
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        dao.run(new ConnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Connection conn) throws Exception {
                PreparedStatement ps = conn.prepareStatement(sql.toString());
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        ((ValueAdaptor)adaptors.get(i)).set(ps, values.get(i), i + 1);
                    }
                    ps.execute();
                }
                finally {
                    Daos.safeClose(ps);
                }
            }
        });
    }

    public static void createTablesInPackage(Dao dao, String packageName, boolean force) {
        for (Class<?> klass : Scans.me().scanPackage(packageName)) {
            if (klass.getAnnotation(Table.class) == null) continue;
            dao.create(klass, force);
        }
    }

    public static Dao ext(Dao dao, FieldFilter filter) {
        return Daos.ext(dao, filter, null);
    }

    public static Dao ext(Dao dao, Object tableName) {
        return Daos.ext(dao, null, tableName);
    }

    public static Dao ext(Dao dao, FieldFilter filter, Object tableName) {
        if (tableName == null && filter == null) {
            return dao;
        }
        ExtDaoInvocationHandler handler = new ExtDaoInvocationHandler(dao, filter, tableName);
        return (Dao)Proxy.newProxyInstance(dao.getClass().getClassLoader(), iz, (InvocationHandler)handler);
    }
}

