/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el.parse;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.nutz.el.parse.CharQueue;

public class CharQueueDefault
implements CharQueue {
    private Reader reader;
    private LinkedList<Integer> cache;
    private int cursor;

    public CharQueueDefault(Reader reader) {
        this.reader = reader;
        this.cache = new LinkedList();
        try {
            this.cursor = reader.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public char peek() {
        return (char)this.cursor;
    }

    @Override
    public char peek(int ofset) {
        if (ofset == 0) {
            return (char)this.cursor;
        }
        if (this.cache.size() > ofset - 1) {
            return (char)this.cache.get(ofset - 1).intValue();
        }
        int t = 0;
        for (int i = 0; i < ofset - this.cache.size(); ++i) {
            try {
                t = this.reader.read();
                this.cache.add(t);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (char)t;
    }

    @Override
    public char poll() {
        char x = (char)this.cursor;
        try {
            this.cursor = this.cache.isEmpty() ? this.reader.read() : this.cache.poll().intValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return x;
    }

    @Override
    public boolean isEmpty() {
        return this.cursor == -1;
    }
}

