/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.nutz.http.ProxySwitcher;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;

public class Http {
    protected static ProxySwitcher proxySwitcher;
    protected static boolean autoSwitch;

    public static Response get(String url) {
        return Sender.create(Request.get(url)).send();
    }

    public static Response get(String url, int timeout) {
        return Sender.create(Request.get(url)).setTimeout(timeout).send();
    }

    public static String post(String url, Map<String, Object> params, int timeout) {
        return Sender.create(Request.create(url, Request.METHOD.POST, params, null)).setTimeout(timeout).send().getContent();
    }

    public static Response post2(String url, Map<String, Object> params, int timeout) {
        return Sender.create(Request.create(url, Request.METHOD.POST, params, null)).setTimeout(timeout).send();
    }

    public static String encode(Object s) {
        if (null == s) {
            return "";
        }
        try {
            return URLEncoder.encode(s.toString(), Encoding.CHARSET_UTF8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static String post(String url, Map<String, Object> params, String inenc, String reenc) {
        return Sender.create(Request.create(url, Request.METHOD.POST, params, null).setEnc(inenc)).send().getContent(reenc);
    }

    public static void setAutoSwitch(boolean use) {
        autoSwitch = use;
    }

    public static void setHttpProxy(String host, int port) {
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        proxySwitcher = new ProxySwitcher(){

            @Override
            public Proxy getProxy(URL url) {
                return proxy;
            }

            @Override
            public Proxy getProxy(Request req) {
                if ("close".equals(req.getHeader().get("NoProxy"))) {
                    return null;
                }
                String url = req.getUrl().toString();
                if (url.startsWith("http") && url.contains("://") && url.length() > "https://".length() && ((url = url.substring(url.indexOf("://") + "://".length())).startsWith("127.0.0") || url.startsWith("localhost"))) {
                    return null;
                }
                req.getHeader().set("Connection", "close");
                return this.getProxy(req.getUrl());
            }
        };
    }

    public static void setSocktProxy(String host, int port) {
        final Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
        proxySwitcher = new ProxySwitcher(){

            @Override
            public Proxy getProxy(URL url) {
                return proxy;
            }

            @Override
            public Proxy getProxy(Request req) {
                if ("close".equals(req.getHeader().get("NoProxy"))) {
                    return null;
                }
                String url = req.getUrl().toString();
                if (url.startsWith("http") && url.contains("://") && url.length() > "https://".length() && ((url = url.substring(url.indexOf("://"))).startsWith("127.0.0") || url.startsWith("localhost"))) {
                    return null;
                }
                req.getHeader().set("Connection", "close");
                return this.getProxy(req.getUrl());
            }
        };
    }

    public static ProxySwitcher getProxySwitcher() {
        return proxySwitcher;
    }

    public static void setProxySwitcher(ProxySwitcher proxySwitcher) {
        Http.proxySwitcher = proxySwitcher;
    }

    public static boolean disableJvmHttpsCheck() {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            TrustManager[] tmArr = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            sc.init(null, tmArr, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            return true;
        }
        catch (KeyManagementException e) {
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static class multipart {
        public static String getBoundary(String contentType) {
            if (null == contentType) {
                return null;
            }
            for (String tmp : contentType.split(";")) {
                if (!(tmp = tmp.trim()).startsWith("boundary=")) continue;
                return tmp.substring("boundary=".length());
            }
            return null;
        }

        public static String formatName(String name, String filename, String contentType) {
            StringBuilder sb = new StringBuilder();
            sb.append("Content-Disposition: form-data; name=\"");
            sb.append(name);
            sb.append("\"");
            if (null != filename) {
                sb.append("; filename=\"" + filename + "\"");
            }
            if (null != contentType) {
                sb.append("\nContent-Type: " + contentType);
            }
            sb.append(20);
            return sb.toString();
        }

        public static String formatName(String name) {
            return multipart.formatName(name, null, null);
        }
    }
}

