/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nutz.http.Cookie;
import org.nutz.http.Header;
import org.nutz.http.Http;
import org.nutz.http.HttpException;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class Request {
    private String url;
    private METHOD method;
    private Header header;
    private Map<String, Object> params;
    private byte[] data;
    private URL cacheUrl;
    private InputStream inputStream;
    private String enc;

    public static Request get(String url) {
        return Request.create(url, METHOD.GET, new HashMap<String, Object>());
    }

    public static Request get(String url, Header header) {
        return Request.create(url, METHOD.GET, new HashMap<String, Object>(), header);
    }

    public static Request post(String url) {
        return Request.create(url, METHOD.POST, new HashMap<String, Object>());
    }

    public static Request post(String url, Header header) {
        return Request.create(url, METHOD.POST, new HashMap<String, Object>(), header);
    }

    public static Request create(String url, METHOD method) {
        return Request.create(url, method, new HashMap<String, Object>());
    }

    public static Request create(String url, METHOD method, String paramsAsJson, Header header) {
        return Request.create(url, method, (Map)Json.fromJson(paramsAsJson), header);
    }

    public static Request create(String url, METHOD method, String paramsAsJson) {
        return Request.create(url, method, (Map)Json.fromJson(paramsAsJson));
    }

    public static Request create(String url, METHOD method, Map<String, Object> params) {
        return Request.create(url, method, params, Header.create());
    }

    public static Request create(String url, METHOD method, Map<String, Object> params, Header header) {
        return new Request().setMethod(method).setParams(params).setUrl(url).setHeader(header);
    }

    private Request() {
    }

    public URL getUrl() {
        if (this.cacheUrl != null) {
            return this.cacheUrl;
        }
        StringBuilder sb = new StringBuilder(this.url);
        try {
            if (this.isGet() && null != this.params && this.params.size() > 0) {
                sb.append(this.url.indexOf(63) > 0 ? (char)'&' : '?');
                sb.append(this.getURLEncodedParams());
            }
            this.cacheUrl = new URL(sb.toString());
            return this.cacheUrl;
        }
        catch (Exception e) {
            throw new HttpException(sb.toString(), e);
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getURLEncodedParams() {
        StringBuilder sb = new StringBuilder();
        if (this.params != null) {
            Iterator<String> it = this.params.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                sb.append(Http.encode(key)).append('=').append(Http.encode(this.params.get(key)));
                if (!it.hasNext()) continue;
                sb.append('&');
            }
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (null == this.data) {
            if (this.enc != null) {
                try {
                    return new ByteArrayInputStream(this.getURLEncodedParams().getBytes(this.enc));
                }
                catch (UnsupportedEncodingException e) {
                    throw Lang.wrapThrow(e);
                }
            }
            return new ByteArrayInputStream(Strings.getBytesUTF8(this.getURLEncodedParams()));
        }
        return new ByteArrayInputStream(this.data);
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setData(String data) {
        try {
            this.data = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private Request setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public Request setUrl(String url) {
        this.url = url != null && url.indexOf("://") < 0 ? "http://" + url : url;
        return this;
    }

    public METHOD getMethod() {
        return this.method;
    }

    public boolean isGet() {
        return METHOD.GET == this.method;
    }

    public boolean isPost() {
        return METHOD.POST == this.method;
    }

    public boolean isDelete() {
        return METHOD.DELETE == this.method;
    }

    public boolean isPut() {
        return METHOD.PUT == this.method;
    }

    public Request setMethod(METHOD method) {
        this.method = method;
        return this;
    }

    public Header getHeader() {
        return this.header;
    }

    public Request setHeader(Header header) {
        this.header = header;
        return this;
    }

    public Request setCookie(Cookie cookie) {
        this.header.set("Cookie", cookie.toString());
        return this;
    }

    public Cookie getCookie() {
        String s = this.header.get("Cookie");
        if (null == s) {
            return new Cookie();
        }
        return new Cookie(s);
    }

    public Request setEnc(String reqEnc) {
        this.enc = reqEnc;
        return this;
    }

    public static enum METHOD {
        GET,
        POST,
        OPTIONS,
        PUT,
        DELETE,
        TRACE,
        CONNECT;

    }
}

