/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import org.nutz.http.Cookie;
import org.nutz.http.Header;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;

public class Response {
    private static final String DEF_PROTOCAL_VERSION = "HTTP/1.1";
    private Header header;
    private InputStream stream;
    private Cookie cookie;
    private String protocal = "HTTP/1.1";
    private int status;
    private String detail;
    private String content;

    public Response(HttpURLConnection conn, Map<String, String> reHeader) throws IOException {
        this.status = conn.getResponseCode();
        this.detail = conn.getResponseMessage();
        this.header = Header.create(reHeader);
        String s = this.header.get("Set-Cookie");
        if (null != s) {
            this.cookie = new Cookie(s);
        }
    }

    public String getProtocal() {
        return this.protocal;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public boolean isOK() {
        return this.status == 200;
    }

    public boolean isServerError() {
        return this.status >= 500 && this.status < 600;
    }

    public boolean isClientError() {
        return this.status >= 400 && this.status < 500;
    }

    void setStream(InputStream stream) {
        this.stream = stream;
    }

    public Header getHeader() {
        return this.header;
    }

    public String getEncodeType() {
        String contextType = this.header.get("Content-Type");
        if (null != contextType) {
            for (String tmp : contextType.split(";")) {
                if (tmp == null || !(tmp = tmp.trim()).startsWith("charset=")) continue;
                return Strings.trim(tmp.substring(8)).trim();
            }
        }
        return null;
    }

    public InputStream getStream() {
        return new BufferedInputStream(this.stream);
    }

    public Reader getReader() {
        String encoding = this.getEncodeType();
        if (null == encoding) {
            return this.getReader(Encoding.defaultEncoding());
        }
        return this.getReader(encoding);
    }

    public Reader getReader(String charsetName) {
        return new InputStreamReader(this.getStream(), Charset.forName(charsetName));
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public void printHeader(Writer writer) {
        try {
            writer.write(this.header.toString());
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public void print(Writer writer) {
        this.print(writer, null);
    }

    public void print(Writer writer, String charsetName) {
        Reader reader = null;
        try {
            int c;
            reader = null == charsetName ? this.getReader() : this.getReader(charsetName);
            char[] buf = new char[8192];
            while (-1 != (c = reader.read(buf))) {
                writer.write(buf, 0, c);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public String getContent() {
        if (Strings.isBlank(this.content)) {
            this.content = this.getContent(null);
        }
        return this.content;
    }

    public String getContent(String charsetName) {
        if (charsetName == null) {
            return Streams.readAndClose(this.getReader());
        }
        return Streams.readAndClose(this.getReader(charsetName));
    }
}

