/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.aop.config.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.matcher.SimpleMethodMatcher;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.aop.Aop;
import org.nutz.ioc.aop.config.AopConfigration;
import org.nutz.ioc.aop.config.InterceptorPair;
import org.nutz.lang.Mirror;

public class AnnotationAopConfigration
implements AopConfigration {
    @Override
    public List<InterceptorPair> getInterceptorPairList(Ioc ioc, Class<?> clazz) {
        Mirror<Class<?>> mirror = Mirror.me(clazz);
        List<Method> aops = this.getAopMethod(mirror);
        ArrayList<InterceptorPair> ipList = new ArrayList<InterceptorPair>();
        if (aops.size() < 1) {
            return ipList;
        }
        for (Method m : aops) {
            SimpleMethodMatcher mm = new SimpleMethodMatcher(m);
            for (String nm : m.getAnnotation(Aop.class).value()) {
                ipList.add(new InterceptorPair(ioc.get(MethodInterceptor.class, nm), mm));
            }
        }
        return ipList;
    }

    private <T> List<Method> getAopMethod(Mirror<T> mirror) {
        LinkedList<Method> aops = new LinkedList<Method>();
        for (Method m : mirror.getMethods()) {
            int modify;
            if (null == m.getAnnotation(Aop.class) || Modifier.isAbstract(modify = m.getModifiers()) || Modifier.isFinal(modify) || Modifier.isPrivate(modify) || Modifier.isStatic(modify)) continue;
            aops.add(m);
        }
        return aops;
    }
}

