/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.entity;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.json.JsonException;
import org.nutz.json.JsonField;
import org.nutz.json.JsonFormat;
import org.nutz.json.ToJson;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.born.Borning;
import org.nutz.lang.born.BorningException;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.Callback3;

public class JsonEntity {
    private List<JsonEntityField> fields;
    private Map<String, JsonEntityField> fieldMap = new HashMap<String, JsonEntityField>();
    private Borning<?> borning;
    private BorningException err;
    private Map<String, Integer> typeParams;
    private Method toJsonMethod;

    /*
     * WARNING - void declaration
     */
    public JsonEntity(Mirror<?> mirror) {
        Type type = mirror.getActuallyType();
        this.typeParams = new HashMap<String, Integer>();
        if (type instanceof ParameterizedType) {
            void var7_13;
            ParameterizedType pmType = (ParameterizedType)type;
            int i = 0;
            Type[] typeArray = pmType.getActualTypeArguments();
            int n = typeArray.length;
            boolean j = false;
            while (var7_13 < n) {
                Type pmA = typeArray[var7_13];
                this.typeParams.put(pmA.toString(), i++);
                ++var7_13;
            }
        }
        Field[] flds = mirror.getFields();
        this.fields = new ArrayList<JsonEntityField>(flds.length);
        for (Field field : flds) {
            JsonEntityField ef = JsonEntityField.eval(mirror, field);
            if (null == ef) continue;
            this.fields.add(ef);
            this.fieldMap.put(ef.getName(), ef);
        }
        for (AccessibleObject accessibleObject : mirror.getMethods()) {
            JsonField jf = ((Method)accessibleObject).getAnnotation(JsonField.class);
            if (null == jf || jf.ignore()) continue;
            AccessibleObject method = accessibleObject;
            Callback<Method> whenError = new Callback<Method>(){

                @Override
                public void invoke(Method m) {
                    throw Lang.makeThrow(JsonException.class, "JsonField '%s' should be getter/setter pair!", m);
                }
            };
            Callback3<String, Method, Method> whenOk = new Callback3<String, Method, Method>((Method)method, jf){
                final /* synthetic */ Method val$method;
                final /* synthetic */ JsonField val$jf;
                {
                    this.val$method = method;
                    this.val$jf = jsonField;
                }

                @Override
                public void invoke(String name, Method getter, Method setter) {
                    if (null == getter || null == setter || Strings.isBlank(name)) {
                        throw Lang.makeThrow(JsonException.class, "JsonField '%s' should be getter/setter pair!", this.val$method);
                    }
                    JsonEntityField ef = JsonEntityField.eval(Strings.sBlank(this.val$jf.value(), name), getter, setter);
                    JsonEntity.this.fields.add(ef);
                    JsonEntity.this.fieldMap.put(ef.getName(), ef);
                }
            };
            Mirror.evalGetterSetter((Method)accessibleObject, whenOk, whenError);
        }
        try {
            this.borning = mirror.getBorning(new Object[0]);
        }
        catch (BorningException e) {
            this.err = e;
        }
        Class<?> klass = mirror.getType();
        ToJson tj = klass.getAnnotation(ToJson.class);
        String myMethodName = Strings.sNull(null == tj ? null : tj.value(), "toJson");
        try {
            try {
                Method method = klass.getMethod(myMethodName, new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                this.toJsonMethod = method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method myMethod = klass.getMethod(myMethodName, JsonFormat.class);
                    if (!myMethod.isAccessible()) {
                        myMethod.setAccessible(true);
                    }
                    this.toJsonMethod = myMethod;
                }
                catch (NoSuchMethodException e) {}
            }
        }
        catch (Exception exception) {
            throw Lang.wrapThrow(exception);
        }
    }

    public List<JsonEntityField> getFields() {
        return this.fields;
    }

    public Object born() {
        if (null == this.borning) {
            throw this.err;
        }
        return this.borning.born(new Object[0]);
    }

    public JsonEntityField getField(String name) {
        return this.fieldMap.get(name);
    }

    public Method getToJsonMethod() {
        return this.toJsonMethod;
    }
}

