/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nutz.aop.DefaultClassDefiner;
import org.nutz.lang.reflect.ConstructorComparator;
import org.nutz.lang.reflect.FastClass;
import org.nutz.lang.reflect.FastClassAdpter;
import org.nutz.lang.reflect.MethodComparator;
import org.nutz.repo.org.objectweb.asm.ClassWriter;
import org.nutz.repo.org.objectweb.asm.MethodVisitor;
import org.nutz.repo.org.objectweb.asm.Opcodes;
import org.nutz.repo.org.objectweb.asm.Type;

public final class FastClassFactory
implements Opcodes {
    private static AtomicInteger count = new AtomicInteger();
    public static final String MethodArray_FieldName = "_$$Fast_methodArray";
    public static final String ConstructorArray_FieldName = "_$$Fast_constructorArray";
    public static final String SrcClass_FieldName = "_$$Fast_srcClass";
    public static final String FieldNameArray_FieldName = "_$$Fast_fieldNames";
    public static Map<String, FastClass> cache = new ConcurrentHashMap<String, FastClass>();
    private static final Object lock = new Object();

    public static FastClass get(Class<?> klass) {
        String cacheKey = klass.getName() + "_" + klass.getClassLoader();
        FastClass fastClass = cache.get(cacheKey);
        if (fastClass != null) {
            return fastClass;
        }
        Object object = lock;
        synchronized (object) {
            fastClass = cache.get(cacheKey);
            if (fastClass != null) {
                return fastClass;
            }
            Class<?> fclass = FastClassFactory.create(klass);
            try {
                fastClass = (FastClass)fclass.newInstance();
                cache.put(cacheKey, fastClass);
                return fastClass;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Fail to create FastClass for " + cacheKey, e);
            }
        }
    }

    protected static synchronized Class<?> create(Class<?> classZ) {
        String myName = classZ.getName().replace('.', '/') + "_FASTCLASS_" + count.getAndIncrement();
        ClassWriter cw = new ClassWriter(2);
        cw.visit(50, 1, myName, null, "org/nutz/lang/reflect/AbstractFastClass", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/nutz/lang/reflect/AbstractFastClass", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitField(9, MethodArray_FieldName, "[Ljava/lang/reflect/Method;", null, null).visitEnd();
        cw.visitField(9, ConstructorArray_FieldName, "[Ljava/lang/reflect/Constructor;", null, null).visitEnd();
        cw.visitField(9, SrcClass_FieldName, "Ljava/lang/Class;", "Ljava/lang/Class<*>;", null).visitEnd();
        mv = cw.visitMethod(4, "getMethods", "()[Ljava/lang/reflect/Method;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, myName, MethodArray_FieldName, "[Ljava/lang/reflect/Method;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "getConstructors", "()[Ljava/lang/reflect/Constructor;", "()[Ljava/lang/reflect/Constructor<*>;", null);
        mv.visitCode();
        mv.visitFieldInsn(178, myName, ConstructorArray_FieldName, "[Ljava/lang/reflect/Constructor;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "getSrcClass", "()Ljava/lang/Class;", "()Ljava/lang/Class<*>;", null);
        mv.visitCode();
        mv.visitFieldInsn(178, myName, SrcClass_FieldName, "Ljava/lang/Class;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        Method[] methods = classZ.getMethods();
        Arrays.sort(methods, new MethodComparator());
        String[] methodNames = new String[methods.length];
        String[] descs = new String[methods.length];
        int[] modifies = new int[methods.length];
        int[] invokeOps = new int[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodNames[i] = methods[i].getName();
            descs[i] = Type.getMethodDescriptor(methods[i]);
            modifies[i] = methods[i].getModifiers();
            invokeOps[i] = classZ.isInterface() ? 185 : (Modifier.isAbstract(methods[i].getModifiers()) ? 183 : (Modifier.isStatic(methods[i].getModifiers()) ? 184 : 182));
        }
        FastClassAdpter.createInokeMethod(cw.visitMethod(129, "_invoke", "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;", null, null), methodNames, descs, modifies, invokeOps, classZ.getName().replace('.', '/'));
        Constructor<?>[] constructors = classZ.getConstructors();
        Arrays.sort(constructors, new ConstructorComparator());
        if (constructors.length > 0) {
            FastClassAdpter.createInokeConstructor(cw.visitMethod(132, "_born", "(I[Ljava/lang/Object;)Ljava/lang/Object;", null, null), classZ.getName().replace('.', '/'), constructors);
        }
        cw.visitEnd();
        Class<?> xClass = DefaultClassDefiner.def(myName.replace('/', '.'), cw.toByteArray());
        try {
            xClass.getField(SrcClass_FieldName).set(null, classZ);
            xClass.getField(MethodArray_FieldName).set(null, methods);
            xClass.getField(ConstructorArray_FieldName).set(null, constructors);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return xClass;
    }
}

