/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.socket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.nutz.lang.Strings;
import org.nutz.lang.socket.CloseSocketException;
import org.nutz.lang.socket.SocketAction;
import org.nutz.lang.socket.SocketActionTable;
import org.nutz.lang.socket.SocketContext;
import org.nutz.lang.socket.Sockets;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Atom;

public class SocketAtom
implements Atom {
    private static final Log log = Logs.get();
    protected Socket socket;
    protected OutputStream ops;
    protected BufferedReader br;
    protected String line;
    protected SocketActionTable saTable;
    protected Context context;

    public SocketAtom(Context context, Socket socket, SocketActionTable saTable) {
        this.context = context;
        this.socket = socket;
        this.saTable = saTable;
    }

    @Override
    public void run() {
        if (this.context.getBoolean("stop")) {
            if (log.isInfoEnabled()) {
                log.info("stop=true, so, exit ....");
            }
            Sockets.safeClose(this.socket);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debugf("connect with '%s'", this.socket.getRemoteSocketAddress().toString());
        }
        try {
            this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.ops = this.socket.getOutputStream();
        }
        catch (IOException e1) {
            return;
        }
        try {
            this.doRun();
        }
        catch (SocketException e) {
        }
        catch (CloseSocketException e) {
            if (log.isInfoEnabled()) {
                log.info("Catch CloseSocketException , set lock stop");
            }
            this.context.set("stop", true);
        }
        catch (IOException e) {
            log.error("Error!! ", e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("Close socket");
            }
            Sockets.safeClose(this.socket);
        }
    }

    protected void doRun() throws IOException {
        this.line = this.br.readLine();
        while (null != this.line) {
            SocketAction action;
            if (log.isDebugEnabled()) {
                log.debug("  <<socket<<: " + this.line);
            }
            if (null != (action = this.saTable.get(Strings.trim(this.line)))) {
                SocketContext context = new SocketContext(this);
                action.run(context);
            }
            this.line = this.br.readLine();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }
}

