/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nutz.castor.Castors;
import org.nutz.lang.Each;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class NutMap
extends LinkedHashMap<String, Object> {
    public static NutMap WRAP(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        if (map instanceof NutMap) {
            return (NutMap)map;
        }
        return new NutMap(map);
    }

    public NutMap() {
    }

    public NutMap(Map<String, Object> map) {
        this.putAll(map);
    }

    public NutMap(String json) {
        this.putAll(Lang.map(json));
    }

    public void setOrRemove(String key, Object v) {
        if (null == v) {
            this.remove(key);
        } else {
            this.put(key, v);
        }
    }

    public static NutMap NEW() {
        return new NutMap();
    }

    public static NutMap WRAP(String json) {
        return new NutMap(json);
    }

    public Object get(String key, Object dft) {
        Object v = this.get(key);
        return null == v ? dft : v;
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public int getInt(String key, int dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Integer.TYPE);
    }

    public float getFloat(String key) {
        return this.getFloat(key, Float.NaN);
    }

    public float getFloat(String key, float dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Float.TYPE).floatValue();
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String key, long dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Long.TYPE);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Double.TYPE);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Boolean.TYPE);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String dft) {
        Object v = this.get(key);
        if (v == null) {
            return dft;
        }
        if (v instanceof List) {
            v = ((List)v).iterator().next();
        }
        return Castors.me().castTo(v, String.class);
    }

    public Date getTime(String key) {
        return this.getTime(key, null);
    }

    public Date getTime(String key, Date dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, Date.class);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> classOfEnum) {
        String s = this.getString(key);
        if (Strings.isBlank(s)) {
            return null;
        }
        return Enum.valueOf(classOfEnum, s);
    }

    public boolean isEnum(String key, Enum<?> ... eus) {
        if (null == eus || eus.length == 0) {
            return false;
        }
        try {
            Object v = this.getEnum(key, eus[0].getClass());
            for (Enum<?> eu : eus) {
                if (((Enum)v).equals(eu)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T> T getAs(String key, Class<T> classOfT) {
        return this.getAs(key, classOfT, null);
    }

    public <T> T getAs(String key, Class<T> classOfT, T dft) {
        Object v = this.get(key);
        return null == v ? dft : Castors.me().castTo(v, classOfT);
    }

    public <T> List<T> getList(String key, final Class<T> eleType) {
        Object v = this.get(key);
        if (null == v) {
            return new ArrayList();
        }
        if (v instanceof CharSequence) {
            return Lang.list(Castors.me().castTo(v, eleType));
        }
        int len = Lang.length(v);
        final ArrayList list = new ArrayList(len);
        Lang.each(v, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) {
                list.add(Castors.me().castTo(ele, eleType));
            }
        });
        return list;
    }

    public <T> T[] getArray(String key, final Class<T> eleType) {
        Object v = this.get(key);
        if (null == v) {
            return (Object[])Array.newInstance(eleType, 0);
        }
        if (v instanceof CharSequence) {
            return Lang.array(Castors.me().castTo(v, eleType));
        }
        int len = Lang.length(v);
        final Object arr = Array.newInstance(eleType, len);
        final int[] i = new int[]{0};
        Lang.each(v, new Each<Object>(){

            @Override
            public void invoke(int index, Object ele, int length) {
                int n = i[0];
                i[0] = n + 1;
                Array.set(arr, n, Castors.me().castTo(ele, eleType));
            }
        });
        return (Object[])arr;
    }

    public NutMap addv(String key, Object value) {
        Object obj = this.get(key);
        if (null == obj) {
            this.put(key, value);
        } else if (obj instanceof List) {
            ((List)obj).add(value);
        } else {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(obj);
            list.add(value);
            this.put(key, list);
        }
        return this;
    }

    public NutMap putv(String key, Object value) {
        return this.addv(key, value);
    }

    public NutMap setv(String key, Object value) {
        this.put(key, value);
        return this;
    }
}

