/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.util.ArrayList;
import java.util.List;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.meta.Pair;
import org.nutz.lang.util.HtmlToken;
import org.nutz.lang.util.Node;
import org.nutz.lang.util.SimpleNode;

public class Tag
extends SimpleNode<HtmlToken> {
    public static Tag tag(String name, String ... attrs) {
        Tag tag = new Tag();
        tag.set(new HtmlToken().setName(name));
        if (null != attrs) {
            block4: for (String attr : attrs) {
                if (null == attr || attr.length() <= 1) continue;
                char c = attr.charAt(0);
                switch (c) {
                    case '.': {
                        tag.addClass(attr.substring(1));
                        continue block4;
                    }
                    case '#': {
                        tag.id(attr.substring(1));
                        continue block4;
                    }
                    default: {
                        Pair<String> p = Pair.create(attr);
                        tag.attr(p.getName(), p.getValue());
                    }
                }
            }
        }
        return tag;
    }

    public static Tag text(String text) {
        Tag tag = new Tag();
        if (null != text) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;").replace(">", "&gt;");
        }
        tag.set(new HtmlToken().setValue(text));
        return tag;
    }

    public boolean isBlock() {
        return ((HtmlToken)this.get()).isBlock();
    }

    public boolean isInline() {
        return ((HtmlToken)this.get()).isInline();
    }

    public boolean isNoChild() {
        return ((HtmlToken)this.get()).isNoChild();
    }

    public boolean isHtml() {
        return "html".equalsIgnoreCase(((HtmlToken)this.get()).getName());
    }

    public boolean isBody() {
        return "body".equalsIgnoreCase(((HtmlToken)this.get()).getName());
    }

    public boolean isChildAllInline() {
        if (!((HtmlToken)this.get()).isElement()) {
            return false;
        }
        for (Node ht : this.getChildren()) {
            if (!((HtmlToken)ht.get()).isBlock()) continue;
            return false;
        }
        return true;
    }

    public String name() {
        return ((HtmlToken)this.get()).getName();
    }

    public Tag attr(String name, String value) {
        ((HtmlToken)this.get()).attr(name, value);
        return this;
    }

    public Tag attr(String name, int value) {
        return this.attr(name, String.valueOf(value));
    }

    public Tag addClass(String name) {
        String cns = ((HtmlToken)this.get()).getAttrVal("class");
        String[] nms = Strings.splitIgnoreBlank(cns, " ");
        if (null == nms) {
            ((HtmlToken)this.get()).attr("class", name);
        } else if (!Lang.contains(nms, name)) {
            ((HtmlToken)this.get()).attr("class", cns + " " + name);
        }
        return this;
    }

    public boolean hasClass(String name) {
        String cns = ((HtmlToken)this.get()).getAttrVal("class");
        if (null == cns || cns.length() < name.length()) {
            return false;
        }
        return (" " + cns + " ").indexOf(" " + name + " ") != -1;
    }

    public Tag add(String tagName, String ... attrs) {
        Tag re = Tag.tag(tagName, attrs);
        this.add(re);
        return re;
    }

    public Tag id(String id) {
        ((HtmlToken)this.get()).attr("id", id);
        return this;
    }

    public String id() {
        return ((HtmlToken)this.get()).getAttrVal("id");
    }

    public Tag setText(String text) {
        this.add(Tag.text(text));
        return this;
    }

    public List<Tag> childrenTag() {
        List children = this.getChildren();
        ArrayList<Tag> list = new ArrayList<Tag>(children.size());
        for (Node nd : children) {
            list.add((Tag)nd);
        }
        return list;
    }

    @Override
    public String toString() {
        if (((HtmlToken)this.get()).isText()) {
            return ((HtmlToken)this.get()).getValue();
        }
        StringBuilder sb = new StringBuilder();
        if (this.isNoChild()) {
            return String.format("<%s%s/>", this.name(), this.attributes2String());
        }
        if (this.isInline()) {
            sb.append(String.format("<%s", this.name())).append(this.attributes2String()).append('>');
            for (Node tag : this.getChildren()) {
                sb.append(tag);
            }
            sb.append(String.format("</%s>", this.name()));
        } else {
            sb.append(String.format("<%s", this.name()));
            sb.append(this.attributes2String()).append('>');
            for (Node tag : this.getChildren()) {
                if (((HtmlToken)tag.get()).isBlock() || ((HtmlToken)tag.get()).isBody()) {
                    sb.append('\n');
                }
                sb.append(tag.toString());
            }
            if (!this.isChildAllInline()) {
                sb.append('\n');
            }
            sb.append(String.format("</%s>", this.name()));
        }
        return sb.toString();
    }

    private String attributes2String() {
        StringBuilder sb = new StringBuilder();
        for (Pair<String> attr : ((HtmlToken)this.get()).getAttributes()) {
            sb.append(' ').append(attr.toString());
        }
        return sb.toString();
    }
}

