/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.log.impl;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.nutz.log.Log;
import org.nutz.log.LogAdapter;
import org.nutz.log.impl.AbstractLog;
import org.nutz.plugin.Plugin;

public class Log4jLogAdapter
implements LogAdapter,
Plugin {
    @Override
    public boolean canWork() {
        try {
            Class.forName("org.apache.log4j.Logger", false, Log4jLogAdapter.class.getClassLoader());
            System.out.println("ALL Nutz Log via Log4jLogAdapter");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public Log getLogger(String className) {
        return new Log4JLogger(className);
    }

    static class Log4JLogger
    extends AbstractLog {
        public static final String SUPER_FQCN = AbstractLog.class.getName();
        public static final String SELF_FQCN = Log4JLogger.class.getName();
        private Logger logger;
        private static boolean hasTrace;

        Log4JLogger(String className) {
            this.logger = Logger.getLogger((String)className);
            this.isFatalEnabled = this.logger.isEnabledFor((Priority)Level.FATAL);
            this.isErrorEnabled = this.logger.isEnabledFor((Priority)Level.ERROR);
            this.isWarnEnabled = this.logger.isEnabledFor((Priority)Level.WARN);
            this.isInfoEnabled = this.logger.isEnabledFor((Priority)Level.INFO);
            this.isDebugEnabled = this.logger.isEnabledFor((Priority)Level.DEBUG);
            if (hasTrace) {
                this.isTraceEnabled = this.logger.isEnabledFor((Priority)Level.TRACE);
            }
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.log(SELF_FQCN, (Priority)Level.DEBUG, message, t);
            }
        }

        @Override
        public void error(Object message, Throwable t) {
            if (this.isErrorEnabled()) {
                this.logger.log(SELF_FQCN, (Priority)Level.ERROR, message, t);
            }
        }

        @Override
        public void fatal(Object message, Throwable t) {
            if (this.isFatalEnabled()) {
                this.logger.log(SELF_FQCN, (Priority)Level.FATAL, message, t);
            }
        }

        @Override
        public void info(Object message, Throwable t) {
            if (this.isInfoEnabled()) {
                this.logger.log(SELF_FQCN, (Priority)Level.INFO, message, t);
            }
        }

        @Override
        public void trace(Object message, Throwable t) {
            if (this.isTraceEnabled()) {
                this.logger.log(SELF_FQCN, (Priority)Level.TRACE, message, t);
            } else if (!hasTrace && this.isDebugEnabled()) {
                this.logger.log(SELF_FQCN, (Priority)Level.DEBUG, message, t);
            }
        }

        @Override
        public void warn(Object message, Throwable t) {
            if (this.isWarnEnabled()) {
                this.logger.log(SELF_FQCN, (Priority)Level.WARN, message, t);
            }
        }

        @Override
        protected void log(int level, Object message, Throwable tx) {
            switch (level) {
                case 50: {
                    this.logger.log(SUPER_FQCN, (Priority)Level.FATAL, message, tx);
                    break;
                }
                case 40: {
                    this.logger.log(SUPER_FQCN, (Priority)Level.ERROR, message, tx);
                    break;
                }
                case 30: {
                    this.logger.log(SUPER_FQCN, (Priority)Level.WARN, message, tx);
                    break;
                }
                case 20: {
                    this.logger.log(SUPER_FQCN, (Priority)Level.INFO, message, tx);
                    break;
                }
                case 10: {
                    this.logger.log(SUPER_FQCN, (Priority)Level.DEBUG, message, tx);
                    break;
                }
                case 0: {
                    if (hasTrace) {
                        this.logger.log(SUPER_FQCN, (Priority)Level.TRACE, message, tx);
                        break;
                    }
                    this.logger.log(SUPER_FQCN, (Priority)Level.DEBUG, message, tx);
                    break;
                }
            }
        }

        static {
            try {
                Level.class.getDeclaredField("TRACE");
                hasTrace = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

