/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocContext;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Context;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.NutMvcContext;
import org.nutz.mvc.RequestPath;
import org.nutz.mvc.config.AtMap;
import org.nutz.mvc.impl.NutMessageMap;
import org.nutz.mvc.ioc.SessionIocContext;

public abstract class Mvcs {
    public static final String DEFAULT_MSGS = "$default";
    public static final String MSG = "msg";
    public static final String LOCALE_KEY = "nutz_mvc_localization_key";
    public static String ann_dynamic_path = null;
    private static String default_localization_key = null;
    private static final ThreadLocal<String> NAME = new ThreadLocal();
    @Deprecated
    public static NutMvcContext ctx;
    private static ServletContext def_servletContext;
    private static ThreadLocal<ServletContext> servletContext;
    public static boolean disableFastClassInvoker;

    public static Map<String, Object> getLocaleMessage(String key) {
        Map<String, Map<String, Object>> msgss = Mvcs.getMessageSet();
        if (null != msgss) {
            return msgss.get(key);
        }
        return null;
    }

    public static Map<String, String> getMessages(ServletRequest req) {
        return (Map)req.getAttribute(MSG);
    }

    public static NutMessageMap getMessageMap(ServletRequest req) {
        return (NutMessageMap)req.getAttribute(MSG);
    }

    public static String getMessage(ServletRequest req, String key) {
        Map<String, String> map = Mvcs.getMessages(req);
        if (null != map) {
            return map.get(key);
        }
        return null;
    }

    public static String getLocalizationKey() {
        HttpSession sess = Mvcs.getHttpSession(false);
        return null == sess ? null : (String)sess.getAttribute(LOCALE_KEY);
    }

    public static boolean setLocalizationKey(String key) {
        HttpSession sess = Mvcs.getHttpSession();
        if (null == sess) {
            return false;
        }
        sess.setAttribute(LOCALE_KEY, (Object)key);
        return true;
    }

    public static Set<String> getLocalizationKeySet() {
        Map<String, Map<String, Object>> msgss = Mvcs.getMessageSet();
        if (null == msgss) {
            return new HashSet<String>();
        }
        return msgss.keySet();
    }

    public static void setDefaultLocalizationKey(String key) {
        default_localization_key = key;
    }

    public static String getDefaultLocalizationKey() {
        return default_localization_key;
    }

    public static void updateRequestAttributes(HttpServletRequest req) {
        Map<String, Map<String, Object>> msgss = Mvcs.getMessageSet();
        if (msgss == null && !Mvcs.ctx().localizations.isEmpty()) {
            msgss = Mvcs.ctx().localizations.values().iterator().next();
        }
        if (null != msgss) {
            Map<String, Object> msgs = null;
            String lKey = Strings.sBlank(Mvcs.getLocalizationKey(), Mvcs.getDefaultLocalizationKey());
            if (!Strings.isBlank(lKey)) {
                msgs = msgss.get(lKey);
            }
            if (null == msgs && msgss.size() > 0) {
                msgs = msgss.values().iterator().next();
            }
            req.setAttribute(MSG, msgs);
        }
        req.setAttribute("base", (Object)req.getContextPath());
        req.setAttribute("$request", (Object)req);
    }

    public static String getRequestPath(HttpServletRequest req) {
        return Mvcs.getRequestPathObject(req).getPath();
    }

    public static RequestPath getRequestPathObject(HttpServletRequest req) {
        String url = req.getPathInfo();
        if (null == url) {
            url = req.getServletPath();
        }
        return Mvcs.getRequestPathObject(url);
    }

    public static RequestPath getRequestPathObject(String url) {
        RequestPath rr = new RequestPath();
        rr.setUrl(url);
        if (null != url) {
            int lio = 0;
            if (!url.endsWith("/")) {
                int ll = url.lastIndexOf(47);
                lio = url.lastIndexOf(46);
                if (lio < ll) {
                    lio = -1;
                }
            }
            if (lio > 0) {
                rr.setPath(url.substring(0, lio));
                rr.setSuffix(url.substring(lio + 1));
            } else {
                rr.setPath(url);
                rr.setSuffix("");
            }
        } else {
            rr.setPath("");
            rr.setSuffix("");
        }
        return rr;
    }

    public static void deposeSession(HttpSession session) {
        if (session != null) {
            new SessionIocContext(session).depose();
        }
    }

    public static void write(HttpServletResponse resp, Object obj, JsonFormat format) throws IOException {
        resp.setHeader("Cache-Control", "no-cache");
        if (resp.getContentType() == null) {
            resp.setContentType("text/plain");
        }
        Json.toJson(resp.getWriter(), obj, format);
        resp.flushBuffer();
    }

    public static NutMvcContext ctx() {
        ServletContext sc = Mvcs.getServletContext();
        if (sc == null) {
            if (ctx == null) {
                ctx = new NutMvcContext();
            }
            return ctx;
        }
        NutMvcContext c = (NutMvcContext)Mvcs.getServletContext().getAttribute("__nutz__mvc__ctx");
        if (c == null) {
            c = new NutMvcContext();
            Mvcs.getServletContext().setAttribute("__nutz__mvc__ctx", (Object)c);
            ctx = c;
        }
        return c;
    }

    public static final HttpServletRequest getReq() {
        return Mvcs.ctx().reqThreadLocal.get().getAs(HttpServletRequest.class, "req");
    }

    public static final HttpServletResponse getResp() {
        return Mvcs.ctx().reqThreadLocal.get().getAs(HttpServletResponse.class, "resp");
    }

    public static final String getName() {
        return NAME.get();
    }

    public static final ActionContext getActionContext() {
        return Mvcs.ctx().reqThreadLocal.get().getAs(ActionContext.class, "ActionContext");
    }

    public static void set(String name, HttpServletRequest req, HttpServletResponse resp) {
        NAME.set(name);
        Mvcs.ctx().reqThreadLocal.get().set("req", req);
        Mvcs.ctx().reqThreadLocal.get().set("resp", resp);
    }

    public static void setServletContext(ServletContext servletContext) {
        if (def_servletContext == null) {
            def_servletContext = servletContext;
        }
        Mvcs.servletContext.set(servletContext);
    }

    public static void setActionContext(ActionContext actionContext) {
        Mvcs.ctx().reqThreadLocal.get().set("ActionContext", actionContext);
    }

    public static ServletContext getServletContext() {
        ServletContext cnt = servletContext.get();
        if (cnt != null) {
            return cnt;
        }
        return def_servletContext;
    }

    public static void setIocContext(IocContext iocContext) {
        Mvcs.ctx().reqThreadLocal.get().set("IocContext", iocContext);
    }

    public static IocContext getIocContext() {
        return Mvcs.ctx().reqThreadLocal.get().getAs(IocContext.class, "IocContext");
    }

    public static Ioc getIoc() {
        return Mvcs.ctx().iocs.get(Mvcs.getName());
    }

    public static void setIoc(Ioc ioc) {
        Mvcs.ctx().iocs.put(Mvcs.getName(), ioc);
    }

    public static AtMap getAtMap() {
        return Mvcs.ctx().atMaps.get(Mvcs.getName());
    }

    public static void setAtMap(AtMap atmap) {
        Mvcs.ctx().atMaps.put(Mvcs.getName(), atmap);
    }

    public static Map<String, Map<String, Object>> getMessageSet() {
        return Mvcs.ctx().localizations.get(Mvcs.getName());
    }

    public static void setMessageSet(Map<String, Map<String, Object>> messageSet) {
        Mvcs.ctx().localizations.put(Mvcs.getName(), messageSet);
    }

    public static void setNutConfig(NutConfig config) {
        Mvcs.ctx().nutConfigs.put(Mvcs.getName(), config);
    }

    public static NutConfig getNutConfig() {
        return Mvcs.ctx().nutConfigs.get(Mvcs.getName());
    }

    public static Context resetALL() {
        Context context = Mvcs.ctx().reqThreadLocal.get();
        NAME.set(null);
        Mvcs.ctx().reqThreadLocal.set(Lang.context());
        return context;
    }

    public static HttpSession getHttpSession() {
        return Mvcs.getHttpSession(true);
    }

    public static HttpSession getHttpSession(boolean createNew) {
        HttpServletRequest req = Mvcs.getReq();
        if (null == req) {
            return null;
        }
        return req.getSession(createNew);
    }

    public static void close() {
        Mvcs.ctx().clear();
        Mvcs.ctx().close();
    }

    static {
        servletContext = new ThreadLocal();
        disableFastClassInvoker = Lang.isAndroid;
    }
}

