/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.nutz.Nutz;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.Ioc2;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Stopwatch;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChainMaker;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.IocProvider;
import org.nutz.mvc.Loading;
import org.nutz.mvc.LoadingException;
import org.nutz.mvc.MessageLoader;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.SessionProvider;
import org.nutz.mvc.Setup;
import org.nutz.mvc.UrlMapping;
import org.nutz.mvc.ViewMaker;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.ChainBy;
import org.nutz.mvc.annotation.IocBy;
import org.nutz.mvc.annotation.Localization;
import org.nutz.mvc.annotation.SessionBy;
import org.nutz.mvc.annotation.SetupBy;
import org.nutz.mvc.annotation.UrlMappingBy;
import org.nutz.mvc.annotation.Views;
import org.nutz.mvc.impl.Loadings;
import org.nutz.mvc.impl.NutActionChainMaker;
import org.nutz.mvc.impl.ServletValueProxyMaker;
import org.nutz.mvc.impl.UrlMappingImpl;
import org.nutz.mvc.view.DefaultViewMaker;

public class NutLoading
implements Loading {
    private static final Log log = Logs.get();

    @Override
    public UrlMapping load(NutConfig config) {
        UrlMapping mapping;
        if (log.isInfoEnabled()) {
            log.infof("Nutz Version : %s ", Nutz.version());
            log.infof("Nutz.Mvc[%s] is initializing ...", config.getAppName());
        }
        if (log.isDebugEnabled()) {
            Properties sys = System.getProperties();
            log.debug("Web Container Information:");
            log.debugf(" - Default Charset : %s", Encoding.defaultEncoding());
            log.debugf(" - Current . path  : %s", new File(".").getAbsolutePath());
            log.debugf(" - Java Version    : %s", sys.get("java.version"));
            log.debugf(" - File separator  : %s", sys.get("file.separator"));
            log.debugf(" - Timezone        : %s", sys.get("user.timezone"));
            log.debugf(" - OS              : %s %s", sys.get("os.name"), sys.get("os.arch"));
            log.debugf(" - ServerInfo      : %s", config.getServletContext().getServerInfo());
            log.debugf(" - Servlet API     : %d.%d", config.getServletContext().getMajorVersion(), config.getServletContext().getMinorVersion());
            if (config.getServletContext().getMajorVersion() > 2 || config.getServletContext().getMinorVersion() > 4) {
                log.debugf(" - ContextPath     : %s", config.getServletContext().getContextPath());
            }
        }
        Stopwatch sw = Stopwatch.begin();
        try {
            Class<?> mainModule = config.getMainModule();
            this.createContext(config);
            Ioc ioc = this.createIoc(config, mainModule);
            mapping = this.evalUrlMapping(config, mainModule, ioc);
            this.evalLocalization(config, mainModule);
            this.createSessionProvider(config, mainModule);
            this.evalSetup(config, mainModule);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error happend during start serivce!", e);
            }
            throw Lang.wrapThrow(e, LoadingException.class);
        }
        sw.stop();
        if (log.isInfoEnabled()) {
            log.infof("Nutz.Mvc[%s] is up in %sms", config.getAppName(), sw.getDuration());
        }
        return mapping;
    }

    protected UrlMapping evalUrlMapping(NutConfig config, Class<?> mainModule, Ioc ioc) throws Exception {
        UrlMapping mapping = this.createUrlMapping(config);
        if (log.isInfoEnabled()) {
            log.infof("Build URL mapping by %s ...", mapping.getClass().getName());
        }
        ViewMaker[] makers = this.createViewMakers(mainModule, ioc);
        ActionChainMaker maker = this.createChainMaker(config, mainModule);
        ActionInfo mainInfo = Loadings.createInfo(mainModule);
        Set<Class<?>> modules = Loadings.scanModules(mainModule);
        if (modules.isEmpty() && log.isWarnEnabled()) {
            log.warn("None module classes found!!!");
        }
        int atMethods = 0;
        for (Class<?> module : modules) {
            ActionInfo moduleInfo = Loadings.createInfo(module).mergeWith(mainInfo);
            for (Method method : module.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(At.class)) continue;
                ActionInfo info = Loadings.createInfo(method).mergeWith(moduleInfo);
                info.setViewMakers(makers);
                mapping.add(maker, info, config);
                ++atMethods;
            }
            if (null == moduleInfo.getPathMap()) continue;
            for (Map.Entry entry : moduleInfo.getPathMap().entrySet()) {
                config.getAtMap().add((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (atMethods == 0) {
            if (log.isWarnEnabled()) {
                log.warn("None @At found in any modules class!!");
            }
        } else {
            log.infof("Found %d module methods", atMethods);
        }
        return mapping;
    }

    protected void createContext(NutConfig config) {
        Context context = Lang.context();
        String appRoot = config.getAppRoot();
        context.set("app.root", appRoot);
        if (log.isDebugEnabled()) {
            log.debugf(">> app.root = %s", appRoot);
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            context.set("env." + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            context.set("sys." + entry.getKey(), entry.getValue());
        }
        if (log.isTraceEnabled()) {
            log.tracef(">>\nCONTEXT %s", Json.toJson(context, JsonFormat.nice()));
        }
        config.getServletContext().setAttribute("_NUTZ_LOADING_CONTEXT_", (Object)context);
    }

    protected UrlMapping createUrlMapping(NutConfig config) throws Exception {
        UrlMappingBy umb = config.getMainModule().getAnnotation(UrlMappingBy.class);
        if (umb != null) {
            return Loadings.evalObj(config, umb.value(), umb.args());
        }
        return new UrlMappingImpl();
    }

    protected ActionChainMaker createChainMaker(NutConfig config, Class<?> mainModule) {
        NutActionChainMaker maker;
        ChainBy ann = mainModule.getAnnotation(ChainBy.class);
        ActionChainMaker actionChainMaker = maker = null == ann ? new NutActionChainMaker(new String[0]) : Loadings.evalObj(config, ann.type(), ann.args());
        if (log.isDebugEnabled()) {
            log.debugf("@ChainBy(%s)", maker.getClass().getName());
        }
        return maker;
    }

    protected void evalSetup(NutConfig config, Class<?> mainModule) throws Exception {
        SetupBy sb = mainModule.getAnnotation(SetupBy.class);
        if (null != sb) {
            if (log.isInfoEnabled()) {
                log.info("Setup application...");
            }
            Setup setup = Loadings.evalObj(config, sb.value(), sb.args());
            config.setAttributeIgnoreNull(Setup.class.getName(), setup);
            setup.init(config);
        } else if (config.getIoc() != null && config.getIoc().has("$setup")) {
            Object[] names = config.getIoc().getNames();
            Arrays.sort(names);
            boolean flag = true;
            for (Object name : names) {
                if (name == null || !((String)name).startsWith("$setup")) continue;
                if (flag) {
                    flag = false;
                    if (log.isInfoEnabled()) {
                        log.info("Setup application...");
                    }
                }
                log.debug("load Setup from Ioc by name=$setup");
                Setup setup = config.getIoc().get(Setup.class, "$setup");
                config.setAttributeIgnoreNull(Setup.class.getName(), setup);
                setup.init(config);
            }
        }
    }

    protected void evalLocalization(NutConfig config, Class<?> mainModule) {
        Localization lc = mainModule.getAnnotation(Localization.class);
        if (null != lc) {
            if (log.isDebugEnabled()) {
                log.debugf("Localization: %s('%s') %s dft<%s>", lc.type().getName(), lc.value(), Strings.isBlank(lc.beanName()) ? "" : "$ioc->" + lc.beanName(), lc.defaultLocalizationKey());
            }
            MessageLoader msgLoader = null;
            msgLoader = !Strings.isBlank(lc.beanName()) ? config.getIoc().get(lc.type(), lc.beanName()) : (MessageLoader)((Object)Mirror.me(lc.type()).born(new Object[0]));
            Map<String, Map<String, Object>> msgss = msgLoader.load(lc.value());
            Mvcs.setMessageSet(msgss);
            if (!Strings.isBlank(lc.defaultLocalizationKey())) {
                Mvcs.setDefaultLocalizationKey(lc.defaultLocalizationKey());
            }
        } else if (log.isDebugEnabled()) {
            log.debug("@Localization not define");
        }
    }

    protected ViewMaker[] createViewMakers(Class<?> mainModule, Ioc ioc) throws Exception {
        Views vms = mainModule.getAnnotation(Views.class);
        ArrayList<Object> makers = new ArrayList<Object>();
        if (null != vms) {
            for (int i = 0; i < vms.value().length; ++i) {
                if (vms.value()[i].getAnnotation(IocBean.class) != null && ioc != null) {
                    makers.add(ioc.get(vms.value()[i]));
                    continue;
                }
                makers.add(Mirror.me(vms.value()[i]).born(new Object[0]));
            }
        } else if (ioc != null) {
            Object[] names = ioc.getNames();
            Arrays.sort(names);
            for (String name : ioc.getNames()) {
                if (name == null || !name.startsWith("$views")) continue;
                log.debug("add ViewMaker from Ioc by name=" + (String)name);
                makers.add(ioc.get(ViewMaker.class, name));
            }
        }
        makers.add(new DefaultViewMaker());
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (ViewMaker viewMaker : makers) {
                sb.append(viewMaker.getClass().getSimpleName()).append(",");
            }
            sb.setLength(sb.length() - 1);
            log.debugf("@Views(%s)", sb);
        }
        return makers.toArray(new ViewMaker[makers.size()]);
    }

    protected Ioc createIoc(NutConfig config, Class<?> mainModule) throws Exception {
        IocBy ib = mainModule.getAnnotation(IocBy.class);
        if (null != ib) {
            Ioc ioc;
            if (log.isDebugEnabled()) {
                log.debugf("@IocBy(type=%s, args=%s)", ib.type().getName(), Json.toJson(ib.args()));
            }
            if ((ioc = ((IocProvider)((Object)Mirror.me(ib.type()).born(new Object[0]))).create(config, ib.args())) instanceof Ioc2) {
                ((Ioc2)ioc).addValueProxyMaker(new ServletValueProxyMaker(config.getServletContext()));
            }
            Mvcs.setIoc(ioc);
            return ioc;
        }
        if (log.isInfoEnabled()) {
            log.info("!!!Your application without @IocBy supporting");
        }
        return null;
    }

    protected void createSessionProvider(NutConfig config, Class<?> mainModule) throws Exception {
        SessionBy sb = mainModule.getAnnotation(SessionBy.class);
        if (sb != null) {
            SessionProvider sp = null;
            sp = sb.args() != null && sb.args().length == 1 && sb.args()[0].startsWith("ioc:") ? config.getIoc().get(sb.value(), sb.args()[0].substring(4)) : (SessionProvider)((Object)Mirror.me(sb.value()).born(sb.args()));
            if (log.isInfoEnabled()) {
                log.info("SessionBy --> " + sp);
            }
            config.setSessionProvider(sp);
        }
    }

    @Override
    public void depose(NutConfig config) {
        if (log.isInfoEnabled()) {
            log.infof("Nutz.Mvc[%s] is deposing ...", config.getAppName());
        }
        Stopwatch sw = Stopwatch.begin();
        try {
            Setup setup = config.getAttributeAs(Setup.class, Setup.class.getName());
            if (null != setup) {
                setup.destroy(config);
            }
        }
        catch (Exception e) {
            throw new LoadingException(e);
        }
        finally {
            Ioc ioc;
            SessionProvider sp = config.getSessionProvider();
            if (sp != null) {
                sp.notifyStop();
            }
            if (null != (ioc = config.getIoc())) {
                ioc.depose();
            }
        }
        sw.stop();
        if (log.isInfoEnabled()) {
            log.infof("Nutz.Mvc[%s] is down in %sms", config.getAppName(), sw.getDuration());
        }
    }
}

