/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.upload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.nutz.filepool.FilePool;
import org.nutz.http.Http;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.upload.FieldMeta;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadException;
import org.nutz.mvc.upload.UploadInfo;
import org.nutz.mvc.upload.UploadInvalidFormatException;
import org.nutz.mvc.upload.UploadOutOfSizeException;
import org.nutz.mvc.upload.UploadStopException;
import org.nutz.mvc.upload.UploadUnsupportedFileNameException;
import org.nutz.mvc.upload.UploadUnsupportedFileTypeException;
import org.nutz.mvc.upload.Uploading;
import org.nutz.mvc.upload.UploadingContext;
import org.nutz.mvc.upload.Uploads;
import org.nutz.mvc.upload.util.BufferRing;
import org.nutz.mvc.upload.util.MarkMode;
import org.nutz.mvc.upload.util.RemountBytes;

public class FastUploading
implements Uploading {
    private static final Log log = Logs.get();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> parse(HttpServletRequest req, UploadingContext context) throws UploadException {
        BufferRing br;
        NutMap params;
        block34: {
            MarkMode mm;
            if (log.isDebugEnabled()) {
                log.debug("FastUpload : " + Mvcs.getRequestPath(req));
            }
            int bufferSize = context.getBufferSize();
            String charset = context.getCharset();
            FilePool tmps = context.getFilePool();
            int maxFileSize = context.getMaxFileSize();
            UploadInfo info = Uploads.createInfo(req);
            if (log.isDebugEnabled()) {
                log.debug("info created");
            }
            params = Uploads.createParamsMap(req);
            if (log.isDebugEnabled()) {
                log.debugf("Params map created - %s params", params.size());
            }
            String firstBoundary = "--" + Http.multipart.getBoundary(req.getContentType());
            RemountBytes firstBoundaryBytes = RemountBytes.create(firstBoundary);
            String itemEndl = "\r\n--" + Http.multipart.getBoundary(req.getContentType());
            RemountBytes itemEndlBytes = RemountBytes.create(itemEndl);
            RemountBytes nameEndlBytes = RemountBytes.create("\r\n\r\n");
            if (Http.multipart.getBoundary(req.getContentType()) == null) {
                if (log.isInfoEnabled()) {
                    log.info("boundary no found!!");
                }
                return params;
            }
            if (log.isDebugEnabled()) {
                log.debug("boundary: " + itemEndl);
            }
            try {
                ServletInputStream ins = req.getInputStream();
                br = new BufferRing((InputStream)ins, 3, bufferSize);
                info.current = br.load();
                mm = br.mark(firstBoundaryBytes);
                if (mm != MarkMode.FOUND) {
                    if (log.isWarnEnabled()) {
                        log.warnf("Fail to find the firstBoundary (%s) in stream, quit!", firstBoundary);
                    }
                    return params;
                }
                br.skipMark();
                if (log.isDebugEnabled()) {
                    log.debug("skip first boundary");
                }
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Reading...");
            }
            try {
                do {
                    FieldMeta meta;
                    block36: {
                        BufferedOutputStream ops;
                        File tmp;
                        block35: {
                            info.current = br.load();
                            mm = br.mark(nameEndlBytes);
                            String s = br.dumpAsString(charset);
                            if ("--".equals(s)) break block34;
                            if (MarkMode.STREAM_END == mm) {
                                break;
                            }
                            if (MarkMode.FOUND != mm) {
                                throw new UploadInvalidFormatException("Fail to found nameEnd!");
                            }
                            meta = new FieldMeta(s);
                            if (log.isDebugEnabled()) {
                                log.debugf("Upload File info: FilePath=[%s],fieldName=[%s]", meta.getFileLocalPath(), meta.getName());
                            }
                            if (!meta.isFile()) break block36;
                            if (log.isDebugEnabled()) {
                                log.debugf("Upload Info: name=%s,content_type=%s", meta.getFileLocalName(), meta.getContentType());
                            }
                            if (!context.isNameAccepted(meta.getFileLocalName())) {
                                throw new UploadUnsupportedFileNameException(meta);
                            }
                            if (!context.isContentTypeAccepted(meta.getContentType())) {
                                throw new UploadUnsupportedFileTypeException(meta);
                            }
                            if ("\"\"".equals(meta.getName()) || Strings.isBlank(meta.getFileLocalPath())) {
                                do {
                                    info.current = br.load();
                                    mm = br.mark(itemEndlBytes);
                                    FastUploading.assertStreamNotEnd(mm);
                                    br.skipMark();
                                } while (mm == MarkMode.NOT_FOUND);
                                continue;
                            }
                            tmp = tmps.createFile(meta.getFileExtension());
                            ops = null;
                            try {
                                ops = new BufferedOutputStream(new FileOutputStream(tmp), bufferSize * 2);
                                if (maxFileSize > 0) {
                                    long maxPos = info.current + (long)maxFileSize;
                                    do {
                                        info.current = br.load();
                                        mm = br.mark(itemEndlBytes);
                                        FastUploading.assertStreamNotEnd(mm);
                                        if (info.current > maxPos) {
                                            throw new UploadOutOfSizeException(meta);
                                        }
                                        br.dump(ops);
                                        if (!info.stop) continue;
                                        throw new UploadStopException(info);
                                    } while (mm == MarkMode.NOT_FOUND);
                                    break block35;
                                }
                                do {
                                    info.current = br.load();
                                    mm = br.mark(itemEndlBytes);
                                    FastUploading.assertStreamNotEnd(mm);
                                    br.dump(ops);
                                    if (!info.stop) continue;
                                    throw new UploadStopException(info);
                                } while (mm == MarkMode.NOT_FOUND);
                            }
                            catch (Throwable throwable) {
                                Streams.safeFlush(ops);
                                Streams.safeClose(ops);
                                throw throwable;
                            }
                        }
                        Streams.safeFlush(ops);
                        Streams.safeClose(ops);
                        if (context.isIgnoreNull() && tmp.length() == 0L) continue;
                        params.addv(meta.getName(), new TempFile(meta, tmp));
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    do {
                        info.current = br.load();
                        mm = br.mark(itemEndlBytes);
                        FastUploading.assertStreamNotEnd(mm);
                        sb.append(br.dumpAsString(charset));
                    } while (mm == MarkMode.NOT_FOUND);
                    params.addv(meta.getName(), sb.toString());
                    if (!log.isDebugEnabled()) continue;
                    log.debugf("Found a param, name=[%s] value=[%s]", meta.getName(), sb.toString());
                } while (mm != MarkMode.STREAM_END);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e, UploadException.class);
            }
            finally {
                br.close();
            }
        }
        if (log.isDebugEnabled()) {
            log.debugf("...Done %s bytes readed", br.readed());
        }
        return params;
    }

    private static void assertStreamNotEnd(MarkMode mm) throws UploadInvalidFormatException {
        if (mm == MarkMode.STREAM_END) {
            throw new UploadInvalidFormatException("Should not end stream");
        }
    }
}

