/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.net.ServerStopped;
import org.nutz.net.SocketClosed;
import org.nutz.net.SocketHandler;

public class TcpServer
implements Runnable {
    private static final Log log = Logs.get();
    private boolean stop;
    private int port;
    private ServerSocket listener;
    private SocketHandler handler;

    public TcpServer(int port, SocketHandler handler) {
        this.port = port;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listen(Socket socket) {
        block19: {
            SocketHandler handler = this.getHandler();
            try {
                handler.handle(socket);
            }
            catch (SocketClosed e) {
                if (socket.isClosed()) break block19;
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    throw Lang.wrapThrow(e2);
                }
            }
            catch (ServerStopped e) {
                this.stop = true;
            }
            catch (Throwable e) {
                handler.whenError(socket, e);
            }
            finally {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        throw Lang.wrapThrow(e);
                    }
                }
            }
        }
    }

    @Override
    public void run() {
        log.infof("start TcpServer [%s] @ %d", Thread.currentThread().getName(), this.port);
        try {
            this.listener = new ServerSocket(this.port);
        }
        catch (IOException e1) {
            throw Lang.wrapThrow(e1);
        }
        log.infof("TcpServer listen @ %d", this.port);
        while (!this.stop) {
            log.info("before accept ...");
            Socket socket = null;
            try {
                socket = this.listener.accept();
            }
            catch (IOException e) {
                log.fatalf("Fail to accept %s @ %d , System.exit!", Thread.currentThread().getName(), this.port);
                System.exit(0);
            }
            log.info("do listen ...");
            this.listen(socket);
            log.infof("done for listen [%s:%d], stop=%b", socket.getInetAddress().getHostName(), socket.getPort(), this.stop);
        }
        try {
            this.listener.close();
            log.infof("TcpServer shutdown @ %d", this.port);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public SocketHandler getHandler() {
        return this.handler;
    }

    public void setHandler(SocketHandler handler) {
        this.handler = handler;
    }

    public void stop() {
        this.stop = true;
    }
}

