/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import org.nutz.Nutz;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.util.ClassTools;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.FileVisitor;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.JarEntryInfo;
import org.nutz.resource.NutResource;
import org.nutz.resource.impl.ErrorResourceLocation;
import org.nutz.resource.impl.FileResource;
import org.nutz.resource.impl.ResourceLocation;

public class Scans {
    private static final String FLT_CLASS = "^.+[.]class$";
    private static final Log log = Logs.get();
    private static final Scans me = new Scans();
    private Set<ResourceLocation> locations = new HashSet<ResourceLocation>();

    public Scans init(ServletContext sc) {
        String classesPath = sc.getRealPath("/WEB-INF/classes/");
        if (classesPath != null) {
            this.locations.add(ResourceLocation.file(new File(classesPath)));
        } else if (log.isWarnEnabled()) {
            log.warn("/WEB-INF/classes/ NOT found?!");
        }
        Set jars = sc.getResourcePaths("/WEB-INF/lib/");
        if (jars != null) {
            for (String path : jars) {
                if (!path.toLowerCase().endsWith(".jar")) continue;
                this.locations.add(ResourceLocation.jar(sc.getRealPath(path)));
            }
        } else if (log.isWarnEnabled()) {
            log.warn("/WEB-INF/lib/ NOT found?!");
        }
        if (log.isDebugEnabled()) {
            log.debug("Locations for Scans:\n" + this.locations);
        }
        return this;
    }

    public List<NutResource> loadResource(String regex, String ... paths) {
        LinkedList<NutResource> list = new LinkedList<NutResource>();
        for (String path : paths) {
            list.addAll(this.scan(path, regex));
        }
        if (list.size() < 1 && paths.length > 0) {
            throw Lang.makeThrow(RuntimeException.class, "folder or file like '%s' no found in %s", regex, Castors.me().castToString(paths));
        }
        return new ArrayList<NutResource>(new LinkedHashSet(list));
    }

    public void registerLocation(Class<?> klass) {
        block7: {
            if (klass == null) {
                return;
            }
            try {
                this.registerLocation(klass.getProtectionDomain().getCodeSource().getLocation());
            }
            catch (Throwable e) {
                String classFile = klass.getName().replace('.', '/') + ".class";
                URL url = ClassTools.getClassLoader().getResource(classFile);
                if (url == null) break block7;
                String str = url.toString();
                try {
                    str = URLDecoder.decode(str, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    throw Lang.impossible();
                }
                str = str.substring(0, str.length() - classFile.length());
                try {
                    this.registerLocation(new URL(str));
                }
                catch (Throwable e2) {
                    if (!log.isInfoEnabled()) break block7;
                    log.info("Fail to registerLocation --> " + str, e);
                }
            }
        }
    }

    public void registerLocation(URL url) {
        if (url == null) {
            return;
        }
        this.locations.add(this.makeResourceLocation(url));
    }

    protected ResourceLocation makeResourceLocation(URL url) {
        block7: {
            try {
                String str = url.toString();
                if (str.endsWith(".jar")) {
                    return ResourceLocation.jar(str);
                }
                if (str.contains("jar!")) {
                    if (str.startsWith("jar:file:")) {
                        str = str.substring("jar:file:".length());
                    }
                    return ResourceLocation.jar(str.substring(0, str.lastIndexOf("jar!") + 3));
                }
                if (str.startsWith("file:")) {
                    return ResourceLocation.file(new File(url.getFile()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Unkown URL " + url);
                }
            }
            catch (Throwable e) {
                if (!log.isInfoEnabled()) break block7;
                log.info("Fail to registerLocation --> " + url, e);
            }
        }
        return ErrorResourceLocation.make(url);
    }

    public List<NutResource> scan(String src) {
        return this.scan(src, null);
    }

    public List<NutResource> scan(String src, String regex) {
        ArrayList<NutResource> list;
        block18: {
            Pattern pattern;
            list = new ArrayList<NutResource>();
            Pattern pattern2 = pattern = regex == null ? null : Pattern.compile(regex);
            if (src.startsWith("~/")) {
                src = Disks.normalize(src);
            }
            File srcFile = new File(src);
            if (src.startsWith("/") || srcFile.exists()) {
                if (srcFile.exists()) {
                    if (srcFile.isDirectory()) {
                        Disks.visitFile(srcFile, new ResourceFileVisitor(list, src), new ResourceFileFilter(pattern));
                    } else {
                        list.add(new FileResource(src, srcFile));
                    }
                } else {
                    this.scan(src.substring(1), regex);
                }
            }
            for (ResourceLocation location : this.locations) {
                location.scan(src, pattern, list);
            }
            if (list.isEmpty()) {
                try {
                    Enumeration<URL> enu = ClassTools.getClassLoader().getResources(src);
                    if (enu != null && enu.hasMoreElements()) {
                        while (enu.hasMoreElements()) {
                            try {
                                URL url = enu.nextElement();
                                ResourceLocation loc = this.makeResourceLocation(url);
                                if (url.toString().contains("jar!")) {
                                    loc.scan(src, pattern, list);
                                    continue;
                                }
                                loc.scan("", pattern, list);
                            }
                            catch (Throwable e) {
                                if (!log.isTraceEnabled()) continue;
                                log.trace("", e);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block18;
                    log.debug("Fail to run deep scan!", e);
                }
            }
        }
        ArrayList<NutResource> tmp = new ArrayList<NutResource>();
        for (NutResource r : list) {
            int index = tmp.indexOf(r);
            if (index > -1) {
                log.infof("same resource [%s] will be override", r.getName());
                tmp.set(index, r);
                continue;
            }
            tmp.add(r);
        }
        if (log.isDebugEnabled()) {
            log.debugf("Found %s resource by src( %s ) , regex( %s )", list.size(), src, regex);
        }
        return list;
    }

    public List<Class<?>> scanPackage(Class<?> classZ) {
        return this.scanPackage(classZ.getPackage().getName(), FLT_CLASS);
    }

    public List<Class<?>> scanPackage(Class<?> classZ, String regex) {
        return this.scanPackage(classZ.getPackage().getName(), regex);
    }

    public List<Class<?>> scanPackage(String pkg) {
        return this.scanPackage(pkg, FLT_CLASS);
    }

    public List<Class<?>> scanPackage(String pkg, String regex) {
        String packagePath = pkg.replace('.', '/').replace('\\', '/');
        if (!packagePath.endsWith("/")) {
            packagePath = packagePath + "/";
        }
        return Scans.rs2class(pkg, this.scan(packagePath, regex));
    }

    public static boolean isInJar(File file) {
        return Scans.isInJar(file.getAbsolutePath());
    }

    public static boolean isInJar(String filePath) {
        return filePath.contains(".jar!");
    }

    public static NutResource makeJarNutResource(File file) {
        return Scans.makeJarNutResource(file.getAbsolutePath());
    }

    public static NutResource makeJarNutResource(String filePath) {
        JarEntryInfo jeInfo = new JarEntryInfo(filePath);
        try {
            ZipInputStream zis = Scans.makeZipInputStream(jeInfo.getJarPath());
            ZipEntry ens = null;
            while (null != (ens = zis.getNextEntry())) {
                if (ens.isDirectory() || !jeInfo.getEntryName().equals(ens.getName())) continue;
                return Scans.makeJarNutResource(jeInfo.getJarPath(), ens.getName(), "");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static NutResource makeJarNutResource(final String jarPath, final String entryName, String base) throws IOException {
        NutResource nutResource = new NutResource(){

            @Override
            public InputStream getInputStream() throws IOException {
                ZipInputStream zis = Scans.makeZipInputStream(jarPath);
                ZipEntry ens = null;
                while (null != (ens = zis.getNextEntry())) {
                    if (!ens.getName().equals(entryName)) continue;
                    return zis;
                }
                throw Lang.impossible();
            }

            @Override
            public int hashCode() {
                return (jarPath + ":" + entryName).hashCode();
            }
        };
        if (entryName.equals(base)) {
            nutResource.setName(entryName);
        } else {
            nutResource.setName(entryName.substring(base.length()));
        }
        return nutResource;
    }

    public static ZipInputStream makeZipInputStream(String jarPath) throws MalformedURLException, IOException {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(jarPath));
        }
        catch (IOException e) {
            zis = new ZipInputStream(new URL(jarPath).openStream());
        }
        return zis;
    }

    public static final Scans me() {
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> rs2class(String pkg, List<NutResource> list) {
        HashSet re = new HashSet(list.size());
        if (!list.isEmpty()) {
            for (NutResource nr : list) {
                if (!nr.getName().endsWith(".class") || nr.getName().endsWith("package-info.class")) continue;
                String className = pkg + "." + nr.getName().substring(0, nr.getName().length() - 6).replaceAll("[/\\\\]", ".");
                try {
                    Class<?> klass = Lang.loadClass(className);
                    re.add(klass);
                }
                catch (Throwable e) {
                    InputStream in = null;
                    try {
                        in = nr.getInputStream();
                        className = ClassTools.getClassName(in);
                        if (className == null) {
                            if (!log.isInfoEnabled()) continue;
                            log.infof("Resource can't map to Class, Resource %s", nr);
                            continue;
                        }
                        Class<?> klass = Lang.loadClass(className);
                        re.add(klass);
                    }
                    catch (ClassNotFoundException e2) {
                        if (!log.isInfoEnabled()) continue;
                        log.infof("Resource can't map to Class, Resource %s", nr, e2);
                    }
                    catch (IOException e3) {
                        if (!log.isInfoEnabled()) continue;
                        log.infof("Resource can't map to Class, Resource %s", nr, e3);
                    }
                    finally {
                        Streams.safeClose(in);
                    }
                }
            }
        }
        return new ArrayList(re);
    }

    private Scans() {
        if (Lang.isAndroid) {
            if (log.isInfoEnabled()) {
                log.info("Running in Android , so nothing I can scan , just disable myself");
            }
            return;
        }
        this.locations.add(ResourceLocation.file(new File(".")));
        this.registerLocation(Nutz.class);
        String[] referPaths = new String[]{"META-INF/MANIFEST.MF", "log4j.properties", ".nutz.resource.mark"};
        ClassLoader cloader = ClassTools.getClassLoader();
        for (String referPath : referPaths) {
            try {
                Enumeration<URL> urls = cloader.getResources(referPath);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    String url_str = url.toString();
                    url = url.toString().contains("jar!") ? new URL(url_str.substring(0, url_str.length() - referPath.length() - 2)) : new URL(url_str.substring(0, url_str.length() - referPath.length()));
                    this.registerLocation(url);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            String[] paths;
            String classpath = System.getProperties().getProperty("java.class.path");
            for (String pathZ : paths = classpath.split(System.getProperties().getProperty("path.separator"))) {
                if (pathZ.endsWith(".jar")) {
                    this.locations.add(ResourceLocation.jar(pathZ));
                    continue;
                }
                this.locations.add(ResourceLocation.file(new File(pathZ)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("Locations for Scans:\n" + this.locations);
        }
    }

    public static class ResourceFileVisitor
    implements FileVisitor {
        String base;
        List<NutResource> list;

        @Override
        public void visit(File f) {
            this.list.add(new FileResource(this.base, f));
        }

        public ResourceFileVisitor(List<NutResource> list, String base) {
            this.list = list;
            this.base = base;
        }
    }

    public static class ResourceFileFilter
    implements FileFilter {
        private Pattern pattern;

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                String fnm = f.getName().toLowerCase();
                return !".svn".equals(fnm) && !".cvs".equals(fnm) && !".git".equals(fnm);
            }
            if (f.isHidden()) {
                return false;
            }
            return this.pattern == null || this.pattern.matcher(f.getName()).find();
        }

        public ResourceFileFilter(Pattern pattern) {
            this.pattern = pattern;
        }
    }
}

