/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.nutz.resource.NutResource;
import org.nutz.resource.impl.ErrorResourceLocation;
import org.nutz.resource.impl.FileSystemResourceLocation;
import org.nutz.resource.impl.JarResourceLocation;

public abstract class ResourceLocation {
    public abstract void scan(String var1, Pattern var2, List<NutResource> var3);

    public static ResourceLocation file(File root) {
        try {
            if (!root.exists()) {
                return ErrorResourceLocation.make(root);
            }
            return new FileSystemResourceLocation(root.getAbsoluteFile().getCanonicalFile());
        }
        catch (Exception e) {
            return ErrorResourceLocation.make(root);
        }
    }

    public static ResourceLocation jar(String jarPath) {
        try {
            return new JarResourceLocation(jarPath);
        }
        catch (Exception e) {
            return ErrorResourceLocation.make(jarPath);
        }
    }
}

