/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.trans;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Atom;
import org.nutz.trans.Molecule;
import org.nutz.trans.NutTransaction;
import org.nutz.trans.Transaction;

public abstract class Trans {
    private static final Log log = Logs.get();
    private static Class<? extends Transaction> implClass;
    static ThreadLocal<Transaction> trans;
    static ThreadLocal<Integer> count;
    public static boolean DEBUG;

    public static Transaction get() {
        return trans.get();
    }

    public static void setup(Class<? extends Transaction> classOfTransaction) {
        implClass = classOfTransaction;
    }

    static void _begain(int level) throws Exception {
        Transaction tn = trans.get();
        if (null == tn) {
            tn = null == implClass ? new NutTransaction() : (Transaction)((Object)Mirror.me(implClass).born(new Object[0]));
            tn.setLevel(level);
            trans.set(tn);
            count.set(0);
            if (DEBUG) {
                log.debugf("Start New Transaction id=%d, level=%d", tn.getId(), level);
            }
        } else if (DEBUG) {
            log.debugf("Attach Transaction    id=%d, level=%d", tn.getId(), level);
        }
        int tCount = count.get() + 1;
        count.set(tCount);
    }

    static void _commit() throws Exception {
        count.set(count.get() - 1);
        Transaction tn = trans.get();
        if (count.get() == 0) {
            if (DEBUG) {
                log.debug("Transaction Commit id=" + tn.getId());
            }
            tn.commit();
        } else if (DEBUG) {
            log.debugf("Transaction delay Commit id=%d, count=%d", tn.getId(), count.get());
        }
    }

    static void _depose() {
        if (count.get() == 0) {
            try {
                if (DEBUG) {
                    log.debugf("Transaction depose id=%d, count=%s", trans.get().getId(), count.get());
                }
                trans.get().close();
            }
            catch (Throwable e) {
                throw Lang.wrapThrow(e);
            }
            finally {
                trans.set(null);
            }
        }
    }

    static void _rollback(Integer num) {
        count.set(num);
        if (count.get() == 0) {
            if (DEBUG) {
                log.debugf("Transaction rollback id=%s, count=%s", trans.get().getId(), num);
            }
            trans.get().rollback();
        } else if (DEBUG) {
            log.debugf("Transaction delay rollback id=%s, count=%s", trans.get().getId(), num);
        }
    }

    public static boolean isTransactionNone() {
        Transaction t = trans.get();
        return null == t || t.getLevel() == 0;
    }

    public static void exec(Atom ... atoms) {
        Trans.exec(2, atoms);
    }

    public static void exec(int level, Atom ... atoms) {
        if (null == atoms) {
            return;
        }
        int num = count.get() == null ? 0 : count.get();
        try {
            Trans._begain(level);
            for (Atom atom : atoms) {
                atom.run();
            }
            Trans._commit();
        }
        catch (Throwable e) {
            Trans._rollback(num);
            throw Lang.wrapThrow(e);
        }
        finally {
            Trans._depose();
        }
    }

    public static <T> T exec(Molecule<T> molecule) {
        Trans.exec(new Atom[]{molecule});
        return molecule.getObj();
    }

    public static void begin() throws Exception {
        Trans._begain(2);
    }

    public static void begin(int level) throws Exception {
        Trans._begain(level);
    }

    public static void commit() throws Exception {
        Trans._commit();
    }

    public static void rollback() throws Exception {
        Integer c = count.get();
        if (c == null) {
            c = 0;
        } else if (c > 0) {
            Integer n = c;
            Integer n2 = c = Integer.valueOf(c - 1);
        }
        Trans._rollback(c);
    }

    public static void close() throws Exception {
        Trans._depose();
    }

    public static Connection getConnectionAuto(DataSource ds) throws SQLException {
        if (Trans.get() == null) {
            return ds.getConnection();
        }
        return Trans.get().getConnection(ds);
    }

    public static void closeConnectionAuto(Connection conn) {
        if (Trans.get() == null && null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw Lang.wrapThrow(e);
            }
        }
    }

    static {
        trans = new ThreadLocal();
        count = new ThreadLocal();
        DEBUG = false;
    }
}

