/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import java.lang.reflect.Array;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static String toString(double[] arr, String fmt) {
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append("[");
        int i = arr.length - 1;
        for (int j = 0; j <= i; ++j) {
            localStringBuffer.append(String.format(fmt, arr[j]));
            if (j >= i) continue;
            localStringBuffer.append(", ");
        }
        localStringBuffer.append("]");
        return localStringBuffer.toString();
    }

    public static String toString(float[] arr, String fmt) {
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append("[");
        int i = arr.length - 1;
        for (int j = 0; j <= i; ++j) {
            localStringBuffer.append(String.format(fmt, Float.valueOf(arr[j])));
            if (j >= i) continue;
            localStringBuffer.append(", ");
        }
        localStringBuffer.append("]");
        return localStringBuffer.toString();
    }

    public static String toString(int[] arr, String fmt) {
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append("[");
        int i = arr.length - 1;
        for (int j = 0; j <= i; ++j) {
            localStringBuffer.append(String.format(fmt, arr[j]));
            if (j >= i) continue;
            localStringBuffer.append(", ");
        }
        localStringBuffer.append("]");
        return localStringBuffer.toString();
    }

    public static String toString(long[] arr, String fmt) {
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append("[");
        int i = arr.length - 1;
        for (int j = 0; j <= i; ++j) {
            localStringBuffer.append(String.format(fmt, arr[j]));
            if (j >= i) continue;
            localStringBuffer.append(", ");
        }
        localStringBuffer.append("]");
        return localStringBuffer.toString();
    }

    public static String toString(byte[] arr, String fmt) {
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append("[");
        int i = arr.length - 1;
        for (int j = 0; j <= i; ++j) {
            localStringBuffer.append(String.format(fmt, arr[j]));
            if (j >= i) continue;
            localStringBuffer.append(", ");
        }
        localStringBuffer.append("]");
        return localStringBuffer.toString();
    }

    public static String toString(short[] arr, String fmt) {
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append("[");
        int i = arr.length - 1;
        for (int j = 0; j <= i; ++j) {
            localStringBuffer.append(String.format(fmt, arr[j]));
            if (j >= i) continue;
            localStringBuffer.append(", ");
        }
        localStringBuffer.append("]");
        return localStringBuffer.toString();
    }

    public static double maxValue(double[] arr) {
        if (arr.length < 0) {
            return 0.0;
        }
        double max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] > max)) continue;
            max = arr[i];
        }
        return max;
    }

    public static float maxValue(float[] arr) {
        if (arr.length < 0) {
            return 0.0f;
        }
        float max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] > max)) continue;
            max = arr[i];
        }
        return max;
    }

    public static int maxValue(int[] arr) {
        if (arr.length < 0) {
            return 0;
        }
        int max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
        }
        return max;
    }

    public static long maxValue(long[] arr) {
        if (arr.length < 0) {
            return 0L;
        }
        long max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
        }
        return max;
    }

    public static byte maxValue(byte[] arr) {
        if (arr.length < 0) {
            return 0;
        }
        byte max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
        }
        return max;
    }

    public static short maxValue(short[] arr) {
        if (arr.length < 0) {
            return 0;
        }
        short max = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
        }
        return max;
    }

    public static double minValue(double[] arr) {
        if (arr.length < 0) {
            return 0.0;
        }
        double min = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] < min)) continue;
            min = arr[i];
        }
        return min;
    }

    public static float minValue(float[] arr) {
        if (arr.length < 0) {
            return 0.0f;
        }
        float min = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] < min)) continue;
            min = arr[i];
        }
        return min;
    }

    public static int minValue(int[] arr) {
        if (arr.length < 0) {
            return 0;
        }
        int min = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
        }
        return min;
    }

    public static long minValue(long[] arr) {
        if (arr.length < 0) {
            return 0L;
        }
        long min = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
        }
        return min;
    }

    public static byte minValue(byte[] arr) {
        if (arr.length < 0) {
            return 0;
        }
        byte min = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
        }
        return min;
    }

    public static short minValue(short[] arr) {
        if (arr.length < 0) {
            return 0;
        }
        short min = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
        }
        return min;
    }

    public static int maxIndex(double[] arr) {
        double max = Double.MIN_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] > max)) continue;
            max = arr[i];
            index = i;
        }
        return index;
    }

    public static int maxIndex(float[] arr) {
        float max = Float.MIN_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] > max)) continue;
            max = arr[i];
            index = i;
        }
        return index;
    }

    public static int maxIndex(int[] arr) {
        int max = Integer.MIN_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
            index = i;
        }
        return index;
    }

    public static int maxIndex(long[] arr) {
        long max = Long.MIN_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
            index = i;
        }
        return index;
    }

    public static int maxIndex(byte[] arr) {
        byte max = -128;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
            index = i;
        }
        return index;
    }

    public static int maxIndex(short[] arr) {
        short max = Short.MIN_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= max) continue;
            max = arr[i];
            index = i;
        }
        return index;
    }

    public static int minIndex(double[] arr) {
        double min = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] < min)) continue;
            min = arr[i];
            index = i;
        }
        return index;
    }

    public static int minIndex(float[] arr) {
        float min = Float.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] < min)) continue;
            min = arr[i];
            index = i;
        }
        return index;
    }

    public static int minIndex(int[] arr) {
        int min = Integer.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
            index = i;
        }
        return index;
    }

    public static int minIndex(long[] arr) {
        long min = Long.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
            index = i;
        }
        return index;
    }

    public static int minIndex(byte[] arr) {
        byte min = 127;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
            index = i;
        }
        return index;
    }

    public static int minIndex(short[] arr) {
        short min = Short.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] >= min) continue;
            min = arr[i];
            index = i;
        }
        return index;
    }

    public static double[][] sum(double[][] a1, double[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.sum(a1[j], a2[j]);
        }
        return a1;
    }

    public static double[] sum(double[] a1, double[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] + a2[j];
        }
        return a1;
    }

    public static float[][] sum(float[][] a1, float[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.sum(a1[j], a2[j]);
        }
        return a1;
    }

    public static float[] sum(float[] a1, float[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] + a2[j];
        }
        return a1;
    }

    public static int[][] sum(int[][] a1, int[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.sum(a1[j], a2[j]);
        }
        return a1;
    }

    public static int[] sum(int[] a1, int[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] + a2[j];
        }
        return a1;
    }

    public static long[][] sum(long[][] a1, long[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.sum(a1[j], a2[j]);
        }
        return a1;
    }

    public static long[] sum(long[] a1, long[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] + a2[j];
        }
        return a1;
    }

    public static byte[][] sum(byte[][] a1, byte[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.sum(a1[j], a2[j]);
        }
        return a1;
    }

    public static byte[] sum(byte[] a1, byte[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = (byte)(a1[n] + a2[j]);
        }
        return a1;
    }

    public static short[][] sum(short[][] a1, short[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.sum(a1[j], a2[j]);
        }
        return a1;
    }

    public static short[] sum(short[] a1, short[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = (short)(a1[n] + a2[j]);
        }
        return a1;
    }

    public static double[][] subtract(double[][] a1, double[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.subtract(a1[j], a2[j]);
        }
        return a1;
    }

    public static double[] subtract(double[] a1, double[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] - a2[j];
        }
        return a1;
    }

    public static float[][] subtract(float[][] a1, float[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.subtract(a1[j], a2[j]);
        }
        return a1;
    }

    public static float[] subtract(float[] a1, float[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] - a2[j];
        }
        return a1;
    }

    public static int[][] subtract(int[][] a1, int[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.subtract(a1[j], a2[j]);
        }
        return a1;
    }

    public static int[] subtract(int[] a1, int[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] - a2[j];
        }
        return a1;
    }

    public static long[][] subtract(long[][] a1, long[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.subtract(a1[j], a2[j]);
        }
        return a1;
    }

    public static long[] subtract(long[] a1, long[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] - a2[j];
        }
        return a1;
    }

    public static byte[][] subtract(byte[][] a1, byte[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.subtract(a1[j], a2[j]);
        }
        return a1;
    }

    public static byte[] subtract(byte[] a1, byte[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = (byte)(a1[n] - a2[j]);
        }
        return a1;
    }

    public static short[][] subtract(short[][] a1, short[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.subtract(a1[j], a2[j]);
        }
        return a1;
    }

    public static short[] subtract(short[] a1, short[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = (short)(a1[n] - a2[j]);
        }
        return a1;
    }

    public static double[] subtract(double[] a1, double s) {
        return ArrayUtils.add(a1, -s);
    }

    public static float[] subtract(float[] a1, float s) {
        return ArrayUtils.add(a1, -s);
    }

    public static int[] subtract(int[] a1, int s) {
        return ArrayUtils.add(a1, -s);
    }

    public static long[] subtract(long[] a1, long s) {
        return ArrayUtils.add(a1, -s);
    }

    public static byte[] subtract(byte[] a1, byte s) {
        return ArrayUtils.add(a1, -s);
    }

    public static short[] subtract(short[] a1, short s) {
        return ArrayUtils.add(a1, -s);
    }

    public static double[] add(double[] ds, double x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] + x;
        }
        return ds;
    }

    public static float[] add(float[] ds, float x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] + x;
        }
        return ds;
    }

    public static int[] add(int[] ds, int x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] + x;
        }
        return ds;
    }

    public static long[] add(long[] ds, long x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] + x;
        }
        return ds;
    }

    public static byte[] add(byte[] ds, byte x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = (byte)(ds[n] + x);
        }
        return ds;
    }

    public static short[] add(short[] ds, short x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = (short)(ds[n] + x);
        }
        return ds;
    }

    public static double[] multiply(double[] ds, double x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] * x;
        }
        return ds;
    }

    public static double[][] multiply(double[][] ds, double x) {
        for (int i = 0; i < ds.length; ++i) {
            ArrayUtils.multiply(ds[i], x);
        }
        return ds;
    }

    public static float[] multiply(float[] ds, float x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] * x;
        }
        return ds;
    }

    public static float[][] multiply(float[][] ds, float x) {
        for (int i = 0; i < ds.length; ++i) {
            ArrayUtils.multiply(ds[i], x);
        }
        return ds;
    }

    public static int[] multiply(int[] ds, int x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] * x;
        }
        return ds;
    }

    public static int[][] multiply(int[][] ds, int x) {
        for (int i = 0; i < ds.length; ++i) {
            ArrayUtils.multiply(ds[i], x);
        }
        return ds;
    }

    public static long[] multiply(long[] ds, long x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] * x;
        }
        return ds;
    }

    public static long[][] multiply(long[][] ds, long x) {
        for (int i = 0; i < ds.length; ++i) {
            ArrayUtils.multiply(ds[i], x);
        }
        return ds;
    }

    public static byte[] multiply(byte[] ds, byte x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = (byte)(ds[n] * x);
        }
        return ds;
    }

    public static byte[][] multiply(byte[][] ds, byte x) {
        for (int i = 0; i < ds.length; ++i) {
            ArrayUtils.multiply(ds[i], x);
        }
        return ds;
    }

    public static short[] multiply(short[] ds, short x) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = (short)(ds[n] * x);
        }
        return ds;
    }

    public static short[][] multiply(short[][] ds, short x) {
        for (int i = 0; i < ds.length; ++i) {
            ArrayUtils.multiply(ds[i], x);
        }
        return ds;
    }

    public static double[] multiply(double[] a1, double[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] * a2[j];
        }
        return a1;
    }

    public static double[][] multiply(double[][] a1, double[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.multiply(a1[j], a2[j]);
        }
        return a1;
    }

    public static float[] multiply(float[] a1, float[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] * a2[j];
        }
        return a1;
    }

    public static float[][] multiply(float[][] a1, float[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.multiply(a1[j], a2[j]);
        }
        return a1;
    }

    public static int[] multiply(int[] a1, int[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] * a2[j];
        }
        return a1;
    }

    public static int[][] multiply(int[][] a1, int[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.multiply(a1[j], a2[j]);
        }
        return a1;
    }

    public static long[] multiply(long[] a1, long[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = a1[n] * a2[j];
        }
        return a1;
    }

    public static long[][] multiply(long[][] a1, long[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.multiply(a1[j], a2[j]);
        }
        return a1;
    }

    public static byte[] multiply(byte[] a1, byte[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = (byte)(a1[n] * a2[j]);
        }
        return a1;
    }

    public static byte[][] multiply(byte[][] a1, byte[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.multiply(a1[j], a2[j]);
        }
        return a1;
    }

    public static short[] multiply(short[] a1, short[] a2) {
        for (int j = 0; j < a1.length; ++j) {
            int n = j;
            a1[n] = (short)(a1[n] * a2[j]);
        }
        return a1;
    }

    public static short[][] multiply(short[][] a1, short[][] a2) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.multiply(a1[j], a2[j]);
        }
        return a1;
    }

    public static double[] divide(double[] fs, double x) {
        int i = 0;
        while (i < fs.length) {
            int n = i++;
            fs[n] = fs[n] / x;
        }
        return fs;
    }

    public static float[] divide(float[] fs, float x) {
        int i = 0;
        while (i < fs.length) {
            int n = i++;
            fs[n] = fs[n] / x;
        }
        return fs;
    }

    public static int[] divide(int[] fs, int x) {
        int i = 0;
        while (i < fs.length) {
            int n = i++;
            fs[n] = fs[n] / x;
        }
        return fs;
    }

    public static long[] divide(long[] fs, long x) {
        int i = 0;
        while (i < fs.length) {
            int n = i++;
            fs[n] = fs[n] / x;
        }
        return fs;
    }

    public static byte[] divide(byte[] fs, byte x) {
        int i = 0;
        while (i < fs.length) {
            int n = i++;
            fs[n] = (byte)(fs[n] / x);
        }
        return fs;
    }

    public static short[] divide(short[] fs, short x) {
        int i = 0;
        while (i < fs.length) {
            int n = i++;
            fs[n] = (short)(fs[n] / x);
        }
        return fs;
    }

    public static float[] normalise(float[] array) {
        float sumsq = 0.0f;
        for (int i = 0; i < array.length; ++i) {
            sumsq += array[i] * array[i];
        }
        if (sumsq == 0.0f) {
            return array;
        }
        float weight = 1.0f / (float)Math.sqrt(sumsq);
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * weight;
        }
        return array;
    }

    public static double[] normalise(double[] array) {
        double sumsq = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sumsq += array[i] * array[i];
        }
        if (sumsq == 0.0) {
            return array;
        }
        double weight = 1.0 / Math.sqrt(sumsq);
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * weight;
        }
        return array;
    }

    public static double[] reverse(double[] ds) {
        int len = ds.length;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            double tmp = ds[i];
            ds[i] = ds[len - i - 1];
            ds[len - i - 1] = tmp;
        }
        return ds;
    }

    public static float[] reverse(float[] ds) {
        int len = ds.length;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            float tmp = ds[i];
            ds[i] = ds[len - i - 1];
            ds[len - i - 1] = tmp;
        }
        return ds;
    }

    public static int[] reverse(int[] ds) {
        int len = ds.length;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            int tmp = ds[i];
            ds[i] = ds[len - i - 1];
            ds[len - i - 1] = tmp;
        }
        return ds;
    }

    public static long[] reverse(long[] ds) {
        int len = ds.length;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            long tmp = ds[i];
            ds[i] = ds[len - i - 1];
            ds[len - i - 1] = tmp;
        }
        return ds;
    }

    public static byte[] reverse(byte[] ds) {
        int len = ds.length;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            byte tmp = ds[i];
            ds[i] = ds[len - i - 1];
            ds[len - i - 1] = tmp;
        }
        return ds;
    }

    public static short[] reverse(short[] ds) {
        int len = ds.length;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            short tmp = ds[i];
            ds[i] = ds[len - i - 1];
            ds[len - i - 1] = tmp;
        }
        return ds;
    }

    public static double[] convertToDouble(double[] array) {
        double[] darr = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = array[i];
        }
        return darr;
    }

    public static double[][] convertToDouble(double[][] array) {
        double[][] darr = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToDouble(array[i]);
        }
        return darr;
    }

    public static double[] convertToDouble(float[] array) {
        double[] darr = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = array[i];
        }
        return darr;
    }

    public static double[][] convertToDouble(float[][] array) {
        double[][] darr = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToDouble(array[i]);
        }
        return darr;
    }

    public static double[] convertToDouble(int[] array) {
        double[] darr = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = array[i];
        }
        return darr;
    }

    public static double[][] convertToDouble(int[][] array) {
        double[][] darr = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToDouble(array[i]);
        }
        return darr;
    }

    public static double[] convertToDouble(long[] array) {
        double[] darr = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = array[i];
        }
        return darr;
    }

    public static double[][] convertToDouble(long[][] array) {
        double[][] darr = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToDouble(array[i]);
        }
        return darr;
    }

    public static double[] convertToDouble(byte[] array) {
        double[] darr = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = array[i];
        }
        return darr;
    }

    public static double[][] convertToDouble(byte[][] array) {
        double[][] darr = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToDouble(array[i]);
        }
        return darr;
    }

    public static double[] convertToDouble(short[] array) {
        double[] darr = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = array[i];
        }
        return darr;
    }

    public static double[][] convertToDouble(short[][] array) {
        double[][] darr = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToDouble(array[i]);
        }
        return darr;
    }

    public static float[] convertToFloat(double[] array) {
        float[] farr = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            farr[i] = (float)array[i];
        }
        return farr;
    }

    public static float[][] convertToFloat(double[][] array) {
        float[][] darr = new float[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToFloat(array[i]);
        }
        return darr;
    }

    public static float[] convertToFloat(float[] array) {
        float[] farr = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            farr[i] = array[i];
        }
        return farr;
    }

    public static float[][] convertToFloat(float[][] array) {
        float[][] darr = new float[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToFloat(array[i]);
        }
        return darr;
    }

    public static float[] convertToFloat(int[] array) {
        float[] farr = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            farr[i] = array[i];
        }
        return farr;
    }

    public static float[][] convertToFloat(int[][] array) {
        float[][] darr = new float[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToFloat(array[i]);
        }
        return darr;
    }

    public static float[] convertToFloat(long[] array) {
        float[] farr = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            farr[i] = array[i];
        }
        return farr;
    }

    public static float[][] convertToFloat(long[][] array) {
        float[][] darr = new float[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToFloat(array[i]);
        }
        return darr;
    }

    public static float[] convertToFloat(byte[] array) {
        float[] farr = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            farr[i] = array[i];
        }
        return farr;
    }

    public static float[][] convertToFloat(byte[][] array) {
        float[][] darr = new float[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToFloat(array[i]);
        }
        return darr;
    }

    public static float[] convertToFloat(short[] array) {
        float[] farr = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            farr[i] = array[i];
        }
        return farr;
    }

    public static float[][] convertToFloat(short[][] array) {
        float[][] darr = new float[array.length][];
        for (int i = 0; i < array.length; ++i) {
            darr[i] = ArrayUtils.convertToFloat(array[i]);
        }
        return darr;
    }

    public static <T> T firstNonNull(T[] array) {
        if (array == null) {
            return null;
        }
        for (T obj : array) {
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T[] concatenate(T[] ... arrays) {
        int length = 0;
        Class<?> type = null;
        for (T[] arr : arrays) {
            if (arr == null) continue;
            length += arr.length;
            if (type != null) continue;
            type = arr.getClass().getComponentType();
        }
        Object[] concat = (Object[])Array.newInstance(type, length);
        int current = 0;
        for (T[] arr : arrays) {
            System.arraycopy(arr, 0, concat, current, arr.length);
            current += arr.length;
        }
        return concat;
    }

    public static double[] concatenate(double[] ... arrays) {
        int length = 0;
        for (double[] arr : arrays) {
            length += arr == null ? 0 : arr.length;
        }
        double[] concat = new double[length];
        int current = 0;
        for (double[] arr : arrays) {
            System.arraycopy(arr, 0, concat, current, arr.length);
            current += arr.length;
        }
        return concat;
    }

    public static float[] concatenate(float[] ... arrays) {
        int length = 0;
        for (float[] arr : arrays) {
            length += arr == null ? 0 : arr.length;
        }
        float[] concat = new float[length];
        int current = 0;
        for (float[] arr : arrays) {
            System.arraycopy(arr, 0, concat, current, arr.length);
            current += arr.length;
        }
        return concat;
    }

    public static int[] concatenate(int[] ... arrays) {
        int length = 0;
        for (int[] arr : arrays) {
            length += arr == null ? 0 : arr.length;
        }
        int[] concat = new int[length];
        int current = 0;
        for (int[] arr : arrays) {
            System.arraycopy(arr, 0, concat, current, arr.length);
            current += arr.length;
        }
        return concat;
    }

    public static long[] concatenate(long[] ... arrays) {
        int length = 0;
        for (long[] arr : arrays) {
            length += arr == null ? 0 : arr.length;
        }
        long[] concat = new long[length];
        int current = 0;
        for (long[] arr : arrays) {
            System.arraycopy(arr, 0, concat, current, arr.length);
            current += arr.length;
        }
        return concat;
    }

    public static byte[] concatenate(byte[] ... arrays) {
        int length = 0;
        for (byte[] arr : arrays) {
            length += arr == null ? 0 : arr.length;
        }
        byte[] concat = new byte[length];
        int current = 0;
        for (byte[] arr : arrays) {
            System.arraycopy(arr, 0, concat, current, arr.length);
            current += arr.length;
        }
        return concat;
    }

    public static short[] concatenate(short[] ... arrays) {
        int length = 0;
        for (short[] arr : arrays) {
            length += arr == null ? 0 : arr.length;
        }
        short[] concat = new short[length];
        int current = 0;
        for (short[] arr : arrays) {
            System.arraycopy(arr, 0, concat, current, arr.length);
            current += arr.length;
        }
        return concat;
    }

    public static double[][] concatenate(double[][] ... arrays) {
        double[][] concat = new double[arrays[0].length][];
        for (int i = 0; i < concat.length; ++i) {
            double[][] row = new double[arrays.length][];
            for (int j = 0; j < row.length; ++j) {
                row[j] = arrays[j][i];
            }
            concat[i] = ArrayUtils.concatenate((double[][])row);
        }
        return concat;
    }

    public static float[][] concatenate(float[][] ... arrays) {
        float[][] concat = new float[arrays[0].length][];
        for (int i = 0; i < concat.length; ++i) {
            float[][] row = new float[arrays.length][];
            for (int j = 0; j < row.length; ++j) {
                row[j] = arrays[j][i];
            }
            concat[i] = ArrayUtils.concatenate((float[][])row);
        }
        return concat;
    }

    public static int[][] concatenate(int[][] ... arrays) {
        int[][] concat = new int[arrays[0].length][];
        for (int i = 0; i < concat.length; ++i) {
            int[][] row = new int[arrays.length][];
            for (int j = 0; j < row.length; ++j) {
                row[j] = arrays[j][i];
            }
            concat[i] = ArrayUtils.concatenate((int[][])row);
        }
        return concat;
    }

    public static long[][] concatenate(long[][] ... arrays) {
        long[][] concat = new long[arrays[0].length][];
        for (int i = 0; i < concat.length; ++i) {
            long[][] row = new long[arrays.length][];
            for (int j = 0; j < row.length; ++j) {
                row[j] = arrays[j][i];
            }
            concat[i] = ArrayUtils.concatenate((long[][])row);
        }
        return concat;
    }

    public static byte[][] concatenate(byte[][] ... arrays) {
        byte[][] concat = new byte[arrays[0].length][];
        for (int i = 0; i < concat.length; ++i) {
            byte[][] row = new byte[arrays.length][];
            for (int j = 0; j < row.length; ++j) {
                row[j] = arrays[j][i];
            }
            concat[i] = ArrayUtils.concatenate((byte[][])row);
        }
        return concat;
    }

    public static short[][] concatenate(short[][] ... arrays) {
        short[][] concat = new short[arrays[0].length][];
        for (int i = 0; i < concat.length; ++i) {
            short[][] row = new short[arrays.length][];
            for (int j = 0; j < row.length; ++j) {
                row[j] = arrays[j][i];
            }
            concat[i] = ArrayUtils.concatenate((short[][])row);
        }
        return concat;
    }

    public static double sumValues(double[] vector) {
        double sum = 0.0;
        for (double v : vector) {
            sum += v;
        }
        return sum;
    }

    public static float sumValues(float[] vector) {
        float sum = 0.0f;
        for (float v : vector) {
            sum += v;
        }
        return sum;
    }

    public static long sumValues(int[] vector) {
        long sum = 0L;
        for (int v : vector) {
            sum += (long)v;
        }
        return sum;
    }

    public static long sumValues(long[] vector) {
        long sum = 0L;
        for (long v : vector) {
            sum += v;
        }
        return sum;
    }

    public static int sumValues(byte[] vector) {
        int sum = 0;
        for (byte v : vector) {
            sum += v;
        }
        return sum;
    }

    public static int sumValues(short[] vector) {
        int sum = 0;
        for (short v : vector) {
            sum += v;
        }
        return sum;
    }

    public static double sumValues(double[][] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                sum += array[i][j];
            }
        }
        return sum;
    }

    public static float sumValues(float[][] array) {
        float sum = 0.0f;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                sum += array[i][j];
            }
        }
        return sum;
    }

    public static long sumValues(int[][] array) {
        long sum = 0L;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                sum += (long)array[i][j];
            }
        }
        return sum;
    }

    public static long sumValues(long[][] array) {
        long sum = 0L;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                sum += array[i][j];
            }
        }
        return sum;
    }

    public static int sumValues(byte[][] array) {
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                sum += array[i][j];
            }
        }
        return sum;
    }

    public static int sumValues(short[][] array) {
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                sum += array[i][j];
            }
        }
        return sum;
    }

    public static double sumValuesSquared(double[] vector) {
        double sum = 0.0;
        for (double v : vector) {
            sum += v * v;
        }
        return sum;
    }

    public static float sumValuesSquared(float[] vector) {
        float sum = 0.0f;
        for (float v : vector) {
            sum += v * v;
        }
        return sum;
    }

    public static long sumValuesSquared(int[] vector) {
        long sum = 0L;
        for (int v : vector) {
            sum += (long)(v * v);
        }
        return sum;
    }

    public static long sumValuesSquared(long[] vector) {
        long sum = 0L;
        for (long v : vector) {
            sum += v * v;
        }
        return sum;
    }

    public static int sumValuesSquared(byte[] vector) {
        int sum = 0;
        for (byte v : vector) {
            sum += v * v;
        }
        return sum;
    }

    public static int sumValuesSquared(short[] vector) {
        int sum = 0;
        for (short v : vector) {
            sum += v * v;
        }
        return sum;
    }

    public static double[] cumulativeSum(double[] vector) {
        double[] sum = new double[vector.length];
        if (vector.length == 0) {
            return sum;
        }
        sum[0] = vector[0];
        for (int i = 1; i < vector.length; ++i) {
            sum[i] = vector[i] + sum[i - 1];
        }
        return sum;
    }

    public static float[] cumulativeSum(float[] vector) {
        float[] sum = new float[vector.length];
        if (vector.length == 0) {
            return sum;
        }
        sum[0] = vector[0];
        for (int i = 1; i < vector.length; ++i) {
            sum[i] = vector[i] + sum[i - 1];
        }
        return sum;
    }

    public static long[] cumulativeSum(int[] vector) {
        long[] sum = new long[vector.length];
        if (vector.length == 0) {
            return sum;
        }
        sum[0] = vector[0];
        for (int i = 1; i < vector.length; ++i) {
            sum[i] = (long)vector[i] + sum[i - 1];
        }
        return sum;
    }

    public static long[] cumulativeSum(long[] vector) {
        long[] sum = new long[vector.length];
        if (vector.length == 0) {
            return sum;
        }
        sum[0] = vector[0];
        for (int i = 1; i < vector.length; ++i) {
            sum[i] = vector[i] + sum[i - 1];
        }
        return sum;
    }

    public static int[] cumulativeSum(byte[] vector) {
        int[] sum = new int[vector.length];
        if (vector.length == 0) {
            return sum;
        }
        sum[0] = vector[0];
        for (int i = 1; i < vector.length; ++i) {
            sum[i] = vector[i] + sum[i - 1];
        }
        return sum;
    }

    public static int[] cumulativeSum(short[] vector) {
        int[] sum = new int[vector.length];
        if (vector.length == 0) {
            return sum;
        }
        sum[0] = vector[0];
        for (int i = 1; i < vector.length; ++i) {
            sum[i] = vector[i] + sum[i - 1];
        }
        return sum;
    }

    public static double[] rowSum(double[][] array) {
        double[] sum = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                int n = i;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static float[] rowSum(float[][] array) {
        float[] sum = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                int n = i;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static long[] rowSum(int[][] array) {
        long[] sum = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                int n = i;
                sum[n] = sum[n] + (long)array[i][j];
            }
        }
        return sum;
    }

    public static long[] rowSum(long[][] array) {
        long[] sum = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                int n = i;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static int[] rowSum(byte[][] array) {
        int[] sum = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                int n = i;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static int[] rowSum(short[][] array) {
        int[] sum = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                int n = i;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static double[] colSum(double[][] array) {
        double[] sum = new double[array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                int n = j;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static float[] colSum(float[][] array) {
        float[] sum = new float[array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                int n = j;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static long[] colSum(int[][] array) {
        long[] sum = new long[array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                int n = j;
                sum[n] = sum[n] + (long)array[i][j];
            }
        }
        return sum;
    }

    public static long[] colSum(long[][] array) {
        long[] sum = new long[array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                int n = j;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static int[] colSum(byte[][] array) {
        int[] sum = new int[array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                int n = j;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static int[] colSum(short[][] array) {
        int[] sum = new int[array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                int n = j;
                sum[n] = sum[n] + array[i][j];
            }
        }
        return sum;
    }

    public static int[] range(int start, int length) {
        int[] range = new int[length - start + 1];
        for (int i = start; i <= length; ++i) {
            range[i - start] = i;
        }
        return range;
    }

    public static int[] search(double[] a, double value) {
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ++count;
        }
        int[] ret = new int[count];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ret[j++] = i;
        }
        return ret;
    }

    public static int[] search(float[] a, float value) {
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ++count;
        }
        int[] ret = new int[count];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ret[j++] = i;
        }
        return ret;
    }

    public static int[] search(int[] a, int value) {
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ++count;
        }
        int[] ret = new int[count];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ret[j++] = i;
        }
        return ret;
    }

    public static int[] search(long[] a, long value) {
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ++count;
        }
        int[] ret = new int[count];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ret[j++] = i;
        }
        return ret;
    }

    public static int[] search(byte[] a, byte value) {
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ++count;
        }
        int[] ret = new int[count];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ret[j++] = i;
        }
        return ret;
    }

    public static int[] search(short[] a, short value) {
        int count = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ++count;
        }
        int[] ret = new int[count];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != value) continue;
            ret[j++] = i;
        }
        return ret;
    }

    public static double[] reshape(double[][] a) {
        double[] ret = new double[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static float[] reshape(float[][] a) {
        float[] ret = new float[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static int[] reshape(int[][] a) {
        int[] ret = new int[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static long[] reshape(long[][] a) {
        long[] ret = new long[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static byte[] reshape(byte[][] a) {
        byte[] ret = new byte[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static short[] reshape(short[][] a) {
        short[] ret = new short[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static double[] reshapeDouble(double[][] a) {
        double[] ret = new double[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static double[] reshapeDouble(float[][] a) {
        double[] ret = new double[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static double[] reshapeDouble(int[][] a) {
        double[] ret = new double[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static double[] reshapeDouble(long[][] a) {
        double[] ret = new double[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static double[] reshapeDouble(byte[][] a) {
        double[] ret = new double[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static double[] reshapeDouble(short[][] a) {
        double[] ret = new double[a.length * a[0].length];
        int i = 0;
        for (int r = 0; r < a.length; ++r) {
            int c = 0;
            while (c < a[0].length) {
                ret[i] = a[r][c];
                ++c;
                ++i;
            }
        }
        return ret;
    }

    public static double[][] reshape(double[] a, double[][] out) {
        int i = 0;
        for (int r = 0; r < out.length; ++r) {
            int c = 0;
            while (c < out[0].length) {
                out[r][c] = a[i];
                ++c;
                ++i;
            }
        }
        return out;
    }

    public static double[][] reshape(double[] a, int width, int height) {
        double[][] ret = new double[height][width];
        return ArrayUtils.reshape(a, ret);
    }

    public static float[][] reshape(float[] a, float[][] out) {
        int i = 0;
        for (int r = 0; r < out.length; ++r) {
            int c = 0;
            while (c < out[0].length) {
                out[r][c] = a[i];
                ++c;
                ++i;
            }
        }
        return out;
    }

    public static float[][] reshape(float[] a, int width, int height) {
        float[][] ret = new float[height][width];
        return ArrayUtils.reshape(a, ret);
    }

    public static int[][] reshape(int[] a, int[][] out) {
        int i = 0;
        for (int r = 0; r < out.length; ++r) {
            int c = 0;
            while (c < out[0].length) {
                out[r][c] = a[i];
                ++c;
                ++i;
            }
        }
        return out;
    }

    public static int[][] reshape(int[] a, int width, int height) {
        int[][] ret = new int[height][width];
        return ArrayUtils.reshape(a, ret);
    }

    public static long[][] reshape(long[] a, long[][] out) {
        int i = 0;
        for (int r = 0; r < out.length; ++r) {
            int c = 0;
            while (c < out[0].length) {
                out[r][c] = a[i];
                ++c;
                ++i;
            }
        }
        return out;
    }

    public static long[][] reshape(long[] a, int width, int height) {
        long[][] ret = new long[height][width];
        return ArrayUtils.reshape(a, ret);
    }

    public static byte[][] reshape(byte[] a, byte[][] out) {
        int i = 0;
        for (int r = 0; r < out.length; ++r) {
            int c = 0;
            while (c < out[0].length) {
                out[r][c] = a[i];
                ++c;
                ++i;
            }
        }
        return out;
    }

    public static byte[][] reshape(byte[] a, int width, int height) {
        byte[][] ret = new byte[height][width];
        return ArrayUtils.reshape(a, ret);
    }

    public static short[][] reshape(short[] a, short[][] out) {
        int i = 0;
        for (int r = 0; r < out.length; ++r) {
            int c = 0;
            while (c < out[0].length) {
                out[r][c] = a[i];
                ++c;
                ++i;
            }
        }
        return out;
    }

    public static short[][] reshape(short[] a, int width, int height) {
        short[][] ret = new short[height][width];
        return ArrayUtils.reshape(a, ret);
    }

    public static float[][] reshapeFloat(double[] a, float[][] out) {
        int i = 0;
        for (int r = 0; r < out.length; ++r) {
            int c = 0;
            while (c < out[0].length) {
                out[r][c] = (float)a[i];
                ++c;
                ++i;
            }
        }
        return out;
    }

    public static float[][] reshapeFloat(double[] a, int width, int height) {
        float[][] ret = new float[height][width];
        return ArrayUtils.reshapeFloat(a, ret);
    }

    public static void parallelQuicksortDescending(double[] main, double[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(double[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(double[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(double[] main, float[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(double[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(double[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(double[] main, int[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(double[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(double[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(double[] main, long[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(double[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(double[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(double[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(double[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(double[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(double[] main, short[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(double[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(double[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(float[] main, double[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(float[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(float[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(float[] main, float[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(float[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(float[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(float[] main, int[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(float[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(float[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(float[] main, long[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(float[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(float[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(float[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(float[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(float[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(float[] main, short[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(float[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(float[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(int[] main, double[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(int[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(int[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(int[] main, float[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(int[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(int[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(int[] main, int[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(int[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(int[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(int[] main, long[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(int[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(int[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(int[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(int[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(int[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(int[] main, short[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(int[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(int[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(long[] main, double[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(long[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(long[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(long[] main, float[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(long[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(long[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(long[] main, int[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(long[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(long[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(long[] main, long[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(long[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(long[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(long[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(long[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(long[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(long[] main, short[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(long[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(long[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(byte[] main, double[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(byte[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(byte[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(byte[] main, float[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(byte[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(byte[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(byte[] main, int[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(byte[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(byte[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(byte[] main, long[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(byte[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(byte[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(byte[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(byte[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(byte[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(byte[] main, short[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(byte[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(byte[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(short[] main, double[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(short[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(short[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(short[] main, float[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(short[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(short[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(short[] main, int[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(short[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(short[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(short[] main, long[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(short[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(short[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(short[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(short[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(short[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortDescending(short[] main, short[] indices) {
        ArrayUtils.parallelQuicksortDescending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortDescending(short[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionDesc(main, indices, left, right);
        ArrayUtils.parallelQuicksortDescending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortDescending(main, indices, i + 1, right);
    }

    private static int partitionDesc(short[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] > a[right]) {
                continue;
            }
            while (a[right] > a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(double[] main, double[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(double[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(double[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(double[] main, float[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(double[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(double[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(double[] main, int[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(double[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(double[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(double[] main, long[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(double[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(double[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(double[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(double[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(double[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(double[] main, short[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(double[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(double[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(float[] main, double[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(float[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(float[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(float[] main, float[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(float[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(float[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(float[] main, int[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(float[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(float[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(float[] main, long[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(float[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(float[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(float[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(float[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(float[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(float[] main, short[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(float[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(float[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(int[] main, double[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(int[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(int[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(int[] main, float[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(int[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(int[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(int[] main, int[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(int[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(int[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(int[] main, long[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(int[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(int[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(int[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(int[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(int[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(int[] main, short[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(int[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(int[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(long[] main, double[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(long[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(long[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(long[] main, float[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(long[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(long[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(long[] main, int[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(long[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(long[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(long[] main, long[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(long[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(long[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(long[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(long[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(long[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(long[] main, short[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(long[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(long[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(byte[] main, double[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(byte[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(byte[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(byte[] main, float[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(byte[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(byte[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(byte[] main, int[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(byte[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(byte[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(byte[] main, long[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(byte[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(byte[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(byte[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(byte[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(byte[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(byte[] main, short[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(byte[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(byte[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(short[] main, double[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(short[] main, double[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(short[] a, double[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(short[] main, float[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(short[] main, float[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(short[] a, float[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(short[] main, int[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(short[] main, int[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(short[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(short[] main, long[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(short[] main, long[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(short[] a, long[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(short[] main, byte[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(short[] main, byte[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(short[] a, byte[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    public static void parallelQuicksortAscending(short[] main, short[] indices) {
        ArrayUtils.parallelQuicksortAscending(main, indices, 0, indices.length - 1);
    }

    public static void parallelQuicksortAscending(short[] main, short[] indices, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partitionAsc(main, indices, left, right);
        ArrayUtils.parallelQuicksortAscending(main, indices, left, i - 1);
        ArrayUtils.parallelQuicksortAscending(main, indices, i + 1, right);
    }

    private static int partitionAsc(short[] a, short[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[++i] < a[right]) {
                continue;
            }
            while (a[right] < a[--j] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(a, index, i, j);
        }
        ArrayUtils.exch(a, index, i, right);
        return i;
    }

    private static void exch(double[] a, double[] index, int i, int j) {
        double swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        double b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(double[] a, float[] index, int i, int j) {
        double swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        float b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(double[] a, int[] index, int i, int j) {
        double swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(double[] a, long[] index, int i, int j) {
        double swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        long b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(double[] a, byte[] index, int i, int j) {
        double swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        byte b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(double[] a, short[] index, int i, int j) {
        double swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        short b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(float[] a, double[] index, int i, int j) {
        float swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        double b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(float[] a, float[] index, int i, int j) {
        float swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        float b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(float[] a, int[] index, int i, int j) {
        float swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(float[] a, long[] index, int i, int j) {
        float swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        long b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(float[] a, byte[] index, int i, int j) {
        float swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        byte b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(float[] a, short[] index, int i, int j) {
        float swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        short b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(int[] a, double[] index, int i, int j) {
        int swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        double b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(int[] a, float[] index, int i, int j) {
        int swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        float b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(int[] a, int[] index, int i, int j) {
        int swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(int[] a, long[] index, int i, int j) {
        int swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        long b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(int[] a, byte[] index, int i, int j) {
        int swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        byte b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(int[] a, short[] index, int i, int j) {
        int swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        short b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(long[] a, double[] index, int i, int j) {
        long swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        double b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(long[] a, float[] index, int i, int j) {
        long swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        float b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(long[] a, int[] index, int i, int j) {
        long swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(long[] a, long[] index, int i, int j) {
        long swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        long b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(long[] a, byte[] index, int i, int j) {
        long swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        byte b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(long[] a, short[] index, int i, int j) {
        long swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        short b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(byte[] a, double[] index, int i, int j) {
        byte swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        double b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(byte[] a, float[] index, int i, int j) {
        byte swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        float b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(byte[] a, int[] index, int i, int j) {
        byte swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(byte[] a, long[] index, int i, int j) {
        byte swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        long b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(byte[] a, byte[] index, int i, int j) {
        byte swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        byte b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(byte[] a, short[] index, int i, int j) {
        byte swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        short b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(short[] a, double[] index, int i, int j) {
        short swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        double b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(short[] a, float[] index, int i, int j) {
        short swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        float b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(short[] a, int[] index, int i, int j) {
        short swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(short[] a, long[] index, int i, int j) {
        short swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        long b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(short[] a, byte[] index, int i, int j) {
        short swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        byte b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    private static void exch(short[] a, short[] index, int i, int j) {
        short swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        short b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static int[] indexSort(double[] arr) {
        int[] index = new int[arr.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ArrayUtils.quicksort(arr, index, 0, index.length - 1);
        return index;
    }

    private static void quicksort(double[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partition(a, index, left, right);
        ArrayUtils.quicksort(a, index, left, i - 1);
        ArrayUtils.quicksort(a, index, i + 1, right);
    }

    private static int partition(double[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(index, i, j);
        }
        ArrayUtils.exch(index, i, right);
        return i;
    }

    public static int[] indexSort(float[] arr) {
        int[] index = new int[arr.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ArrayUtils.quicksort(arr, index, 0, index.length - 1);
        return index;
    }

    private static void quicksort(float[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partition(a, index, left, right);
        ArrayUtils.quicksort(a, index, left, i - 1);
        ArrayUtils.quicksort(a, index, i + 1, right);
    }

    private static int partition(float[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(index, i, j);
        }
        ArrayUtils.exch(index, i, right);
        return i;
    }

    public static int[] indexSort(int[] arr) {
        int[] index = new int[arr.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ArrayUtils.quicksort(arr, index, 0, index.length - 1);
        return index;
    }

    private static void quicksort(int[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partition(a, index, left, right);
        ArrayUtils.quicksort(a, index, left, i - 1);
        ArrayUtils.quicksort(a, index, i + 1, right);
    }

    private static int partition(int[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(index, i, j);
        }
        ArrayUtils.exch(index, i, right);
        return i;
    }

    public static int[] indexSort(long[] arr) {
        int[] index = new int[arr.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ArrayUtils.quicksort(arr, index, 0, index.length - 1);
        return index;
    }

    private static void quicksort(long[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partition(a, index, left, right);
        ArrayUtils.quicksort(a, index, left, i - 1);
        ArrayUtils.quicksort(a, index, i + 1, right);
    }

    private static int partition(long[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(index, i, j);
        }
        ArrayUtils.exch(index, i, right);
        return i;
    }

    public static int[] indexSort(byte[] arr) {
        int[] index = new int[arr.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ArrayUtils.quicksort(arr, index, 0, index.length - 1);
        return index;
    }

    private static void quicksort(byte[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partition(a, index, left, right);
        ArrayUtils.quicksort(a, index, left, i - 1);
        ArrayUtils.quicksort(a, index, i + 1, right);
    }

    private static int partition(byte[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(index, i, j);
        }
        ArrayUtils.exch(index, i, right);
        return i;
    }

    public static int[] indexSort(short[] arr) {
        int[] index = new int[arr.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ArrayUtils.quicksort(arr, index, 0, index.length - 1);
        return index;
    }

    private static void quicksort(short[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = ArrayUtils.partition(a, index, left, right);
        ArrayUtils.quicksort(a, index, left, i - 1);
        ArrayUtils.quicksort(a, index, i + 1, right);
    }

    private static int partition(short[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (a[index[++i]] < a[index[right]]) {
                continue;
            }
            while (a[index[right]] < a[index[--j]] && j != left) {
            }
            if (i >= j) break;
            ArrayUtils.exch(index, i, j);
        }
        ArrayUtils.exch(index, i, right);
        return i;
    }

    static void exch(int[] index, int i, int j) {
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static double[] normaliseMax(double[] array) {
        return ArrayUtils.normaliseMax(array, 1.0);
    }

    public static double[] normaliseMax(double[] array, double max) {
        double m = ArrayUtils.maxValue(array);
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i] / m * max;
        }
        return array;
    }

    public static String toString(String[] s, String glue) {
        int k = s.length;
        if (k == 0) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append(s[0]);
        for (int x = 1; x < k; ++x) {
            out.append(glue).append(s[x]);
        }
        return out.toString();
    }

    public static double[][] fill(double[][] a1, double i) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.fill(a1[j], i);
        }
        return a1;
    }

    public static double[] fill(double[] a1, double i, int s, int l) {
        for (int j = s; j < s + l; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static double[] fill(double[] a1, double i) {
        for (int j = 0; j < a1.length; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static float[][] fill(float[][] a1, float i) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.fill(a1[j], i);
        }
        return a1;
    }

    public static float[] fill(float[] a1, float i, int s, int l) {
        for (int j = s; j < s + l; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static float[] fill(float[] a1, float i) {
        for (int j = 0; j < a1.length; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static int[][] fill(int[][] a1, int i) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.fill(a1[j], i);
        }
        return a1;
    }

    public static int[] fill(int[] a1, int i, int s, int l) {
        for (int j = s; j < s + l; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static int[] fill(int[] a1, int i) {
        for (int j = 0; j < a1.length; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static long[][] fill(long[][] a1, long i) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.fill(a1[j], i);
        }
        return a1;
    }

    public static long[] fill(long[] a1, long i, int s, int l) {
        for (int j = s; j < s + l; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static long[] fill(long[] a1, long i) {
        for (int j = 0; j < a1.length; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static byte[][] fill(byte[][] a1, byte i) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.fill(a1[j], i);
        }
        return a1;
    }

    public static byte[] fill(byte[] a1, byte i, int s, int l) {
        for (int j = s; j < s + l; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static byte[] fill(byte[] a1, byte i) {
        for (int j = 0; j < a1.length; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static short[][] fill(short[][] a1, short i) {
        for (int j = 0; j < a1.length; ++j) {
            ArrayUtils.fill(a1[j], i);
        }
        return a1;
    }

    public static short[] fill(short[] a1, short i, int s, int l) {
        for (int j = s; j < s + l; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static short[] fill(short[] a1, short i) {
        for (int j = 0; j < a1.length; ++j) {
            a1[j] = i;
        }
        return a1;
    }

    public static int[] fill(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static double[] truncate(double[] array, int index) {
        double[] d = new double[index];
        System.arraycopy(array, 0, d, 0, index);
        return d;
    }

    public static double[][] truncate(double[][] array, int index) {
        double[][] d = new double[Math.min(array.length, index)][index];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ArrayUtils.truncate(array[i], index);
        }
        return d;
    }

    public static float[] truncate(float[] array, int index) {
        float[] d = new float[index];
        System.arraycopy(array, 0, d, 0, index);
        return d;
    }

    public static float[][] truncate(float[][] array, int index) {
        float[][] d = new float[Math.min(array.length, index)][index];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ArrayUtils.truncate(array[i], index);
        }
        return d;
    }

    public static int[] truncate(int[] array, int index) {
        int[] d = new int[index];
        System.arraycopy(array, 0, d, 0, index);
        return d;
    }

    public static int[][] truncate(int[][] array, int index) {
        int[][] d = new int[Math.min(array.length, index)][index];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ArrayUtils.truncate(array[i], index);
        }
        return d;
    }

    public static long[] truncate(long[] array, int index) {
        long[] d = new long[index];
        System.arraycopy(array, 0, d, 0, index);
        return d;
    }

    public static long[][] truncate(long[][] array, int index) {
        long[][] d = new long[Math.min(array.length, index)][index];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ArrayUtils.truncate(array[i], index);
        }
        return d;
    }

    public static byte[] truncate(byte[] array, int index) {
        byte[] d = new byte[index];
        System.arraycopy(array, 0, d, 0, index);
        return d;
    }

    public static byte[][] truncate(byte[][] array, int index) {
        byte[][] d = new byte[Math.min(array.length, index)][index];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ArrayUtils.truncate(array[i], index);
        }
        return d;
    }

    public static short[] truncate(short[] array, int index) {
        short[] d = new short[index];
        System.arraycopy(array, 0, d, 0, index);
        return d;
    }

    public static short[][] truncate(short[][] array, int index) {
        short[][] d = new short[Math.min(array.length, index)][index];
        for (int i = 0; i < d.length; ++i) {
            d[i] = ArrayUtils.truncate(array[i], index);
        }
        return d;
    }

    public static double quickSelect(double[] arr, int n) {
        return ArrayUtils.quickSelect(arr, n, 0, arr.length - 1);
    }

    public static double quickSelect(double[] arr, int n, int low, int high) {
        double tmp = 0.0;
        int median = (low + --high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (arr[low] > arr[high]) {
                    tmp = arr[low];
                    arr[low] = arr[high];
                    arr[high] = tmp;
                }
                return arr[median];
            }
            int middle = (low + high) / 2;
            if (arr[middle] > arr[high]) {
                tmp = arr[middle];
                arr[middle] = arr[high];
                arr[high] = tmp;
            }
            if (arr[low] > arr[high]) {
                tmp = arr[low];
                arr[low] = arr[high];
                arr[high] = tmp;
            }
            if (arr[middle] > arr[low]) {
                tmp = arr[low];
                arr[low] = arr[middle];
                arr[middle] = tmp;
            }
            tmp = arr[middle];
            arr[middle] = arr[low + 1];
            arr[low + 1] = tmp;
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (arr[low] > arr[++ll]) {
                    continue;
                }
                while (arr[--hh] > arr[low]) {
                }
                if (hh < ll) break;
                tmp = arr[ll];
                arr[ll] = arr[hh];
                arr[hh] = tmp;
            }
            tmp = arr[low];
            arr[low] = arr[hh];
            arr[hh] = tmp;
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return arr[median];
    }

    public static float quickSelect(float[] arr, int n) {
        return ArrayUtils.quickSelect(arr, n, 0, arr.length - 1);
    }

    public static float quickSelect(float[] arr, int n, int low, int high) {
        float tmp = 0.0f;
        int median = (low + --high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (arr[low] > arr[high]) {
                    tmp = arr[low];
                    arr[low] = arr[high];
                    arr[high] = tmp;
                }
                return arr[median];
            }
            int middle = (low + high) / 2;
            if (arr[middle] > arr[high]) {
                tmp = arr[middle];
                arr[middle] = arr[high];
                arr[high] = tmp;
            }
            if (arr[low] > arr[high]) {
                tmp = arr[low];
                arr[low] = arr[high];
                arr[high] = tmp;
            }
            if (arr[middle] > arr[low]) {
                tmp = arr[low];
                arr[low] = arr[middle];
                arr[middle] = tmp;
            }
            tmp = arr[middle];
            arr[middle] = arr[low + 1];
            arr[low + 1] = tmp;
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (arr[low] > arr[++ll]) {
                    continue;
                }
                while (arr[--hh] > arr[low]) {
                }
                if (hh < ll) break;
                tmp = arr[ll];
                arr[ll] = arr[hh];
                arr[hh] = tmp;
            }
            tmp = arr[low];
            arr[low] = arr[hh];
            arr[hh] = tmp;
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return arr[median];
    }

    public static int quickSelect(int[] arr, int n) {
        return ArrayUtils.quickSelect(arr, n, 0, arr.length - 1);
    }

    public static int quickSelect(int[] arr, int n, int low, int high) {
        int tmp = 0;
        int median = (low + --high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (arr[low] > arr[high]) {
                    tmp = arr[low];
                    arr[low] = arr[high];
                    arr[high] = tmp;
                }
                return arr[median];
            }
            int middle = (low + high) / 2;
            if (arr[middle] > arr[high]) {
                tmp = arr[middle];
                arr[middle] = arr[high];
                arr[high] = tmp;
            }
            if (arr[low] > arr[high]) {
                tmp = arr[low];
                arr[low] = arr[high];
                arr[high] = tmp;
            }
            if (arr[middle] > arr[low]) {
                tmp = arr[low];
                arr[low] = arr[middle];
                arr[middle] = tmp;
            }
            tmp = arr[middle];
            arr[middle] = arr[low + 1];
            arr[low + 1] = tmp;
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (arr[low] > arr[++ll]) {
                    continue;
                }
                while (arr[--hh] > arr[low]) {
                }
                if (hh < ll) break;
                tmp = arr[ll];
                arr[ll] = arr[hh];
                arr[hh] = tmp;
            }
            tmp = arr[low];
            arr[low] = arr[hh];
            arr[hh] = tmp;
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return arr[median];
    }

    public static long quickSelect(long[] arr, int n) {
        return ArrayUtils.quickSelect(arr, n, 0, arr.length - 1);
    }

    public static long quickSelect(long[] arr, int n, int low, int high) {
        long tmp = 0L;
        int median = (low + --high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (arr[low] > arr[high]) {
                    tmp = arr[low];
                    arr[low] = arr[high];
                    arr[high] = tmp;
                }
                return arr[median];
            }
            int middle = (low + high) / 2;
            if (arr[middle] > arr[high]) {
                tmp = arr[middle];
                arr[middle] = arr[high];
                arr[high] = tmp;
            }
            if (arr[low] > arr[high]) {
                tmp = arr[low];
                arr[low] = arr[high];
                arr[high] = tmp;
            }
            if (arr[middle] > arr[low]) {
                tmp = arr[low];
                arr[low] = arr[middle];
                arr[middle] = tmp;
            }
            tmp = arr[middle];
            arr[middle] = arr[low + 1];
            arr[low + 1] = tmp;
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (arr[low] > arr[++ll]) {
                    continue;
                }
                while (arr[--hh] > arr[low]) {
                }
                if (hh < ll) break;
                tmp = arr[ll];
                arr[ll] = arr[hh];
                arr[hh] = tmp;
            }
            tmp = arr[low];
            arr[low] = arr[hh];
            arr[hh] = tmp;
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return arr[median];
    }

    public static byte quickSelect(byte[] arr, int n) {
        return ArrayUtils.quickSelect(arr, n, 0, arr.length - 1);
    }

    public static byte quickSelect(byte[] arr, int n, int low, int high) {
        byte tmp = 0;
        int median = (low + --high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (arr[low] > arr[high]) {
                    tmp = arr[low];
                    arr[low] = arr[high];
                    arr[high] = tmp;
                }
                return arr[median];
            }
            int middle = (low + high) / 2;
            if (arr[middle] > arr[high]) {
                tmp = arr[middle];
                arr[middle] = arr[high];
                arr[high] = tmp;
            }
            if (arr[low] > arr[high]) {
                tmp = arr[low];
                arr[low] = arr[high];
                arr[high] = tmp;
            }
            if (arr[middle] > arr[low]) {
                tmp = arr[low];
                arr[low] = arr[middle];
                arr[middle] = tmp;
            }
            tmp = arr[middle];
            arr[middle] = arr[low + 1];
            arr[low + 1] = tmp;
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (arr[low] > arr[++ll]) {
                    continue;
                }
                while (arr[--hh] > arr[low]) {
                }
                if (hh < ll) break;
                tmp = arr[ll];
                arr[ll] = arr[hh];
                arr[hh] = tmp;
            }
            tmp = arr[low];
            arr[low] = arr[hh];
            arr[hh] = tmp;
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return arr[median];
    }

    public static short quickSelect(short[] arr, int n) {
        return ArrayUtils.quickSelect(arr, n, 0, arr.length - 1);
    }

    public static short quickSelect(short[] arr, int n, int low, int high) {
        short tmp = 0;
        int median = (low + --high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (arr[low] > arr[high]) {
                    tmp = arr[low];
                    arr[low] = arr[high];
                    arr[high] = tmp;
                }
                return arr[median];
            }
            int middle = (low + high) / 2;
            if (arr[middle] > arr[high]) {
                tmp = arr[middle];
                arr[middle] = arr[high];
                arr[high] = tmp;
            }
            if (arr[low] > arr[high]) {
                tmp = arr[low];
                arr[low] = arr[high];
                arr[high] = tmp;
            }
            if (arr[middle] > arr[low]) {
                tmp = arr[low];
                arr[low] = arr[middle];
                arr[middle] = tmp;
            }
            tmp = arr[middle];
            arr[middle] = arr[low + 1];
            arr[low + 1] = tmp;
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (arr[low] > arr[++ll]) {
                    continue;
                }
                while (arr[--hh] > arr[low]) {
                }
                if (hh < ll) break;
                tmp = arr[ll];
                arr[ll] = arr[hh];
                arr[hh] = tmp;
            }
            tmp = arr[low];
            arr[low] = arr[hh];
            arr[hh] = tmp;
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return arr[median];
    }

    public double[] convert(Double[] array) {
        double[] out = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public Double[] convert(double[] array) {
        Double[] out = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public float[] convert(Float[] array) {
        float[] out = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i].floatValue();
        }
        return out;
    }

    public Float[] convert(float[] array) {
        Float[] out = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = Float.valueOf(array[i]);
        }
        return out;
    }

    public int[] convert(Integer[] array) {
        int[] out = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public Integer[] convert(int[] array) {
        Integer[] out = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public long[] convert(Long[] array) {
        long[] out = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public Long[] convert(long[] array) {
        Long[] out = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public byte[] convert(Byte[] array) {
        byte[] out = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public Byte[] convert(byte[] array) {
        Byte[] out = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public short[] convert(Short[] array) {
        short[] out = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public Short[] convert(short[] array) {
        Short[] out = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            out[i] = array[i];
        }
        return out;
    }

    public static double pnorm(double[] array, int p) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += Math.pow(Math.abs(array[i]), p);
        }
        return Math.pow(sum, 1.0 / (double)p);
    }

    public static double pnorm(float[] array, int p) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += Math.pow(Math.abs(array[i]), p);
        }
        return Math.pow(sum, 1.0 / (double)p);
    }

    public static double pnorm(int[] array, int p) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += Math.pow(Math.abs(array[i]), p);
        }
        return Math.pow(sum, 1.0 / (double)p);
    }

    public static double pnorm(long[] array, int p) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += Math.pow(Math.abs(array[i]), p);
        }
        return Math.pow(sum, 1.0 / (double)p);
    }

    public static double pnorm(byte[] array, int p) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += Math.pow(Math.abs(array[i]), p);
        }
        return Math.pow(sum, 1.0 / (double)p);
    }

    public static double pnorm(short[] array, int p) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += Math.pow(Math.abs(array[i]), p);
        }
        return Math.pow(sum, 1.0 / (double)p);
    }
}

