/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.pair;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Comparator;

public class FloatIntPair {
    public static final Comparator<FloatIntPair> FIRST_ITEM_ASCENDING_COMPARATOR = new Comparator<FloatIntPair>(){

        @Override
        public int compare(FloatIntPair o1, FloatIntPair o2) {
            if (o1.first < o2.first) {
                return -1;
            }
            if (o1.first > o2.first) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<FloatIntPair> FIRST_ITEM_DESCENDING_COMPARATOR = new Comparator<FloatIntPair>(){

        @Override
        public int compare(FloatIntPair o1, FloatIntPair o2) {
            if (o1.first < o2.first) {
                return 1;
            }
            if (o1.first > o2.first) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<FloatIntPair> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<FloatIntPair>(){

        @Override
        public int compare(FloatIntPair o1, FloatIntPair o2) {
            if (o1.second < o2.second) {
                return -1;
            }
            if (o1.second > o2.second) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<FloatIntPair> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<FloatIntPair>(){

        @Override
        public int compare(FloatIntPair o1, FloatIntPair o2) {
            if (o1.second < o2.second) {
                return 1;
            }
            if (o1.second > o2.second) {
                return -1;
            }
            return 0;
        }
    };
    public float first;
    public int second;

    public FloatIntPair(float f, int s) {
        this.first = f;
        this.second = s;
    }

    public FloatIntPair() {
    }

    public float getFirst() {
        return this.first;
    }

    public void setFirst(float first) {
        this.first = first;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public static FloatIntPair pair(float a, int b) {
        return new FloatIntPair(a, b);
    }

    public static TIntArrayList getSecond(Iterable<FloatIntPair> data) {
        TIntArrayList extracted = new TIntArrayList();
        for (FloatIntPair item : data) {
            extracted.add(item.second);
        }
        return extracted;
    }

    public static TFloatArrayList getFirst(Iterable<FloatIntPair> data) {
        TFloatArrayList extracted = new TFloatArrayList();
        for (FloatIntPair item : data) {
            extracted.add(item.first);
        }
        return extracted;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }
}

