/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.pair;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TShortArrayList;
import java.util.Comparator;

public class ShortFloatPair {
    public static final Comparator<ShortFloatPair> FIRST_ITEM_ASCENDING_COMPARATOR = new Comparator<ShortFloatPair>(){

        @Override
        public int compare(ShortFloatPair o1, ShortFloatPair o2) {
            if (o1.first < o2.first) {
                return -1;
            }
            if (o1.first > o2.first) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ShortFloatPair> FIRST_ITEM_DESCENDING_COMPARATOR = new Comparator<ShortFloatPair>(){

        @Override
        public int compare(ShortFloatPair o1, ShortFloatPair o2) {
            if (o1.first < o2.first) {
                return 1;
            }
            if (o1.first > o2.first) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<ShortFloatPair> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<ShortFloatPair>(){

        @Override
        public int compare(ShortFloatPair o1, ShortFloatPair o2) {
            if (o1.second < o2.second) {
                return -1;
            }
            if (o1.second > o2.second) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ShortFloatPair> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<ShortFloatPair>(){

        @Override
        public int compare(ShortFloatPair o1, ShortFloatPair o2) {
            if (o1.second < o2.second) {
                return 1;
            }
            if (o1.second > o2.second) {
                return -1;
            }
            return 0;
        }
    };
    public short first;
    public float second;

    public ShortFloatPair(short f, float s) {
        this.first = f;
        this.second = s;
    }

    public ShortFloatPair() {
    }

    public short getFirst() {
        return this.first;
    }

    public void setFirst(short first) {
        this.first = first;
    }

    public float getSecond() {
        return this.second;
    }

    public void setSecond(float second) {
        this.second = second;
    }

    public static ShortFloatPair pair(short a, float b) {
        return new ShortFloatPair(a, b);
    }

    public static TFloatArrayList getSecond(Iterable<ShortFloatPair> data) {
        TFloatArrayList extracted = new TFloatArrayList();
        for (ShortFloatPair item : data) {
            extracted.add(item.second);
        }
        return extracted;
    }

    public static TShortArrayList getFirst(Iterable<ShortFloatPair> data) {
        TShortArrayList extracted = new TShortArrayList();
        for (ShortFloatPair item : data) {
            extracted.add(item.first);
        }
        return extracted;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }
}

