/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.queue;

import java.util.Comparator;
import java.util.PriorityQueue;

public class InvertedPriorityQueue<T>
extends PriorityQueue<T> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;

    public InvertedPriorityQueue() {
        super(11, InvertedComparableComparator.INSTANCE);
    }

    public InvertedPriorityQueue(int initialCapacity, Comparator<? super T> comparator) {
        super(initialCapacity, comparator == null ? InvertedComparableComparator.INSTANCE : new InvertedComparator<T>(comparator));
    }

    public InvertedPriorityQueue(int initialCapacity) {
        super(initialCapacity, InvertedComparableComparator.INSTANCE);
    }

    protected Comparator<? super T> originalComparator() {
        if (this.comparator() instanceof InvertedComparator) {
            return ((InvertedComparator)this.comparator()).innerComparator;
        }
        return ComparableComparator.INSTANCE;
    }

    private static class InvertedComparator<T>
    implements Comparator<T> {
        protected Comparator<? super T> innerComparator;

        public InvertedComparator(Comparator<? super T> innerComparator) {
            this.innerComparator = innerComparator;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.innerComparator.compare(o2, o1);
        }
    }

    private static class ComparableComparator
    implements Comparator<Object> {
        public static final ComparableComparator INSTANCE = new ComparableComparator();

        private ComparableComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }

    private static class InvertedComparableComparator
    implements Comparator<Object> {
        public static final InvertedComparableComparator INSTANCE = new InvertedComparableComparator();

        private InvertedComparableComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o2).compareTo(o1);
        }
    }
}

