/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream.window;

import java.util.ArrayList;
import org.openimaj.util.function.Function;
import org.openimaj.util.stream.AbstractStream;
import org.openimaj.util.stream.Stream;
import org.openimaj.util.stream.window.Window;

public class RealTimeWindowFunction<IN>
implements Function<Stream<IN>, Stream<Window<IN, Long>>> {
    private long waitTime;
    private long currentWindowStartTime;

    public RealTimeWindowFunction(long waitTime) {
        this.waitTime = waitTime;
        this.currentWindowStartTime = -1L;
    }

    @Override
    public Stream<Window<IN, Long>> apply(final Stream<IN> inner) {
        return new AbstractStream<Window<IN, Long>>(){

            @Override
            public boolean hasNext() {
                return inner.hasNext();
            }

            @Override
            public Window<IN, Long> next() {
                RealTimeWindowFunction.this.currentWindowStartTime = System.currentTimeMillis();
                ArrayList currentWindow = new ArrayList();
                while (inner.hasNext() && System.currentTimeMillis() - RealTimeWindowFunction.this.currentWindowStartTime < RealTimeWindowFunction.this.waitTime) {
                    Object next = inner.next();
                    currentWindow.add(next);
                }
                return new Window(RealTimeWindowFunction.this.currentWindowStartTime, currentWindow);
            }
        };
    }
}

