/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationUtils;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class StringOperators {
    public static StringOperatorFactory valueOf(String fieldReference) {
        return new StringOperatorFactory(fieldReference);
    }

    public static StringOperatorFactory valueOf(AggregationExpression fieldReference) {
        return new StringOperatorFactory(fieldReference);
    }

    public static class SubstrCP
    extends AbstractAggregationExpression {
        private SubstrCP(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$substrCP";
        }

        public static SubstrCP valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new SubstrCP(SubstrCP.asFields(fieldReference));
        }

        public static SubstrCP valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new SubstrCP(Collections.singletonList(expression));
        }

        public SubstrCP substringCP(int start) {
            return this.substringCP(start, -1);
        }

        public SubstrCP substringCP(int start, int nrOfChars) {
            return new SubstrCP(this.append(Arrays.asList(start, nrOfChars)));
        }
    }

    public static class StrLenCP
    extends AbstractAggregationExpression {
        private StrLenCP(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$strLenCP";
        }

        public static StrLenCP stringLengthOfCP(String fieldReference) {
            return new StrLenCP(Fields.field(fieldReference));
        }

        public static StrLenCP stringLengthOfCP(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StrLenCP(expression);
        }
    }

    public static class StrLenBytes
    extends AbstractAggregationExpression {
        private StrLenBytes(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$strLenBytes";
        }

        public static StrLenBytes stringLengthOf(String fieldReference) {
            return new StrLenBytes(Fields.field(fieldReference));
        }

        public static StrLenBytes stringLengthOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StrLenBytes(expression);
        }
    }

    public static class Split
    extends AbstractAggregationExpression {
        private Split(List<?> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$split";
        }

        public static Split valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Split(Split.asFields(fieldReference));
        }

        public static Split valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Split(Collections.singletonList(expression));
        }

        public Split split(String delimiter) {
            Assert.notNull((Object)delimiter, (String)"Delimiter must not be null!");
            return new Split(this.append(delimiter));
        }

        public Split split(Field fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Split(this.append(fieldReference));
        }

        public Split split(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Split(this.append(expression));
        }
    }

    public static class IndexOfCP
    extends AbstractAggregationExpression {
        private IndexOfCP(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$indexOfCP";
        }

        public static SubstringBuilder valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new SubstringBuilder(Fields.field(fieldReference));
        }

        public static SubstringBuilder valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new SubstringBuilder(expression);
        }

        public IndexOfCP within(Range<Long> range) {
            return new IndexOfCP(this.append(AggregationUtils.toRangeValues(range)));
        }

        public static class SubstringBuilder {
            private final Object stringExpression;

            private SubstringBuilder(Object stringExpression) {
                this.stringExpression = stringExpression;
            }

            public IndexOfCP indexOf(String substring) {
                return new IndexOfCP(Arrays.asList(this.stringExpression, substring));
            }

            public IndexOfCP indexOf(AggregationExpression expression) {
                return new IndexOfCP(Arrays.asList(this.stringExpression, expression));
            }

            public IndexOfCP indexOf(Field fieldReference) {
                return new IndexOfCP(Arrays.asList(this.stringExpression, fieldReference));
            }
        }
    }

    public static class IndexOfBytes
    extends AbstractAggregationExpression {
        private IndexOfBytes(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$indexOfBytes";
        }

        public static SubstringBuilder valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new SubstringBuilder(Fields.field(fieldReference));
        }

        public static SubstringBuilder valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new SubstringBuilder(expression);
        }

        public IndexOfBytes within(Range<Long> range) {
            return new IndexOfBytes(this.append(AggregationUtils.toRangeValues(range)));
        }

        public static class SubstringBuilder {
            private final Object stringExpression;

            private SubstringBuilder(Object stringExpression) {
                this.stringExpression = stringExpression;
            }

            public IndexOfBytes indexOf(String substring) {
                return new IndexOfBytes(Arrays.asList(this.stringExpression, substring));
            }

            public IndexOfBytes indexOf(AggregationExpression expression) {
                return new IndexOfBytes(Arrays.asList(this.stringExpression, expression));
            }

            public IndexOfBytes indexOf(Field fieldReference) {
                return new IndexOfBytes(Arrays.asList(this.stringExpression, fieldReference));
            }
        }
    }

    public static class StrCaseCmp
    extends AbstractAggregationExpression {
        private StrCaseCmp(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$strcasecmp";
        }

        public static StrCaseCmp valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new StrCaseCmp(StrCaseCmp.asFields(fieldReference));
        }

        public static StrCaseCmp valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StrCaseCmp(Collections.singletonList(expression));
        }

        public static StrCaseCmp stringValue(String value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new StrCaseCmp(Collections.singletonList(value));
        }

        public StrCaseCmp strcasecmp(String value) {
            return new StrCaseCmp(this.append(value));
        }

        public StrCaseCmp strcasecmpValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new StrCaseCmp(this.append(Fields.field(fieldReference)));
        }

        public StrCaseCmp strcasecmpValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StrCaseCmp(this.append(expression));
        }
    }

    public static class ToUpper
    extends AbstractAggregationExpression {
        private ToUpper(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toUpper";
        }

        public static ToUpper upperValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new ToUpper(Fields.field(fieldReference));
        }

        public static ToUpper upperValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new ToUpper(Collections.singletonList(expression));
        }

        public static ToUpper upper(String value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new ToUpper(value);
        }
    }

    public static class ToLower
    extends AbstractAggregationExpression {
        private ToLower(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$toLower";
        }

        public static ToLower lowerValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new ToLower(Fields.field(fieldReference));
        }

        public static ToLower lowerValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new ToLower(Collections.singletonList(expression));
        }

        public static ToLower lower(String value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new ToLower(value);
        }
    }

    public static class Substr
    extends AbstractAggregationExpression {
        private Substr(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$substr";
        }

        public static Substr valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Substr(Substr.asFields(fieldReference));
        }

        public static Substr valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Substr(Collections.singletonList(expression));
        }

        public Substr substring(int start) {
            return this.substring(start, -1);
        }

        public Substr substring(int start, int nrOfChars) {
            return new Substr(this.append(Arrays.asList(start, nrOfChars)));
        }
    }

    public static class Concat
    extends AbstractAggregationExpression {
        private Concat(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$concat";
        }

        public static Concat valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Concat(Concat.asFields(fieldReference));
        }

        public static Concat valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Concat(Collections.singletonList(expression));
        }

        public static Concat stringValue(String value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new Concat(Collections.singletonList(value));
        }

        public Concat concatValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Concat(this.append(Fields.field(fieldReference)));
        }

        public Concat concatValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Concat(this.append(expression));
        }

        public Concat concat(String value) {
            return new Concat(this.append(value));
        }
    }

    public static class StringOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public StringOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public StringOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Concat concatValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createConcat().concatValueOf(fieldReference);
        }

        public Concat concatValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createConcat().concatValueOf(expression);
        }

        public Concat concat(String value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createConcat().concat(value);
        }

        private Concat createConcat() {
            return this.usesFieldRef() ? Concat.valueOf(this.fieldReference) : Concat.valueOf(this.expression);
        }

        public Substr substring(int start) {
            return this.substring(start, -1);
        }

        public Substr substring(int start, int nrOfChars) {
            return this.createSubstr().substring(start, nrOfChars);
        }

        private Substr createSubstr() {
            return this.usesFieldRef() ? Substr.valueOf(this.fieldReference) : Substr.valueOf(this.expression);
        }

        public ToLower toLower() {
            return this.usesFieldRef() ? ToLower.lowerValueOf(this.fieldReference) : ToLower.lowerValueOf(this.expression);
        }

        public ToUpper toUpper() {
            return this.usesFieldRef() ? ToUpper.upperValueOf(this.fieldReference) : ToUpper.upperValueOf(this.expression);
        }

        public StrCaseCmp strCaseCmp(String value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createStrCaseCmp().strcasecmp(value);
        }

        public StrCaseCmp strCaseCmpValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createStrCaseCmp().strcasecmpValueOf(fieldReference);
        }

        public StrCaseCmp strCaseCmpValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createStrCaseCmp().strcasecmpValueOf(expression);
        }

        private StrCaseCmp createStrCaseCmp() {
            return this.usesFieldRef() ? StrCaseCmp.valueOf(this.fieldReference) : StrCaseCmp.valueOf(this.expression);
        }

        public IndexOfBytes indexOf(String substring) {
            Assert.notNull((Object)substring, (String)"Substring must not be null!");
            return this.createIndexOfBytesSubstringBuilder().indexOf(substring);
        }

        public IndexOfBytes indexOf(Field fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createIndexOfBytesSubstringBuilder().indexOf(fieldReference);
        }

        public IndexOfBytes indexOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createIndexOfBytesSubstringBuilder().indexOf(expression);
        }

        private IndexOfBytes.SubstringBuilder createIndexOfBytesSubstringBuilder() {
            return this.usesFieldRef() ? IndexOfBytes.valueOf(this.fieldReference) : IndexOfBytes.valueOf(this.expression);
        }

        public IndexOfCP indexOfCP(String substring) {
            Assert.notNull((Object)substring, (String)"Substring must not be null!");
            return this.createIndexOfCPSubstringBuilder().indexOf(substring);
        }

        public IndexOfCP indexOfCP(Field fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return this.createIndexOfCPSubstringBuilder().indexOf(fieldReference);
        }

        public IndexOfCP indexOfCP(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.createIndexOfCPSubstringBuilder().indexOf(expression);
        }

        private IndexOfCP.SubstringBuilder createIndexOfCPSubstringBuilder() {
            return this.usesFieldRef() ? IndexOfCP.valueOf(this.fieldReference) : IndexOfCP.valueOf(this.expression);
        }

        public Split split(String delimiter) {
            return this.createSplit().split(delimiter);
        }

        public Split split(Field fieldReference) {
            return this.createSplit().split(fieldReference);
        }

        public Split split(AggregationExpression expression) {
            return this.createSplit().split(expression);
        }

        private Split createSplit() {
            return this.usesFieldRef() ? Split.valueOf(this.fieldReference) : Split.valueOf(this.expression);
        }

        public StrLenBytes length() {
            return this.usesFieldRef() ? StrLenBytes.stringLengthOf(this.fieldReference) : StrLenBytes.stringLengthOf(this.expression);
        }

        public StrLenCP lengthCP() {
            return this.usesFieldRef() ? StrLenCP.stringLengthOfCP(this.fieldReference) : StrLenCP.stringLengthOfCP(this.expression);
        }

        public SubstrCP substringCP(int codePointStart) {
            return this.substringCP(codePointStart, -1);
        }

        public SubstrCP substringCP(int codePointStart, int nrOfCodePoints) {
            return this.createSubstrCP().substringCP(codePointStart, nrOfCodePoints);
        }

        private SubstrCP createSubstrCP() {
            return this.usesFieldRef() ? SubstrCP.valueOf(this.fieldReference) : SubstrCP.valueOf(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }
}

