/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method;

import java.io.ByteArrayInputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.springframework.core.MethodParameter;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadSourceMethodProcessor;
import org.springframework.xml.JaxpVersion;
import org.springframework.xml.XMLInputFactoryUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SourcePayloadMethodProcessor
extends AbstractPayloadSourceMethodProcessor {
    private XMLInputFactory inputFactory = this.createXmlInputFactory();

    @Override
    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        return this.supports(parameter);
    }

    @Override
    protected Source resolveRequestPayloadArgument(MethodParameter parameter, Source requestPayload) throws Exception {
        Class parameterType = parameter.getParameterType();
        if (parameterType.isAssignableFrom(requestPayload.getClass())) {
            return requestPayload;
        }
        if (DOMSource.class.isAssignableFrom(parameterType)) {
            DOMResult domResult = new DOMResult();
            this.transform(requestPayload, domResult);
            Node node = domResult.getNode();
            if (node.getNodeType() == 9) {
                return new DOMSource(((Document)node).getDocumentElement());
            }
            return new DOMSource(domResult.getNode());
        }
        if (SAXSource.class.isAssignableFrom(parameterType)) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
            InputSource inputSource = new InputSource(bis);
            return new SAXSource(inputSource);
        }
        if (StreamSource.class.isAssignableFrom(parameterType)) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
            return new StreamSource(bis);
        }
        if (JaxpVersion.isAtLeastJaxp14() && Jaxp14StaxHandler.isStaxSource(parameterType)) {
            XMLStreamReader streamReader;
            try {
                streamReader = this.inputFactory.createXMLStreamReader(requestPayload);
            }
            catch (UnsupportedOperationException | XMLStreamException ignored) {
                streamReader = null;
            }
            if (streamReader == null) {
                ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
                streamReader = this.inputFactory.createXMLStreamReader(bis);
            }
            return Jaxp14StaxHandler.createStaxSource(streamReader, requestPayload.getSystemId());
        }
        throw new IllegalArgumentException("Unknown Source type: " + String.valueOf(parameterType));
    }

    @Override
    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        return this.supports(returnType);
    }

    @Override
    protected Source createResponsePayload(MethodParameter returnType, Object returnValue) {
        return (Source)returnValue;
    }

    private boolean supports(MethodParameter parameter) {
        return Source.class.isAssignableFrom(parameter.getParameterType());
    }

    protected XMLInputFactory createXmlInputFactory() {
        return XMLInputFactoryUtils.newInstance();
    }

    private static final class Jaxp14StaxHandler {
        private Jaxp14StaxHandler() {
        }

        private static boolean isStaxSource(Class<?> clazz) {
            return StAXSource.class.isAssignableFrom(clazz);
        }

        private static Source createStaxSource(XMLStreamReader streamReader, String systemId) {
            return new StAXSource(new SystemIdStreamReaderDelegate(streamReader, systemId));
        }
    }

    private static final class SystemIdStreamReaderDelegate
    extends StreamReaderDelegate {
        private final String systemId;

        private SystemIdStreamReaderDelegate(XMLStreamReader reader, String systemId) {
            super(reader);
            this.systemId = systemId;
        }

        @Override
        public Location getLocation() {
            final Location parentLocation = this.getParent().getLocation();
            return new Location(){

                @Override
                public int getLineNumber() {
                    return parentLocation != null ? parentLocation.getLineNumber() : -1;
                }

                @Override
                public int getColumnNumber() {
                    return parentLocation != null ? parentLocation.getColumnNumber() : -1;
                }

                @Override
                public int getCharacterOffset() {
                    return parentLocation != null ? parentLocation.getLineNumber() : -1;
                }

                @Override
                public String getPublicId() {
                    return parentLocation != null ? parentLocation.getPublicId() : null;
                }

                @Override
                public String getSystemId() {
                    return systemId;
                }
            };
        }
    }
}

