/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.server.AbstractActionMethodEndpointMapping;
import org.springframework.ws.soap.addressing.server.annotation.Action;
import org.springframework.ws.soap.addressing.server.annotation.Address;

public class AnnotationActionEndpointMapping
extends AbstractActionMethodEndpointMapping
implements SmartInitializingSingleton {
    protected Class<? extends Annotation> getEndpointAnnotationType() {
        return Endpoint.class;
    }

    @Override
    protected URI getActionForMethod(Method method) {
        Action action = method.getAnnotation(Action.class);
        if (action != null && StringUtils.hasText((String)action.value())) {
            try {
                return new URI(action.value());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Invalid Action annotation [" + action.value() + "] on [" + String.valueOf(method) + "]");
            }
        }
        return null;
    }

    @Override
    protected URI getEndpointAddress(Object endpoint) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Class<?> endpointClass = methodEndpoint.getMethod().getDeclaringClass();
        Address address = (Address)AnnotationUtils.findAnnotation(endpointClass, Address.class);
        if (address != null && StringUtils.hasText((String)address.value())) {
            return this.getActionUri(address.value(), methodEndpoint);
        }
        return null;
    }

    @Override
    protected URI getResponseAction(Object endpoint, MessageAddressingProperties map) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Action action = methodEndpoint.getMethod().getAnnotation(Action.class);
        if (action != null && StringUtils.hasText((String)action.output())) {
            return this.getActionUri(action.output(), methodEndpoint);
        }
        return super.getResponseAction(endpoint, map);
    }

    @Override
    protected URI getFaultAction(Object endpoint, MessageAddressingProperties map) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Action action = methodEndpoint.getMethod().getAnnotation(Action.class);
        if (action != null && StringUtils.hasText((String)action.fault())) {
            return this.getActionUri(action.fault(), methodEndpoint);
        }
        return super.getResponseAction(endpoint, map);
    }

    private URI getActionUri(String action, MethodEndpoint methodEndpoint) {
        try {
            return new URI(action);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid Action annotation [" + action + "] on [" + String.valueOf(methodEndpoint) + "]");
        }
    }

    public void afterSingletonsInstantiated() {
        this.getApplicationContext().getBeansWithAnnotation(this.getEndpointAnnotationType()).values().forEach(this::registerMethods);
    }
}

